// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREESORTABLE_H
#define _GTKMM_TREESORTABLE_H

#include <gtkmmconfig.h>


#include <glibmm.h>

/* $Id: treesortable.hg,v 1.8 2006/04/21 07:41:28 murrayc Exp $ */


/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// This is for including the config header before any code (such as
// the #ifndef GTKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <glibmm/interface.h>
#include <gtkmm/enums.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeiter.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
typedef struct _GtkTreeSortableIface GtkTreeSortableIface;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeSortable GtkTreeSortable;
typedef struct _GtkTreeSortableClass GtkTreeSortableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeSortable_Class; } // namespace Gtk
namespace Gtk
{

//TODO: This should maybe derive from TreeModel, because it is a prerequisite. murrayc

/**
 * @ingroup TreeView
*/

class TreeSortable : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TreeSortable CppObjectType;
  typedef TreeSortable_Class CppClassType;
  typedef GtkTreeSortable BaseObjectType;
  typedef GtkTreeSortableIface BaseClassType;

private:
  friend class TreeSortable_Class;
  static CppClassType treesortable_class_;

  // noncopyable
  TreeSortable(const TreeSortable&);
  TreeSortable& operator=(const TreeSortable&);

protected:
  TreeSortable(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit TreeSortable(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit TreeSortable(GtkTreeSortable* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TreeSortable();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTreeSortable*       gobj()       { return reinterpret_cast<GtkTreeSortable*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GtkTreeSortable* gobj() const { return reinterpret_cast<GtkTreeSortable*>(gobject_); }

private:


public:

  enum
  {
    /// See set_default_sort_func() and set_sort_column().
    DEFAULT_SORT_COLUMN_ID = -1,
    DEFAULT_UNSORTED_COLUMN_ID = -2
  }; //See GTK+ implementation.

  
  /** Fills in @a sort_column_id and @a order with the current sort column and the
   * order. It returns <tt>true</tt> unless the @a sort_column_id is 
   * Gtk::TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID or 
   * Gtk::TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID.
   * @param sort_column_id The sort column id to be filled in.
   * @param order The Gtk::SortType to be filled in.
   * @return <tt>true</tt> if the sort column is not one of the special sort
   * column ids.
   */
  bool get_sort_column_id(int& sort_column_id, SortType& order) const;

  
  /** Sets the current sort column to be @a sort_column_id. The @a sortable will
   * resort itself to reflect this change, after emitting a
   * Gtk::TreeSortable::sort-column-changed signal. @a sort_column_id may either be
   * a regular column id, or one of the following special values:
   * <variablelist>
   * <varlistentry>
   * <term>Gtk::TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID</term>
   * <listitem>the default sort function will be used, if it is set</listitem>
   * </varlistentry>
   * <varlistentry>
   * <term>Gtk::TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID</term>
   * <listitem>no sorting will occur</listitem>
   * </varlistentry>
   * </variablelist>
   * @param sort_column_id The sort column id to set.
   * @param order The sort order of the column.
   */
  void set_sort_column(const TreeModelColumnBase& sort_column_id, SortType order);
  
  /** Sets the current sort column to be @a sort_column_id. The @a sortable will
   * resort itself to reflect this change, after emitting a
   * Gtk::TreeSortable::sort-column-changed signal. @a sort_column_id may either be
   * a regular column id, or one of the following special values:
   * <variablelist>
   * <varlistentry>
   * <term>Gtk::TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID</term>
   * <listitem>the default sort function will be used, if it is set</listitem>
   * </varlistentry>
   * <varlistentry>
   * <term>Gtk::TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID</term>
   * <listitem>no sorting will occur</listitem>
   * </varlistentry>
   * </variablelist>
   * @param sort_column_id The sort column id to set.
   * @param order The sort order of the column.
   */
  void set_sort_column(int sort_column_id, SortType order);

  /** This callback should return -1 if a compares before b, 0 if they compare equal, 1 if a compares after b. 
   * For instance, int on_sort_compare(const Gtk::TreeModel::iterator& a, const Gtk::TreeModel::iterator& b);
   */
  typedef sigc::slot<int, const Gtk::TreeModel::iterator&, const Gtk::TreeModel::iterator&> SlotCompare;

  
  /** Sets the comparison function used when sorting a certain column.
   * If the current sort column is the same as @a sort_column, then the model will sort using this function.
   * @param sort_column the sort column to set the function for
   * @param slot The sorting slot callback.
   */
  void set_sort_func(const TreeModelColumnBase& sort_column, const SlotCompare& slot);

  /** Sets the comparison function used when sorting a certain column.
   * If the current sort column id is the same as @a sort_column_id, then the model will sort using this function.
   * @param sort_column_id the sort column id to set the function for
   * @param slot The sorting slot callback.
   */
  void set_sort_func(int sort_column_id, const SlotCompare& slot);

  /** Sets the default comparison function used when sorting.
   * If the current sort column id of sortable is DEFAULT_SORT_COLUMN_ID, then the model will
   * sort using this function.  See also unset_default_sort_func().
   *
   * @param slot The sorting function
   */
  void set_default_sort_func(const SlotCompare& slot);

  /** Sets the default comparison function used when sorting. See set_default_sort_func().
   *
   * After calling this method there will be no default comparison function. This means that once the model has been sorted,
   * it can't go back to the default state. In this case, when the current sort column id of sortable is
   * DEFAULT_SORT_COLUMN_ID, the model will be unsorted.
   */
  void unset_default_sort_func();

  
  /** Returns <tt>true</tt> if the model has a default sort function. This is used
   * primarily by GtkTreeViewColumns in order to determine if a model can 
   * go back to the default state, or not.
   * @return <tt>true</tt>, if the model has a default sort function.
   */
  bool has_default_sort_func() const;

  
  /** Emits a Gtk::TreeSortable::sort-column-changed signal on @a sortable.
   */
  void sort_column_changed();
  
  /**
   * @par Prototype:
   * <tt>void on_my_%sort_column_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_sort_column_changed();


protected:
    virtual bool get_sort_column_id_vfunc(int* sort_column_id, SortType* order) const;

    virtual void set_sort_column_id_vfunc(int sort_column_id, SortType order);

    virtual void set_sort_func_vfunc(int sort_column_id, GtkTreeIterCompareFunc func, void* data, GDestroyNotify destroy);

    virtual void set_default_sort_func_vfunc(GtkTreeIterCompareFunc func, void* data, GDestroyNotify destroy);

    virtual bool has_default_sort_func_vfunc() const;

    virtual void sort_column_changed_vfunc() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_sort_column_changed();


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::TreeSortable
   */
  Glib::RefPtr<Gtk::TreeSortable> wrap(GtkTreeSortable* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_TREESORTABLE_H */

