/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
/**
 * This is the base class of all widgets and a few non-widget objects.
 */
public class GtkObject extends GObject 
{
	
	protected GtkObject(Handle handle) {
		super(handle);
	}
	
    /**
     * Emits the "destroy" signal notifying all reference holders that
     * they should release the GtkObject.
     *
     * The memory for the object itself won't be deleted until its
     * reference count actually drops to 0.  This method merely asks
     * reference holders to release their references, it does not free
     * the object.
     */
    public void destroy() {
        gtk_object_destroy(getHandle());
    }
	
    /**
     * Removes the floating reference from a GtkObject, if it exists.
     * Otherwise does nothing.
     */
    public void sink() {
        gtk_object_sink( getHandle() );
    }

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_object_get_type());
	}

    native static final protected int getFlags (Handle obj);
    native static final protected void setFlags (Handle obj, int flags);
    native static final protected int gtk_object_get_type ();
    native static final protected void gtk_object_sink (Handle object);
    native static final protected void gtk_object_destroy (Handle object);

    /* Deprecated functions.
    native static final private Handle gtk_object_new(int type, String first_property_name);
    native static final private Handle gtk_object_ref(Handle object);
    native static final private void gtk_object_unref(Handle object);
    native static final private void gtk_object_weakref(Handle object, int notify, gpointer data);
    native static final private void gtk_object_weakunref(Handle object, int notify, gpointer data);
    native static final private void gtk_object_set_data(Handle object, String key, gpointer data);
    native static final private void gtk_object_set_data_full(Handle object, String key, gpointer data, int destroy);
    native static final private void gtk_object_remove_data(Handle object, String key);
    native static final private gpointer gtk_object_get_data(Handle object, String key);
    native static final private void gtk_object_remove_no_notify(Handle object, String key);
    native static final private void gtk_object_set_user_data(Handle object, gpointer data);
    native static final private gpointer gtk_object_get_user_data(Handle object);
    native static final private void gtk_object_set_data_by_id(Handle object, GQuark data_id, gpointer data);
    native static final private void gtk_object_set_data_by_id_full(Handle object, GQuark data_id, gpointer data, int destroy);
    native static final private gpointer gtk_object_get_data_by_id(Handle object, GQuark data_id);
    native static final private void gtk_object_remove_data_by_id(Handle object, GQuark data_id);
    native static final private void gtk_object_remove_no_notify_by_id(Handle object, GQuark key_id);
    native static final private void gtk_object_get(Handle object, String first_property_name);
    native static final private void gtk_object_set(Handle object, String first_property_name);
    native static final private void gtk_object_add_arg_type(String arg_name, int arg_type, int arg_flags, int arg_id);
    */
}

