/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
import org.gnu.gtk.event.ToggleActionEntryListener;

/**
 */
public class ToggleActionEntry extends Boxed {

	/**
	 * ToggleActionEntryListener objects that are interested in
	 * events for this entry.
	 */
	private List listeners = new ArrayList();
	
	public ToggleActionEntry(
			String name,
			String stockId,
			String label,
			String accel,
			String tooltip,
			boolean isActive,
			ToggleActionEntryListener listener) {

		// create the native object
		handle = allocate();
		// set the values
		setName(handle, name);
		setStockId(handle, stockId);
		setLabel(handle, label);
		setAccelerator(handle, accel);
		setToolTip(handle, tooltip);
		setActive(handle, isActive);
		if (null != listener) {
			listeners.add(listener);
		}
	}
		
	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		free(handle);
	}

	public void addListener(ToggleActionEntryListener listener) {
		listeners.add(listener);
	}

	public void removeListener(ToggleActionEntryListener listener) {
		listeners.remove(listener);
	}

	private void handleCallback(Handle action) {
		for (int i = 0; i < listeners.size(); i++) {
			ToggleActionEntryListener l = (ToggleActionEntryListener)listeners.get(i);
			l.actionEvent(new ToggleAction(action));
		}
		
	}

	native static final protected Handle allocate();
	native static final protected void free(Handle entry);
	native static final protected void setName(Handle entry, String name);
	native static final protected void setStockId(Handle entry, String stockId);
	native static final protected void setLabel(Handle entry, String label);
	native static final protected void setAccelerator(Handle entry, String accel);
	native static final protected void setToolTip(Handle entry, String tooltip);
	native static final protected void setActive(Handle entry, boolean active);
	native static final protected boolean getActive(Handle entry);
}
