/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
/**
 *
 */
public class EventButton extends Boxed 
{
	
	public EventButton(Handle handle) {
		this.handle = handle;
	}
	
	public int getButton() {
		return EventButton.getButton(handle);
	}
	
	public double getX() {
		return EventButton.getX(handle);
	}
	
	public double getY() {
		return EventButton.getY(handle);
	}
	
	public int getType() {
		return EventButton.getType(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getType (Handle obj);
    native static final protected Handle getWindow (Handle obj);
    native static final protected boolean getSendEvent (Handle obj);
    native static final protected int getTime (Handle obj);
    native static final protected double getX (Handle obj);
    native static final protected double getY (Handle obj);
    native static final protected int getState (Handle obj);
    native static final protected int getButton (Handle obj);
    native static final protected Handle getDevice (Handle obj);
    native static final protected double getXRoot (Handle obj);
    native static final protected double getYRoot (Handle obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

