/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
/**
 * A DragContext holds information about a drag in process.  It is used
 * on both source and destination sides.
 */
public class DragContext extends GObject 
{
	/**
	 * Construct a DragContext.
	 */
	public DragContext() {
		super(gdk_drag_context_new());
	}

	/**
	 * Construct a DragContext using native resources. Used internally by
	 * java-gnome
	 */
	public DragContext( Handle handle ){
		super(handle);
	}
	
	/**
	 * Return the source window.
	 */
	public Window getSource() {
	    Handle hndl = getSourceWindow(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Window)obj;
		return new Window(hndl);
	}
	
	/**
	 * Return the destination window.
	 */
	public Window getDestination() {
	    Handle hndl = getDestWindow(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Window)obj;
		return new Window(hndl);
	}
	
	/**
	 * Return the Drag Protocol
	 */
	public DragProtocol getProtocol() {
		return DragProtocol.intern(getProtocol(getHandle()));
	}
	
	/**
	 * Returns true if the context is used on the source side.
	 */
	public boolean isSource() {
		return getIsSource(getHandle());
	}
	
	/**
	 * Return the action suggested by the source.
	 */
	public DragAction getSuggestedAction() {
		return DragAction.intern(getSuggestedAction(getHandle()));
	}
	
	/**
	 * Return the action chosen by the destination.
	 */
	public DragAction getAction() {
		return DragAction.intern(getAction(getHandle()));
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getProtocol (Handle obj);
    native static final protected boolean getIsSource (Handle obj);
    native static final protected Handle getSourceWindow (Handle obj);
    native static final protected Handle getDestWindow (Handle obj);
    native static final protected int getActions (Handle obj);
    native static final protected int getSuggestedAction (Handle obj);
    native static final protected int getAction (Handle obj);
    native static final protected int gdk_drag_context_get_type ();
    native static final protected Handle gdk_drag_context_new ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

