/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  *	Some methods look ugly and unusable. Are they going to be implemented? 
  *	
  * 
  */
 
package org.gnu.gdk;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
/**
 *	
 */
public class Colormap extends GObject 
{
	
	/**
	 * Create a Colormap initialized to the system's
	 * default colormap.
	 */
	public Colormap() {
		super(Colormap.gdk_colormap_get_system());
	}
	
	/**
	 * Create a new Colormap from a handle to a native resource.
	 */
	public Colormap(Handle handle){
		super(handle);
	}
	
	/**
	*	Creates a new colormap for the given visual.
	*	
	*/
	public Colormap(org.gnu.gdk.Visual v, boolean private_){
		super(gdk_colormap_new(v.getHandle(), private_ == true ? 1 : 0));
	} 
	
	/**
	*	Returns the system's default colormap.
	*/
	public static Colormap getSystem(){
		return new Colormap(Colormap.gdk_colormap_get_system());
	}
	
	/**
	*	Returns the visual for which a given colormap was created.
	*/
	public Visual getVisual(){
	    Handle hndl = gdk_colormap_get_visual(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Visual)obj;
		return new Visual(hndl);
	}
	
	/**
	 * Allocates a single color from a colormap.
	 * 
	 * @param color The color to allocate
	 * @param writable If true the color is allocated writable.
	 * @param bestMatch If true GDK will attempt to do matching against existing
	 * colors if the color cannot be allocated as requested.
	 */
	public boolean allocateColor(Color color, boolean writable, boolean bestMatch) {
		return Colormap.gdk_colormap_alloc_color(getHandle(), color.getHandle(), writable, bestMatch);
	}
	
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_colormap_get_type ();
    native static final protected Handle gdk_colormap_new (Handle visual, int allocate);
    native static final protected Handle gdk_colormap_get_system ();
    native static final protected int gdk_colormap_alloc_colors (Handle colormap, Handle[] colors, 
        boolean writable, boolean bestMatch, boolean[] success);
    native static final protected boolean gdk_colormap_alloc_color (Handle colormap, Handle color, 
        boolean writable, boolean best_match);
    native static final protected void gdk_colormap_free_colors (Handle colormap, Handle[] colors);
    native static final protected void gdk_colormap_query_color (Handle colormap, long pixel, Handle result);
    native static final protected Handle gdk_colormap_get_visual (Handle colormap);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

