package glade.clock;

/*
 * Generated by LibGladeStubs from clock.glade
 */

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

import org.gnu.glade.LibGlade;
import org.gnu.glib.Fireable;
import org.gnu.glib.Timer;
import org.gnu.gtk.Button;
import org.gnu.gtk.FontSelectionDialog;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.Label;
import org.gnu.gtk.event.ButtonEvent;
import org.gnu.gtk.event.ButtonListener;
import org.gnu.gtk.event.GtkEvent;
import org.gnu.pango.FontDescription;

public class Clock {

    private LibGlade libglade;
    private final Timer clock;
    private final Label clockLabel;

    private static final String GLADE_FILE = "glade/clock/clock.glade";
    private static final String DEFAULT_FONT = "Sans 20";

    public Clock() throws IOException {
	libglade = new LibGlade(GLADE_FILE, this);
	clockLabel = (Label)libglade.getWidget("clockLabel");
	FontDescription fontDesc = new FontDescription(DEFAULT_FONT);
	clockLabel.setFont(fontDesc);
	setTime();

	clock = new Timer(
	    1000, new Fireable() {
		    public boolean fire() {
			setTime();
			return true;  // keep "ticking"
		    }
		});
	clock.start();
    }

    private void setTime() {
	String dateStr = DateFormat.getTimeInstance().format(new Date());
	clockLabel.setText(dateStr);
    }

    private void stop() {
	clock.stop();
	Gtk.mainQuit();
    }

    // Signal handlers, as defined in clock.glade

    /**
     * on_ClockDialog_close method to handle the "close" signal.
     *
     * @param source the widget that fired this signal
     * @param target an object defined as the target of this signal, or null.
     */
    public void on_ClockDialog_delete_event(GtkEvent event) {
	stop();
    }

    /**
     * on_fontbutton_clicked method to handle the "clicked" signal.
     *
     * @param source the widget that fired this signal
     * @param target an object defined as the target of this signal, or null.
     */
    public void on_fontbutton_clicked(GtkEvent event, Object target) {
	final FontSelectionDialog fontsel = 
	    new FontSelectionDialog("Choose Clock Font");
	Button okButton = fontsel.getOKButton();
	okButton.addListener(new ButtonListener() {
		public void buttonEvent(ButtonEvent event) {
		    if (event.isOfType(ButtonEvent.Type.CLICK)) {
			String fontname = fontsel.getFontName();
			if (fontname != null) {
			    FontDescription fontDesc = 
				new FontDescription(fontname);
			    clockLabel.setFont(fontDesc);
			}
			fontsel.destroy();
		    }
		}
	    });
	Button cancelButton = fontsel.getCancelButton();
	cancelButton.addListener(new ButtonListener() {
		public void buttonEvent(ButtonEvent event) {
		    if (event.isOfType(ButtonEvent.Type.CLICK)) {
			fontsel.destroy();
		    }
		}
	    });
	
	fontsel.show();
    }

    /**
     * on_closebutton_clicked method to handle the "clicked" signal.
     *
     * @param source the widget that fired this signal
     * @param target an object defined as the target of this signal, or null.
     */
    public void on_closebutton_clicked(GtkEvent event) {
	stop();
    }

    public static void main(String args[]) {
	Clock gui;

	Gtk.init(args);
	try {
	    gui = new Clock();
	} catch (IOException e) {
	    System.err.println(e.toString());
	    System.exit(1);
	}
	Gtk.main();
    }
}
