/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * HButtonBox is a container designed to display a collection of
 * buttons horizontally.
 * <p>
 * The main methods for manipulating this object are part of the super class
 * ButtonBox
 * @see ButtonBox
 * @see VButtonBox
 */
public class HButtonBox extends ButtonBox {

	/**
	 * Construct a new HButtonBox
	 */
	public HButtonBox() {
		super(gtk_hbutton_box_new());
	}
	
	/**
	 * Construct a new HButtonBox from a handle to a native resource.
	 */
	public HButtonBox(Handle handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hbutton_box_get_type());
	}


    native static final protected int gtk_hbutton_box_get_type ();
    native static final protected Handle gtk_hbutton_box_new ();

}

