/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * The VScale widget is a vertically slot containing a slider that
 * can be moved by the mouse.
 */
public class VScale extends Scale 
{
	/**
	 * Creates a new VScale
	 * @param adjustment The {@link Adjustment} which sets the range of the 
	 * scale.
	 */
	public VScale(Adjustment adjustment){
		super(gtk_vscale_new(adjustment.getHandle() ));
	}

	/**
	 * Creates a new vertical scale widget that lets the user input a number
	 * between min and max (including min and max) with the increment step. 
	 * Step must be nonzero; it's the distance the slider moves when using the 
	 * arrow keys to adjust the scale value.
	 * @param min Minimum value
	 * @param max Maximum value
	 * @param step Step increment (tick size) used with keyboard shortcuts
	 */
	public VScale(double min, double max, double step){
		super(gtk_vscale_new_with_range (min, max, step));
	}

	/**
	 * Construct a VScale using a handle to a native resource.
	 */
	public VScale(Handle handle) {
	    super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_vscale_get_type());
	}

    native static final protected int gtk_vscale_get_type ();
    native static final protected Handle gtk_vscale_new (Handle adjustment);
    native static final protected Handle gtk_vscale_new_with_range (double min, double max, double step);
}

