/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;

/**
 */
public class FileFilter extends GObject {
	
	/**
	 *  Creates a new FileFilter with no rules added to it.  Such a filter 
	 * doesn't accept any files, so is not particularly useful until you 
	 * add rules with addMimeType() or addPattern().
 	 */
	public FileFilter() {
		super(gtk_file_filter_new());
	}
	
	/**
	 * Create a new FileFilter from a point to a native object.
	 */
	FileFilter(Handle hndl) {
		super(hndl);
	}
	
	/**
	 * Sets the human readable name for the filter.  This is the string
	 * that will be displayed in the file selector user interface if there is
	 * a selectable list of filters.
	 * @param name The name of the filter.
	 */
	public void setName(String name) {
		gtk_file_filter_set_name(getHandle(), name);
	}
	
	/**
	 * Returns the human readable name of the file filter.
	 */
	public String getName() {
		return gtk_file_filter_get_name(getHandle());
	}
	
	/**
	 * Adds a rule allowing a given mime type to filter.
	 */
	public void addMimeType(String mimeType) {
		gtk_file_filter_add_mime_type(getHandle(), mimeType);
	}
	
	/**
	 * Adds a rule allowing a shell style glob to a filter.
	 */
	public void addPattern(String pattern) {
		gtk_file_filter_add_pattern(getHandle(), pattern);
	}
	

	native static final protected int gtk_file_filter_get_type ();
	native static final protected Handle gtk_file_filter_new();
	native static final protected void gtk_file_filter_set_name(Handle filter, String name);
	native static final protected String gtk_file_filter_get_name(Handle filter);
	native static final protected void gtk_file_filter_add_mime_type(Handle filter, String mimeType);
	native static final protected void gtk_file_filter_add_pattern(Handle filter, String pattern);
	native static final protected int gtk_file_filter_get_needed(Handle filter);
	// We currently do not have a wrapper for FileFilterInfo.
	//native static final protected boolean gtk_file_filter_filter(Handle filter, int filterInfo);

}
