/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

public class Gdk 
{
	
	public static Dimension getScreenDimension(){
		int width=Gdk.gdk_screen_width();
		int height=Gdk.gdk_screen_height();
		return new Dimension(width,height);
	}
	
	public static void beep(){
		Gdk.gdk_beep();
	}
	
	static {
		 System.loadLibrary("gtkjava2.5");
	}
		
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected void gdk_input_set_extension_events (int window, int mask, int mode);
    native static final protected void gdk_flush ();
    native static final protected String gdk_set_locale ();
    native static final protected int gdk_screen_width ();
    native static final protected int gdk_screen_height ();
    native static final protected int gdk_screen_width_mm ();
    native static final protected int gdk_screen_height_mm ();
    native static final protected void gdk_beep ();
    native static final protected void gdk_set_show_events (boolean showEvents);
    native static final protected boolean gdk_get_show_events ();
    native static final protected String gdk_keyval_name (int keyval);
    native static final protected int gdk_keyval_from_name (String keyvalName);
    native static final protected int gdk_keyval_to_upper (int keyval);
    native static final protected int gdk_keyval_to_lower (int keyval);
    native static final protected boolean gdk_keyval_is_upper (int keyval);
    native static final protected boolean gdk_keyval_is_lower (int keyval);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

