/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.GObject;
/**
 * Pango supports a flexible architecture where a particular rendering
 * architecture can supply an implementation of fonts. The PangoFont structure
 * represents an abstract rendering-system-indepent font. Pango provides
 * routines to list available fonts, and to load a font of a given description.
 */
public class Font extends GObject 
{

	/**
	 * Returns a description of the font.
	 */
	public FontDescription describe(){
		return new FontDescription( pango_font_describe(getHandle()) );
	}

	/**
	 * Computes the coverage map for a given font and language tag.
	 */
	public Coverage getCoverage(Language lang){
		return new Coverage( pango_font_get_coverage(getHandle(), lang.getHandle()) );
	}

	/**
	 * Gets overall metric information for a font. Since the metrics may be
	 * substantially different for different scripts, a language tag can be
	 * provided to indicate that the metrics should be retrieved that correspond
	 * to the script(s) used by that language.
	 */
	public FontMetrics getMetrics(Language lang){
		return new FontMetrics( pango_font_get_metrics(getHandle(), lang.getHandle()) );
	}



    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_font_get_type ();
    native static final protected int pango_font_describe (int font);
    native static final protected int pango_font_get_coverage (int font, int language);
    native static final protected int pango_font_get_metrics (int font, int language);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

