/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *   Philip A. Chapman <pchapman@pcsw.us>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:21:55 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************

     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gnome.CanvasPoints
     * Method:    gnome_canvas_points_new
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasPoints_gnome_1canvas_1points_1new (JNIEnv *env, 
        jclass cls, jint numPoints) 
    {
        gint32 numPoints_g = (gint32) numPoints;
        {
            return (jint)gnome_canvas_points_new (numPoints_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.CanvasPoints
     * Method:    gnome_canvas_points_ref
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_CanvasPoints_gnome_1canvas_1points_1ref (JNIEnv *env, 
        jclass cls, jint points) 
    {
        GnomeCanvasPoints *points_g = (GnomeCanvasPoints *)points;
        {
            return (jint)gnome_canvas_points_ref (points_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.CanvasPoints
     * Method:    gnome_canvas_points_free
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasPoints_gnome_1canvas_1points_1free (JNIEnv 
        *env, jclass cls, jint points) 
    {
        GnomeCanvasPoints *points_g = (GnomeCanvasPoints *)points;
        {
            gnome_canvas_points_free (points_g);
        }
    }

    // This function was generated by the code generator, but heavily modified.
    // FYI I basicaly needed this function and cheated.  I used the code
    // generator to generate a stub and the casting and added my own code PAC.
    /*
     * Class:     org.gnu.gnome.CanvasPoints
     * Method:    gnome_canvas_points_set_point
     * Signature: (IIDD)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_CanvasPoints_gnome_1canvas_1points_1set_1point (
        JNIEnv *env, jclass cls, jint points, jint index, jdouble x, jdouble y) 
    {
      // points are stored in an array with x and y alternating.  Thus the x
      // coordinate of point 0 is at points_g->coords[0], the y coordinate of
      // point 0 is at points_g->coords[1].  The x coordinate of point 1 is at
      // points_g->coords[2], the y coordinate of point 1 is at
      // points_g->coords[3].  Etc.
      GnomeCanvasPoints *points_g = (GnomeCanvasPoints *)points;
      gint32 index_g = (gint32) index;
      gdouble x_g = (gdouble) x;
      gdouble y_g = (gdouble) y;
      // Make sure a good index value was passed in.  We don't want to attmept
      // to access memory outside of the array.
      if (index_g > -1 && index_g < points_g->num_points) {
	gint32 xindex = index_g * 2;
	gint32 yindex = xindex + 1;
        {
	  points_g->coords[xindex] = x_g;
	  points_g->coords[yindex] = y_g;
        }
      }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
