/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventScroll_get_type (GdkEventScroll * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventScroll_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventScroll_get_type (obj_g));
}

GdkWindow * GdkEventScroll_get_window (GdkEventScroll * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventScroll_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventScroll_get_window (obj_g));
}

gboolean GdkEventScroll_get_send_event (GdkEventScroll * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventScroll_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventScroll_get_send_event (obj_g));
}

time_t GdkEventScroll_get_time (GdkEventScroll * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventScroll_getTime (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return GdkEventScroll_get_time (obj_g);
}

gdouble GdkEventScroll_get_x (GdkEventScroll * cptr) 
{
    return cptr->x;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getX
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventScroll_getX (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventScroll_get_x (obj_g));
}

gdouble GdkEventScroll_get_y (GdkEventScroll * cptr) 
{
    return cptr->y;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getY
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventScroll_getY (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventScroll_get_y (obj_g));
}

guint32 GdkEventScroll_get_state (GdkEventScroll * cptr) 
{
    return cptr->state;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventScroll_getState (JNIEnv *env, jclass cls, jobject obj)
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventScroll_get_state (obj_g));
}

GdkScrollDirection GdkEventScroll_get_direction (GdkEventScroll * cptr) 
{
    return cptr->direction;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getDirection
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventScroll_getDirection (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventScroll_get_direction (obj_g));
}

GdkDevice * GdkEventScroll_get_device (GdkEventScroll * cptr) 
{
    return cptr->device;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getDevice
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventScroll_getDevice (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventScroll_get_device (obj_g));
}

gdouble GdkEventScroll_get_x_root (GdkEventScroll * cptr) 
{
    return cptr->x_root;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getXRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventScroll_getXRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventScroll_get_x_root (obj_g));
}

gdouble GdkEventScroll_get_y_root (GdkEventScroll * cptr) 
{
    return cptr->y_root;
}

/*
 * Class:     org.gnu.gdk.EventScroll
 * Method:    getYRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventScroll_getYRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventScroll *obj_g = (GdkEventScroll *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventScroll_get_y_root (obj_g));
}


#ifdef __cplusplus
}

#endif
