/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;


/**
 * The AttrIterator object is used to represent an iterator through a 
 * List. A new iterator is created with pango_attr_list_get_iterator(). Once
 * the iterator is created, it can be advanced through the style changes in the
 * text using pango_attr_iterator_next(). At each style change, the range of the
 * current style segment and the attributes currently in effect can be queried.
 *
 *
 * todo: is this needed?
 */
public class AttrIterator extends Boxed 
{
	public AttrIterator(int handle) {
		this.handle = handle;
	}
	
	/**
	 * Advance the iterator until the next change of style.
	 * 
	 * @return false if the iterator is at the end of the list.
	 */
	public boolean next() {
		return pango_attr_iterator_next(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected void pango_attr_iterator_range (int iterator, int [] start, int []
        end);
    native static final protected boolean pango_attr_iterator_next (int iterator);
    native static final protected int pango_attr_iterator_copy (int iterator);
    native static final protected void pango_attr_iterator_destroy (int iterator);
    native static final protected int pango_attr_iterator_get (int iterator, int type);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

