/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
/**
 * A GnomeCanvasText is a GnomeCanvasItem that displays a line of text
 * of a GnomeCanvas.
 */
public class CanvasText extends CanvasItem {

	public CanvasText(CanvasGroup group) {
		super(group, gnome_canvas_text_get_type());
	}
	
	/**
	 * Constructs an instance of CanvasText from a native widget resource.
	 * @param handle The handle to the native widget.
	 */
	CanvasText(int handle) {
		super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_canvas_text_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected String getText(int cptr);
	native final protected void setText(int cptr, String text);
	native static final protected double getX(int cptr);
	native final protected void setX(int cptr, double x);
	native static final protected double getY(int cptr);
	native final protected void setY(int cptr, double y);
	native static final protected int getAnchor(int cptr);
	native final protected void setAnchor(int cptr, int anchor);
	native static final protected int getJustification(int cptr);
	native final protected void setJustification(int cptr, int justification);
	native static final protected double getClipWidth(int cptr);
	native final protected void setClipWidth(int cptr, double clip_width);
	native static final protected double getClipHeight(int cptr);
	native final protected void setClipHeight(int cptr, double clip_height);
	native static final protected long getPixel(int cptr);
	native final protected void setPixel(int cptr, long pixel);
	native static final protected int getStipple(int cptr);
	native final protected void setStipple(int cptr, int stipple);
	native static final protected int getGc(int cptr);
	native static final protected int getMaxWidth(int cptr);
	native static final protected int getHeight(int cptr);
	native static final protected boolean getClip(int cptr);
	native final protected void setClip(int cptr, boolean clip);
	native static final protected int getFontDesc(int cptr);
	native final protected void setFontDesc(int cptr, int font_desc);
	native static final protected int getAttrList(int cptr);
	native final protected void setAttrList(int cptr, int attr_list);
	native static final protected int getUnderline(int cptr);
	native final protected void setUnderline(int cptr, int underline);
	native static final protected boolean getStrikethrough(int cptr);
	native final protected void setStrikethrough(int cptr, boolean strikethrough);
	native static final protected int getRise(int cptr);
	native final protected void setRise(int cptr, int rise);
	native static final protected double getScale(int cptr);
	native final protected void setScale(int cptr, double scale);
	native static final protected int getLayout(int cptr);
	native final protected void setLayout(int cptr, int layout);
	native static final protected double getXofs(int cptr);
	native static final protected double getYofs(int cptr);
	native static final protected int getCx(int cptr);
	native static final protected int getCy(int cptr);
	native static final protected boolean getUnderlineSet(int cptr);
	native static final protected boolean getStrikeSet(int cptr);
	native static final protected boolean getRiseSet(int cptr);
	native static final protected boolean getScaleSet(int cptr);
	native static final protected int getClipCx(int cptr);
	native static final protected int getClipCy(int cptr);
	native static final protected int getClipCheight(int cptr);
	native static final protected long getRgba(int cptr);
	native static final protected int gnome_canvas_text_get_type();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
