// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMECANVASMM_PATH_DEF_H
#define _LIBGNOMECANVASMM_PATH_DEF_H

#include <glibmm.h>

/* $Id: path-def.hg,v 1.4 2002/04/04 14:04:33 aholzmann Exp $ */

/* path-def.h
 * 
 *
 * Copyright (C) 2002 The libgnomecanvasmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomecanvasmm/point.h>
#include <glibmm/containers.h>
#include <libgnomecanvas/gnome-canvas-path-def.h>
#include <libart_lgpl/art_bpath.h>
#include <libart_lgpl/art_point.h>
#include <libart_lgpl/art_bpath.h>


namespace Gnome
{

namespace Canvas
{

class PathDef
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PathDef CppObjectType;
  typedef GnomeCanvasPathDef BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<PathDef> create();

  // For use with Glib::RefPtr<> only.
  void reference()   const;
  void unreference() const;

  ///Provides access to the underlying C instance.
  GnomeCanvasPathDef*       gobj();

  ///Provides access to the underlying C instance.
  const GnomeCanvasPathDef* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GnomeCanvasPathDef* gobj_copy() const;

protected:
  // Do not derive this.  Gnome::Canvas::PathDef can neither be constructed nor deleted.
  PathDef();
  void operator delete(void*, size_t);

private:
  // noncopyable
  PathDef(const PathDef&);
  PathDef& operator=(const PathDef&);


public:
  //gtkmmproc error: gnome_canvas_path_def_new : method defs lookup failed (1)
  
  /** This funtion creates a new #gnome_canvas_path_def with @a length 
   * number of points allocated. It is useful, if you know the exact
   * number of points in path, so you can avoid automatic point
   * array reallocation.
   * @param length Number of points to allocate for the path.
   * @return The new canvas path definition.
   */
  static Glib::RefPtr<PathDef> create(int length);
  
  /** This function constructs a new #gnome_canvas_path_def and uses the
   * passed @a bpath  as the contents.  The passed bpath should not be
   * static as the path definition is editable when constructed with
   * this function. Also, passed bpath will be freed with art_free, if
   * path is destroyed, so use it with caution.
   * For constructing a #gnome_canvas_path_def
   * from (non-modifiable) bpath use
   * #gnome_canvas_path_def_new_from_static_bpath.
   * @param bpath Libart bezier path.
   * @return The new canvas path definition that is populated with the
   * passed bezier path, if the @a bpath  is bad <tt>0</tt> is returned.
   */
  static Glib::RefPtr<PathDef> create(ArtBpath& bpath);

  //GnomeCanvasPathDef * gnome_canvas_path_def_new_from_static_bpath (ArtBpath * bpath);
  //GnomeCanvasPathDef * gnome_canvas_path_def_new_from_foreign_bpath (ArtBpath * bpath);

  //GnomeCanvasPathDef * gnome_canvas_path_def_concat (const GSList * list);
  //GSList * gnome_canvas_path_def_split (const GnomeCanvasPathDef * path);
  
  /** This function creates a new GnomeCanvasPathDef that contains all of
   * the open segments on the passed @a path .
   * @return A new GnomeCanvasPathDef that contains all of the open segemtns in @a path .
   */
  Glib::RefPtr<PathDef> open_parts();
  
  /** This function returns a new GnomeCanvasPathDef that contains the
   * all of close parts of passed @a path .
   * @return A new GnomeCanvasPathDef that contains all of the closed
   * parts of passed @a path .
   */
  Glib::RefPtr<PathDef> closed_parts();
  
  /** This function closes all of the open segments in the passed path
   * and returns a new GnomeCanvasPathDef.
   * @return A GnomeCanvasPathDef that contains the contents of @a path 
   * but has modified the path is fully closed.
   */
  Glib::RefPtr<PathDef> close_all();

  
  /** Trims dynamic point array to exact length of path.
   */
  void finish();
  
  /** This function ensures that enough space for @a space  points is
   * allocated at the end of the path.
   * @param space Number of points to guarantee are allocated at the end of
   * the path.
   */
  void ensure_space(int space);

  
  /** This function clears the contents of the passed @a path .
   */
  void reset();

  
  /** This function adds starts new subpath on @a path , and sets its
   * starting point to @a x  and @a y . If current subpath is empty, it
   * simply changes its starting coordinates to new values.
   * @param x X coordinate.
   * @param y Y coordinate.
   */
  void moveto(double x, double y);
  
  /** This function add a line segment to the passed @a path  with the
   * specified @a x  and @a y  coordinates.
   * @param x X coordinate.
   * @param y Y coordinate.
   */
  void lineto(double x, double y);

  
  /** This functions adds a new line segment with loose endpoint to the path, or
   * if endpoint is already loose, changes its coordinates to @a x , @a y . You
   * can change the coordinates of loose endpoint as many times as you want,
   * the last ones set will be fixed, if you continue line. This is useful
   * for handling drawing with mouse.
   * @param x X coordinate.
   * @param y Y coordinate.
   */
  void lineto_moving(double x, double y);
  
  /** This function adds a bezier curve segment to the path definition.
   * @param x0 First control point x coordinate.
   * @param y0 First control point y coordinate.
   * @param x1 Second control point x coordinate.
   * @param y1 Second control point y coordinate.
   * @param x2 End of curve x coordinate.
   * @param y2 End of curve y coordinate.
   */
  void curveto(double x1, double y1, double x2, double y2, double x3, double y3);
  
  /** This function closes the last subpath of @a path , adding a ART_LINETO to
   * subpath starting point, if needed and changing starting pathcode to
   * ART_MOVETO
   */
  void closepath();

  
  /** This function closes the last subpath by setting the coordinates of
   * the endpoint of the last segment (line or curve) to starting point.
   */
  void closepath_current();

  Gnome::Art::Point currentpoint() const;

  
  /** This function returns a ArtBpath that consists of the path
   * definition.
   * @return ArtBpath.
   */
  ArtBpath* get_bpath() const;
  
  /** This function returns the first ArtBpath point in the definition.
   * @return ArtBpath being the first point in the path definition or
   * null if no points are defined.
   */
  ArtBpath* first_bpath() const;
  
  /** This function returns pointer to the last ArtBpath segment in the path
   * definition.
   * @return ArtBpath, being the last segment in the path definition or
   * null if no line segments have been defined.
   */
  ArtBpath* last_bpath() const;

  
  /** This function is a boolean test to see if the path is empty,
   * meaning containing no line segments.
   * @return Boolean, indicating if the path is empty.
   */
  bool is_empty() const;
  
  /** This function returns the length of the path definition.  Not
   * Euclidian length of the path but rather the number of points on the
   * path.
   * @return Integer, number of points on the path.
   */
  int length() const;
  
  /** This function is a boolean test checking to see if the path has a
   * current point defined. Current point will be set by line operators,
   * and cleared by closing subpath.
   * @return Boolean, indicating if the path has a current point defined.
   */
  bool has_currentpoint() const;
  
  /** This function returns a boolean value indicating if the path has
   * any open segments.
   * @return Boolean, indicating if the path has any open segments.
   */
  bool any_open() const;
  
  /** This function returns a boolean value indicating if the path only
   * contains open segments.
   * @return Boolean, indicating if the path has all open segments.
   */
  bool all_open() const;
  
  /** This function returns a boolean valid indicating if the path has
   * any closed segements.
   * @return Boolean, indicating if the path has any closed segments.
   */
  bool any_closed() const;
  
  /** This function returns a boolean value indicating if the path only
   * contains closed segments.
   * @return Boolean, indicating if the path has all closed segments.
   */
  bool all_closed() const;


};

} /* namespace Canvas */

} /* namespace Gnome */


namespace Glib
{

  /** @relates Gnome::Canvas::PathDef
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Canvas::PathDef> wrap(GnomeCanvasPathDef* object, bool take_copy = false);

} // namespace Glib

#endif /* _LIBGNOMECANVASMM_PATH_DEF_H */

