/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtk.event.GtkEventType;

/**
 * An event represeting change of page actions by a {@link
 * org.gnu.gnome.DruidPage} widget.
 */
public class DruidPageChangeEvent extends GtkEvent {
	/**
	 * Type of a DruidPageChangeEvent
	 */
	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}

		public static final Type NEXT = new Type(1, "NEXT");
		public static final Type BACK = new Type(2, "BACK");
		public static final Type CANCEL = new Type(3, "CANCEL");
		
	}

	
	/**
	 * Creates a new DruidPageChangeEvent. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public DruidPageChangeEvent(Object source, DruidPageChangeEvent.Type type) {
		super(source, type);
	}
	
	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(DruidPageChangeEvent.Type aType){
		return ( type.getID() == aType.getID());
	}

}
