/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */


package org.gnu.pango;
import org.gnu.glib.GObject;
/**
 * The FontFamily object is used to represent a family of related font faces.
 * The faces in a family share a common design, but differ in slant, weight,
 * width and other aspects.
 */
public class FontFamily extends GObject 
{

	/**
	 * Gets the name of the family. The name is unique among all fonts for the
	 * font backend and can be used in a PangoFontDescription to specify that a
	 * face from this family is desired.
	 */
	public String toString(){
		return pango_font_family_get_name(getHandle());
	}

	/**
	 * Lists the different font faces that make up family. The faces in a family
	 * share a common design, but differ in slant, weight, width and other
	 * aspects.
	 */
	
		


	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_font_family_get_type ();
    native static final protected void pango_font_family_list_faces (int family, int [] faces, int []
        numFaces);
    native static final protected String pango_font_family_get_name (int family);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

