/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;

import org.gnu.glib.Boxed;
import org.gnu.gtk.event.ToggleActionEntryListener;

/**
 */
public class ToggleActionEntry extends Boxed {

	/**
	 * ToggleActionEntryListener objects that are interested in
	 * events for this entry.
	 */
	private List listeners = new ArrayList();
	
	public ToggleActionEntry(
			String name,
			String stockId,
			String label,
			String accel,
			String tooltip,
			boolean isActive,
			ToggleActionEntryListener listener) {

		// create the native object
		handle = allocate();
		// set the values
		setName(handle, name);
		setStockId(handle, stockId);
		setLabel(handle, label);
		setAccelerator(handle, accel);
		setTooltip(handle, tooltip);
		setActive(handle, isActive);
		if (null != listener) {
			listeners.add(listener);
		}
	}
		
	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		free(handle);
	}

	public void addListener(ToggleActionEntryListener listener) {
		listeners.add(listener);
	}

	public void removeListener(ToggleActionEntryListener listener) {
		listeners.remove(listener);
	}

	private void handleCallback(int action) {
		for (int i = 0; i < listeners.size(); i++) {
			ToggleActionEntryListener l = (ToggleActionEntryListener)listeners.get(i);
			l.actionEvent(new ToggleAction(action));
		}
		
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int allocate();
	native static final protected void free(int entry);
	native static final protected void setName(int entry, String name);
	native static final protected void setStockId(int entry, String stockId);
	native static final protected void setLabel(int entry, String label);
	native static final protected void setAccelerator(int entry, String accel);
	native static final protected void setTooltip(int entry, String tooltip);
	native static final protected void setActive(int entry, boolean active);
	native static final protected boolean getActive(int entry);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
