/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gconf/gconf.h>

#ifndef _Included_org_gnu_gconf_ConfMetaInfo
#define _Included_org_gnu_gconf_ConfMetaInfo
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gconf_meta_info_new();
}

/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1free
  (JNIEnv *env, jclass cls, jint mi)
{
	gconf_meta_info_free((GConfMetaInfo*)mi);
}

/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_get_schema
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1get_1schema
  (JNIEnv *env, jclass cls, jint mi)
{
	return (*env)->NewStringUTF(env, gconf_meta_info_get_schema((GConfMetaInfo*)mi));
}

/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_get_mod_user
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1get_1mod_1user
  (JNIEnv *env, jclass cls, jint mi)
{
	return (*env)->NewStringUTF(env, gconf_meta_info_get_mod_user((GConfMetaInfo*)mi));
}

/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_get_mod_time
 * Signature: (I)J
 */
JNIEXPORT jlong JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1get_1mod_1time
  (JNIEnv *env, jclass cls, jint mi)
{
	return (jlong)gconf_meta_info_mod_time((GConfMetaInfo*)mi);
}

/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_set_schema
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1set_1schema
  (JNIEnv *env, jclass cls, jint mi, jstring schema)
{
	gchar *str = (gchar*)(*env)->GetStringUTFChars(env, schema, NULL);
	gconf_meta_info_set_schema((GConfMetaInfo*)mi, str);
	(*env)->ReleaseStringUTFChars(env, schema, str);
}

/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_set_mod_user
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1set_1mod_1user
  (JNIEnv *env, jclass cls, jint mi, jstring user)
 {
	gchar *str = (gchar*)(*env)->GetStringUTFChars(env, user, NULL);
	gconf_meta_info_set_mod_user((GConfMetaInfo*)mi, str);
	(*env)->ReleaseStringUTFChars(env, user, str);
 }

/*
 * Class:     org_gnu_gconf_ConfMetaInfo
 * Method:    gconf_meta_info_set_mod_time
 * Signature: (IJ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfMetaInfo_gconf_1meta_1info_1set_1mod_1time
  (JNIEnv *env, jclass cls, jint mi, jlong time)
{
	gconf_meta_info_set_mod_time((GConfMetaInfo*)mi, (GTime)time);
}

#ifdef __cplusplus
}
#endif
#endif
