// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GCONFMM_CHANGESET_H
#define _GCONFMM_CHANGESET_H

#include <glibmm.h>

// -*- Mode: C++; c-basic-offset: 4  -*-
/* $Id: changeset.hg,v 1.2 2002/12/10 23:12:11 murrayc Exp $ */

/* changeset.hg 
 * 
 * Copyright (C) 2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/ustring.h>
#include <gconfmm/value.h>
#include <gconfmm/setinterface.h>
#include <sigc++/slot.h>


extern "C" {
    typedef struct _GConfChangeSet GConfChangeSet;
}

namespace Gnome
{
namespace Conf
{


/** A ChangeSet is a set of changes to the GConf database that can be commited
 * and reversed easily. The changes can be both set and unset operations.
 * Currently the ChangeSet operations are not atomic, and not specially optimized
 * for. However, it is suitable for use, for instance, preferences dialogs.
 * 
 * The set*() methods do not throw errors, they simply store the keys and the values.
 * 
 * @see Client::change_set_from_current(), Client::change_set_commit(), 
 *      Client::change_set_reverse().
 */
class ChangeSet : public SetInterface
{
    public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ChangeSet CppObjectType;
  typedef GConfChangeSet BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

    
public:
    ChangeSet();
    explicit ChangeSet(GConfChangeSet* castitem, bool make_a_copy = false);

    ChangeSet(const ChangeSet& src);
    ChangeSet& operator=(const ChangeSet& src);
    virtual ~ChangeSet();

    GConfChangeSet*       gobj()       { return gobject_; }
    const GConfChangeSet* gobj() const { return gobject_; }
    GConfChangeSet* gobj_copy() const;

protected:
    GConfChangeSet* gobject_;

public:
    /** Clear all entries.
     * After this method, commiting the changeset is a no-op. */
    
  void clear();

    /** Returns the number of keys in the changeset. */
    
  unsigned int size() const;

    /** Remove the specified key from the changeset.
     * This means that the given key will not be modified by a commit. */
    
  void remove(const Glib::ustring& key);

    /** Check whether the given key will be modified by a commit operation.
     * @return 0 if the key will not be modified, else the modified value.
     * Remember to delete the Value. */
    Value* exists(const Glib::ustring& key) const;
    

    /** Unset the given key. 
     * Mark the key, so that it will be removed from the configuration database during a commit. */
    
  void unset(const Glib::ustring& key);

    
  void set(const Glib::ustring& key, bool what);
    
  void set(const Glib::ustring& key, int what);
    
  void set(const Glib::ustring& key, double what);
    
  void set(const Glib::ustring& key, const Glib::ustring& what);
    
  void set(const Glib::ustring& key, const Schema& val);

    
  void set(const Glib::ustring& key, const Value& what);
    
    
    typedef sigc::slot<void, const Glib::ustring&, const Value&> ForeachSlot;
    /** Iterate over the keys marked in this ChangeSet.
     * Calls @p slot for each key-value pair that is marked in the ChangeSet.
     * Keys marked unset will have a Value with type VALUE_INVALID.
     */
    void for_each(const ForeachSlot& slot);
    
private:
    static GConfChangeSet* do_ref(GConfChangeSet*);


};


} // namespace Conf
} // namespace Gnome

#endif /* _GCONFMM_CHANGESET_H */

