// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_NOTEBOOK_H
#define _GTKMM_NOTEBOOK_H

#include <glibmm.h>

/* $Id: notebook.hg,v 1.9 2004/02/14 13:52:00 murrayc Exp $ */

/* notebook.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/label.h>
#include <gtk/gtknotebook.h>
#include <glibmm/helperlist.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkNotebook GtkNotebook;
typedef struct _GtkNotebookClass GtkNotebookClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Notebook_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum NotebookTab
{
  NOTEBOOK_TAB_FIRST,
  NOTEBOOK_TAB_LAST
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::NotebookTab> : public Glib::Value_Enum<Gtk::NotebookTab>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class Notebook;

namespace Notebook_Helpers
{
/*********************************************************************
***** Elem classes
*********************************************************************/

class Page;

/* Since the data stored in GtkNotebook's GList is inaccessible
 * the iterator "PageIterator" has to hold a pointer to the Notebook
 * that owns the list. "Page" (the value_type of "PageList")
 * inherits "PageIterator" privately and uses Notebook-API-functions
 * to retrieve and manipulate data.
 *
 * Note that PageIterator uses g_list_* functions just to step through
 * the children and test for iterator equality instead of simply using
 * the child index number. This is done because even if you use a
 * child index number, you would still have to use g_list_length() to
 * retrieve the number of elements.  And using an element index results
 * in iterators not staying valid on insertion/removal. This would only
 * lead to fragile and unexpected behaviour.
 * (Thanks for this explanation, Daniel!)
 */
class PageIterator
{
public:
  typedef std::bidirectional_iterator_tag iterator_category;
  typedef size_t size_type;
  typedef ptrdiff_t difference_type;

  typedef Page        value_type;
  typedef const Page* pointer;
  typedef const Page& reference;

  PageIterator(Gtk::Notebook* parent, GList* node) : node_(node), parent_(parent) {}
  PageIterator()                                   : node_(0),    parent_(0)      {}

  bool equal(const PageIterator& other) const;
  operator bool() const;

  PageIterator&      operator++();
  const PageIterator operator++(int);

  PageIterator&      operator--();
  const PageIterator operator--(int);

  inline reference operator*()  const;
  inline pointer   operator->() const;

protected:
  GList*         node_;
  Gtk::Notebook* parent_;

  friend class Gtk::Notebook_Helpers::Page;
};

/** @relates Gtk::Notebook_Helpers::PageIterator */
inline bool operator==(const PageIterator& lhs, const PageIterator& rhs)
  { return lhs.equal(rhs); }

/** @relates Gtk::Notebook_Helpers::PageIterator */
inline bool operator!=(const PageIterator& lhs, const PageIterator& rhs)
  { return !lhs.equal(rhs); }


// Page is the output class
class Page : public PageIterator
{
protected:
  Page();
private:
  Page& operator=(const Page&);

public:
  int get_page_num() const;
  Widget* get_child() const;
  Widget* get_tab_label() const;
  void set_tab_label(Widget& tab_label);
  void set_tab_label_text(const Glib::ustring& tab_text);
  Glib::ustring get_tab_label_text() const;
  Widget* get_menu_label() const;
  void set_menu_label(Widget& menu_label);
  void set_menu_label_text(const Glib::ustring& menu_text);
  Glib::ustring get_menu_label_text() const;
  void query_tab_label_packing(bool& expand, bool& fill, PackType& pack_type);
  void set_tab_label_packing(bool expand, bool fill, PackType pack_type);
};


// Element is the input class
class PageList;

class Element
{
public:
  Element(Widget* child, Widget* tab, Widget* menu);
  Element(Widget& child, Widget& tab, Widget& menu);
  explicit Element(Widget& child);

protected:
  friend class PageList;
  Widget* child_;
  Widget* tab_;
  Widget* menu_;
};

// Just a widget without a tab
typedef Element WidgetElem;

struct TabElem : public Element
{
  TabElem(Widget& child, Widget& tab);
  TabElem(Widget& child, const Glib::ustring& label, bool mnemonic = false);
};

struct MenuElem : public Element
{
  MenuElem(Widget& child, Widget& menu);
};

/*********************************************************************
***** List properties
*********************************************************************/

/** An STL-style container for pages in a Gtk::Notebook.
 *
 */
class PageList
{
public:
  PageList();
  explicit PageList(GtkNotebook* gparent);
  PageList(const PageList& src);

  PageList& operator=(const PageList& src);

  typedef Page  value_type;
  typedef Page& reference;
  typedef const Page& const_reference;

  typedef PageIterator iterator;
  typedef Glib::List_ConstIterator<iterator> const_iterator;
  typedef Glib::List_ReverseIterator<iterator> reverse_iterator;
  typedef Glib::List_ConstIterator<reverse_iterator> const_reverse_iterator;

  typedef const Element element_type;

  typedef size_t difference_type;
  typedef size_t size_type;

  inline GtkNotebook* gparent()
    { return gparent_; }
  inline const GtkNotebook* gparent() const
    { return gparent_; }

  size_type size() const;

  size_type max_size() const;
  bool empty() const;

  inline iterator begin()
    { return begin_(); }
  inline iterator end()
    { return end_(); }

  inline const_iterator begin() const
    { return const_iterator(begin_()); }
  inline const_iterator end() const
    { return const_iterator(end_()); }

  inline reverse_iterator rbegin()
    { return reverse_iterator(end_()); }
  inline reverse_iterator rend()
    { return reverse_iterator(begin_()); }

  inline const_reverse_iterator rbegin() const
    { return const_reverse_iterator(reverse_iterator(end_())); }
  inline const_reverse_iterator rend() const
    { return const_reverse_iterator(reverse_iterator(begin_())); }

  value_type front() const;
  value_type back() const;

  value_type operator[](size_type l) const;

  iterator insert(iterator position, element_type& e); //custom-implemented.

  template <class InputIterator>
  inline void insert(iterator position, InputIterator first, InputIterator last)
  {
    for(;first != last; ++first)
      position = insert(position, *first);
  }

  inline void push_front(element_type& e)
    { insert(begin(), e); }
  inline void push_back(element_type& e)
    { insert(end(), e); }

  void erase(iterator start, iterator stop);
  iterator erase(iterator);
  void remove(const_reference child);
  void remove(Widget& w);

  void reorder(iterator loc, iterator page); // Non-standard

  iterator find(int num);
  iterator find(const_reference c);
  iterator find(Widget& w);
  iterator find(GtkNotebookPage* t);

  inline void pop_front()
    { erase(begin()); }
  inline void pop_back()
    { erase(--end()); }

  void clear();

protected:
  iterator begin_() const;
  iterator end_() const;

  GtkNotebook* gparent_;
};

} /* Notebook_Helpers */

/** Container which shows one of its children at a time, in tabbed windows.
 *
 * The Gtk::Notebook widget is a Gtk::Container whose children are pages that
 * can be switched between using tab labels along one edge. 
 *
 * You can use the PageList returned by pages() as any normal STL container
 * to manipulate the pages.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class Notebook : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Notebook CppObjectType;
  typedef Notebook_Class CppClassType;
  typedef GtkNotebook BaseObjectType;
  typedef GtkNotebookClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Notebook();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Notebook_Class;
  static CppClassType notebook_class_;

  // noncopyable
  Notebook(const Notebook&);
  Notebook& operator=(const Notebook&);

protected:
  explicit Notebook(const Glib::ConstructParams& construct_params);
  explicit Notebook(GtkNotebook* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkNotebook*       gobj()       { return reinterpret_cast<GtkNotebook*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkNotebook* gobj() const { return reinterpret_cast<GtkNotebook*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_switch_page(GtkNotebookPage* page, guint page_num);


private:

  
public:
  typedef Notebook_Helpers::PageList PageList;

  Notebook();

  
  /** Prepends a page to @a notebook .
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   */
  int prepend_page(Widget& child, Widget& tab_label);
  int prepend_page(Widget& child);

  int prepend_page(Widget& child, const Glib::ustring& tab_label, bool use_mnemonic = false);
  
  /** Prepends a page to @a notebook , specifying the widget to use as the
   * label in the popup menu.
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   * @param menu_label The widget to use as a label for the page-switch
   * menu.
   */
  int prepend_page(Widget& child, Widget& tab_label, Widget& menu_label);
  //Ignore the possible-0 menu_label version of this method. It would have the same signature as another method.
 
  int prepend_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, bool use_mnemonic);

  
  /** Appends a page to @a notebook .
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   */
  int append_page(Widget& child, Widget& tab_label);
  int append_page(Widget& child);
  int append_page(Widget& child, const Glib::ustring& tab_label, bool use_mnemonic = false);

  
  /** Appends a page to @a notebook , specifying the widget to use as the
   * label in the popup menu.
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   * @param menu_label The widget to use as a label for the page-switch
   * menu.
   */
  int append_page(Widget& child, Widget& tab_label, Widget& menu_label);
  //Ignore the possible-0 menu_label version of this method. It would have the same signature as another method.
  
  int append_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, bool use_mnemonic = false);

  
  /** Insert a page into @a notebook  at the given position
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   * @param position The index (starting at 0) at which to insert the page,
   * or -1 to append the page after all other pages.
   */
  int insert_page(Widget& child, Widget& tab_label, int position);
  int insert_page(Widget& child, int position);
 
  int insert_page(Widget& child, const Glib::ustring& tab_label, int position, bool use_mnemonic = false);
  
  /** Insert a page into @a notebook  at the given position, specifying
   * the widget to use as the label in the popup menu.
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page..
   * @param menu_label The widget to use as a label for the page-switch
   * menu.
   * @param position The index (starting at 0) at which to insert the page,
   * or -1 to append the page after all other pages.
   */
  int insert_page(Widget& child, Widget& tab_label, Widget& menu_label, int position);
  //Ignore the possible-0 menu_label version of this method. It would have the same signature as another method.
 
  int insert_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, int position, bool use_mnemonic = false);

  
  /** Removes a page from the notebook given its index
   * in the notebook.
   * @param page_num The index of a notebook page, starting
   * from 0. If -1, the last page will
   * be removed.
   */
  void remove_page(int page_num = 0);
  void remove_page(Widget& child);

  
  /** Returns the page number of the current page.
   * @return The index (starting from 0) of the current
   * page in the notebook. If the notebook has no pages, then
   * -1 will be returned.
   */
  int get_current_page() const;
  
  /** Returns the child widget contained in page number @a page_num .
   * @param page_num The index of a page in the noteobok, or -1
   * to get the last page.
   * @return The child widget, or <tt>0</tt> if @a page_num  is
   * out of bounds.
   */
  Widget* get_nth_page(int page_num);
  
  /** Returns the child widget contained in page number @a page_num .
   * @param page_num The index of a page in the noteobok, or -1
   * to get the last page.
   * @return The child widget, or <tt>0</tt> if @a page_num  is
   * out of bounds.
   */
  const Widget* get_nth_page(int page_num) const;
  
  /** Gets the number of pages in a notebook.
   * @return The number of pages in the notebook.
   * 
   * Since: 2.2.
   */
  int get_n_pages();
  /*Widget* get_current_page();*/ /*inconsistency with set_current_page*/
  
  /** Finds the index of the page which contains the given child
   * widget.
   * @param child A Gtk::Widget.
   * @return The index of the page containing @a child , or
   * -1 if @a child  is not in the notebook.
   */
  int page_num(const Widget& child);

  
  /** Switches to the page number @a page_num .
   * @param page_num Index of the page to switch to, starting from 0.
   * If negative, the last page will be used. If greater
   * than the number of pages in the notebook, nothing
   * will be done.
   */
  void set_current_page(int page_number);
  
  /** Switches to the next page. Nothing happens if the current page is
   * the last page.
   */
  void next_page();
  
  /** Switches to the previous page. Nothing happens if the current page
   * is the first page.
   */
  void prev_page();

  
  /** Sets whether a bevel will be drawn around the notebook pages.
   * This only has a visual effect when the tabs are not shown.
   * See set_show_tabs().
   * @param show_border <tt>true</tt> if a bevel should be drawn around the notebook.
   */
  void set_show_border(bool show_border = true);

  
  /** Returns whether a bevel will be drawn around the notebook pages. See
   * set_show_border().
   * @return <tt>true</tt> if the bevel is drawn.
   */
  bool get_show_border() const;
  
  /** Sets whether to show the tabs for the notebook or not.
   * @param show_tabs <tt>true</tt> if the tabs should be shown.
   */
  void set_show_tabs(bool show_tabs = true);
  
  /** Returns whether the tabs of the notebook are shown. See
   * set_show_tabs().
   * @return <tt>true</tt> if the tabs are shown.
   */
  bool get_show_tabs() const;


  /** Sets the edge at which the tabs for switching pages in the
   * notebook are drawn.
   * @param pos The edge to draw the tabs at.
   */
  void set_tab_pos(PositionType pos);
  
  /** Gets the edge at which the tabs for switching pages in the
   * notebook are drawn.
   * @return The edge at which the tabs are drawn.
   */
  PositionType get_tab_pos() const;

  
  /** Sets whether the tab label area will have arrows for scrolling if
   * there are too many tabs to fit in the area.
   * @param scrollable <tt>true</tt> if scroll arrows should be added.
   */
  void set_scrollable(bool scrollable = true);
  
  /** Returns whether the tab label area has arrows for scrolling. See
   * set_scrollable().
   * @return <tt>true</tt> if arrows for scrolling are present.
   */
  bool get_scrollable() const;

  
  /** Enables the popup menu: if the user clicks with the right mouse button on
   * the bookmarks, a menu with all the pages will be popped up.
   */
  void popup_enable();

  
  /** Disables the popup menu.
   */
  void popup_disable();


  /** Returns the tab label widget for the page @a child . <tt>0</tt> is returned
   * if @a child  is not in @a notebook  or if no tab label has specifically
   * been set for @a child .
   * @param child The page.
   * @return The tab label.
   */
  Widget* get_tab_label(Widget& child);
  
  /** Returns the tab label widget for the page @a child . <tt>0</tt> is returned
   * if @a child  is not in @a notebook  or if no tab label has specifically
   * been set for @a child .
   * @param child The page.
   * @return The tab label.
   */
  const Widget* get_tab_label(Widget& child) const;
  
  /** Changes the tab label for @a child . If <tt>0</tt> is specified
   * for @a tab_label , then the page will have the label 'page N'.
   * @param child The page.
   * @param tab_label The tab label widget to use, or <tt>0</tt> for default tab
   * label.
   */
  void set_tab_label(Widget& child, Widget& tab_label);
  
  /** Creates a new label and sets it as the tab label for the page
   * containing @a child .
   * @param child The page.
   * @param tab_text The label text.
   */
  void set_tab_label_text(Widget& child, const Glib::ustring& tab_text);
  
  /** Retrieves the text of the tab label for the page containing
   *  @a child .
   * @param child A widget contained in a page of @a notebook .
   * @return Value: the text of the tab label.
   */
  Glib::ustring get_tab_label_text(Widget& child) const;
  
  /** Retrieves the menu label widget of the page containing @a child .
   * @param child A widget contained in a page of @a notebook .
   * @return The menu label, or <tt>0</tt> if the
   * notebook page does not have a menu label other
   * than the default (the tab label).
   */
  Widget* get_menu_label(Widget& child);
  
  /** Retrieves the menu label widget of the page containing @a child .
   * @param child A widget contained in a page of @a notebook .
   * @return The menu label, or <tt>0</tt> if the
   * notebook page does not have a menu label other
   * than the default (the tab label).
   */
  const Widget* get_menu_label(Widget& child) const;
  
  /** Changes the menu label for the page containing @a child .
   * @param child The child widget.
   * @param menu_label The menu label, or <tt>0</tt> for default.
   */
  void set_menu_label(Widget& child, Widget& menu_label);
  
  /** Creates a new label and sets it as the menu label of @a child .
   * @param child The child widget.
   * @param menu_text The label text.
   */
  void set_menu_label_text(Widget& child, const Glib::ustring& menu_text);
  
  /** Retrieves the text of the menu label for the page containing
   *  @a child .
   * @param child The child widget of a page of the notebook.
   * @return Value: the text of the tab label.
   */
  Glib::ustring get_menu_label_text(Widget& child) const;
  void query_tab_label_packing(Widget& child, bool& expand, bool& fill, PackType& pack_type);
  
  
  /** Sets the packing parameters for the tab label of the page
   * containing @a child . See Gtk::Box::pack_start() for the exact meaning
   * of the parameters.
   * @param child The child widget.
   * @param expand Whether to expand the bookmark or not.
   * @param fill Whether the bookmark should fill the allocated area or not.
   * @param pack_type The position of the bookmark.
   */
  void set_tab_label_packing(Widget& child, bool expand, bool fill, PackType pack_type);
  
  /** Reorders the page containing @a child , so that it appears in position
   *  @a position . If @a position  is greater than or equal to the number of
   * children in the list or negative, @a child  will be moved to the end
   * of the list.
   * @param child The child to move.
   * @param position The new position, or -1 to move to the end.
   */
  void reorder_child(Widget& child, int position);


  PageList::iterator get_current();

  PageList& pages();
  const PageList& pages() const;

  
  Glib::SignalProxy2< void,GtkNotebookPage*,guint > signal_switch_page();


  //Key-binding signals:
  
  
    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PositionType> property_tab_pos() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PositionType> property_tab_pos() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_tabs() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_tabs() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_border() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_border() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_scrollable() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_scrollable() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<guint> property_tab_border() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_tab_border() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_tab_hborder() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_tab_hborder() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_tab_vborder() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_tab_vborder() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_page() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_page() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_enable_popup() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_enable_popup() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_homogeneous() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_homogeneous() const;


protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  mutable PageList pages_proxy_;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


};


#ifndef DOXYGEN_SHOULD_SKIP_THIS

namespace Notebook_Helpers
{

/**** PageIterator **************************************************/

inline
PageIterator::reference PageIterator::operator*() const 
{ 
  return static_cast<const Page&>(*this);
}

inline
PageIterator::pointer PageIterator::operator->() const
{ 
  return static_cast<const Page*>(this);
}

} /* Notebook_Helpers */

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Notebook
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Notebook* wrap(GtkNotebook* object, bool take_copy = false);
}
#endif /* _GTKMM_NOTEBOOK_H */

