// Generated by gtkmmproc -- DO NOT MODIFY!

#include <libgnomevfsmm/mime-application.h>
#include <libgnomevfsmm/private/mime-application_p.h>

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfsmm/private.h>

namespace Gnome
{

namespace Vfs
{

MimeApplication::MimeApplication(const Glib::ustring& id)
: gobject_( gnome_vfs_mime_application_new_from_id(id.c_str()) )
{  
}

MimeApplication::MimeApplication(const Glib::ustring& id, const Glib::ustring& name,
      const Glib::ustring& command, MimeApplicationArgumentType argument_type, 
      ListHandleStrings supported_uri_schemes, bool multiple_files, bool requires_terminal)
{
  gobject_ = g_new0(GnomeVFSMimeApplication, 1);
  
  gobject_->id = g_strdup(id.c_str());
  gobject_->name = g_strdup(name.c_str());
  gobject_->command = g_strdup(command.c_str());
  gobject_->expects_uris = static_cast<GnomeVFSMimeApplicationArgumentType>(argument_type);
  gobject_->supported_uri_schemes = supported_uri_schemes.data();
  gobject_->can_open_multiple_files = multiple_files;
  gobject_->requires_terminal = requires_terminal;
}

MimeApplication::operator bool() const
{
  return ( gobj() != 0 );
}

bool MimeApplication::can_open_multiple_files() const
{
  return gobj()->can_open_multiple_files;
}

bool MimeApplication::requires_terminal() const
{
  return gobj()->requires_terminal;
}

void MimeApplication::set_open_multiple_files(bool value)
{
  gobj()->can_open_multiple_files = value;
}

void MimeApplication::set_requires_terminal(bool value)
{
  gobj()->requires_terminal = value;
}

bool MimeApplication::exists_in_registry()
{
  return gnome_vfs_application_registry_exists(gobj()->id);
}

void MimeApplication::remove_from_registry()
{
  gnome_vfs_application_registry_remove_application(gobj()->id);
}

ListHandleStrings MimeApplication::get_keys()
{
  GList* pList = gnome_vfs_application_registry_get_keys(gobj()->id);
  return ListHandleStrings(pList, Glib::OWNERSHIP_SHALLOW);
}

ListHandleStrings MimeApplication::get_mime_types()
{
  GList* pList = gnome_vfs_application_registry_get_mime_types(gobj()->id);
  return ListHandleStrings(pList, Glib::OWNERSHIP_SHALLOW);
}

void MimeApplication::clear_mime_types()
{
  gnome_vfs_application_registry_clear_mime_types(gobj()->id);
}

bool MimeApplication::supports_mime_type(const Glib::ustring& mime_type)
{
  return gnome_vfs_application_registry_supports_mime_type(gobj()->id, mime_type.c_str());
}

bool MimeApplication::supports_uri_scheme(const Glib::ustring& uri_scheme)
{
  return gnome_vfs_application_registry_supports_uri_scheme(gobj()->id, uri_scheme.c_str());
}

Glib::ustring MimeApplication::get_value(const Glib::ustring& key)
{
  return Glib::convert_const_gchar_ptr_to_ustring(gnome_vfs_application_registry_peek_value(gobj()->id, key.c_str()));
}

bool MimeApplication::get_value(const Glib::ustring& key, bool& got_key)
{
  gboolean returnBool, pointerBool;
  returnBool = gnome_vfs_application_registry_get_bool_value(gobj()->id, key.c_str(), &pointerBool);
  got_key = (pointerBool != FALSE);
  return returnBool;
}

void MimeApplication::set_value(const Glib::ustring& key, const Glib::ustring& value)
{
  gnome_vfs_application_registry_set_value(gobj()->id, key.c_str(), value.c_str());
}

void MimeApplication::set_value(const Glib::ustring& key, bool value)
{
  gnome_vfs_application_registry_set_bool_value(gobj()->id, key.c_str(), value);
}

void MimeApplication::unset_key(const Glib::ustring& key)
{
  gnome_vfs_application_registry_unset_key(gobj()->id, key.c_str());
}

void MimeApplication::add_mime_type(const Glib::ustring& mime_type)
{
  gnome_vfs_application_registry_add_mime_type(gobj()->id, mime_type.c_str());
}

void MimeApplication::remove_mime_type(const Glib::ustring& mime_type)
{
  gnome_vfs_application_registry_remove_mime_type(gobj()->id, mime_type.c_str());
}

void MimeApplication::set_default(const Glib::ustring& mime_type) throw(exception)
{
  GnomeVFSResult result = gnome_vfs_mime_set_default_application(mime_type.c_str(), gobj()->id);
  handle_result(result);
}

void MimeApplication::add_to_short_list(const Glib::ustring& mime_type) throw(exception)
{
  GnomeVFSResult result = gnome_vfs_mime_add_application_to_short_list(mime_type.c_str(), gobj()->id);
  handle_result(result);
}

void MimeApplication::remove_from_short_list(const Glib::ustring& mime_type) throw(exception)
{
  GnomeVFSResult result = gnome_vfs_mime_remove_application_from_short_list(mime_type.c_str(), gobj()->id);
  handle_result(result);
}

void MimeApplication::launch(const Glib::ListHandle<Glib::ustring>& uris) throw(exception)
{
  GnomeVFSResult result = gnome_vfs_mime_application_launch(gobj(), uris.data());
  handle_result(result);
}

void MimeApplication::launch(const Glib::ListHandle<Glib::ustring>& uris, const Glib::ustring& envp) throw(exception)
{
  const char* temp_str = envp.c_str();
  GnomeVFSResult result = gnome_vfs_mime_application_launch_with_env(gobj(), uris.data(), const_cast<char**>(&temp_str));
  handle_result(result);
}

} //namespace Vfs

} //namespace Gnome


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Vfs::MimeApplication wrap(GnomeVFSMimeApplication* object, bool take_copy /* = false */)
{
  return Gnome::Vfs::MimeApplication(object, take_copy);
}

} // namespace Glib


namespace Gnome
{

namespace Vfs
{


MimeApplication::MimeApplication()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

MimeApplication::MimeApplication(const MimeApplication& src)
:
  gobject_ ((src.gobject_) ? gnome_vfs_mime_application_copy(src.gobject_) : 0)
{}

MimeApplication::MimeApplication(GnomeVFSMimeApplication* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = gnome_vfs_mime_application_copy(castitem);
    else
      gobject_ = 0;
  }
}

MimeApplication& MimeApplication::operator=(const MimeApplication& src)
{
  GnomeVFSMimeApplication *const new_gobject = (src.gobject_) ? gnome_vfs_mime_application_copy(src.gobject_) : 0;

  if(gobject_)
    gnome_vfs_mime_application_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

MimeApplication::~MimeApplication()
{
  if(gobject_)
    gnome_vfs_mime_application_free(gobject_);
}

GnomeVFSMimeApplication* MimeApplication::gobj_copy() const
{
  return gnome_vfs_mime_application_copy(gobject_);
}


Glib::ustring MimeApplication::get_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->id);
}

Glib::ustring MimeApplication::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->name);
}

Glib::ustring MimeApplication::get_command() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->command);
}

MimeApplicationArgumentType MimeApplication::get_argument_type() const
{
  return (MimeApplicationArgumentType)(gobj()->expects_uris);
}

Glib::ListHandle<Glib::ustring> MimeApplication::get_supported_uri_schemes() const
{
  return Glib::ListHandle<Glib::ustring>(gobj()->supported_uri_schemes, Glib::OWNERSHIP_SHALLOW);
}

void MimeApplication::set_id(const Glib::ustring& value)
{
  gobj()->id = const_cast<char*>(value.c_str());
}

void MimeApplication::set_name(const Glib::ustring& value)
{
  gobj()->name = const_cast<char*>(value.c_str());
}

void MimeApplication::set_command(const Glib::ustring& value)
{
  gobj()->command = const_cast<char*>(value.c_str());
}

void MimeApplication::set_argument_type(const MimeApplicationArgumentType& value)
{
  gobj()->expects_uris = (GnomeVFSMimeApplicationArgumentType)(value);
}

void MimeApplication::set_supported_uri_schemes(const Glib::ListHandle<Glib::ustring>& value)
{
  gobj()->supported_uri_schemes = value.data();
}

bool MimeApplication::is_user_owned()
{
  return gnome_vfs_application_is_user_owned_application(gobj());
}

void MimeApplication::save_to_registry()
{
  gnome_vfs_application_registry_save_mime_application(gobj());
}


} // namespace Vfs

} // namespace Gnome


