// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLBAR_H
#define _GTKMM_TOOLBAR_H

#include <glibmm.h>

/* $Id: toolbar.hg,v 1.9 2004/02/10 14:50:12 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/toolitem.h>
#include <glibmm/helperlist.h>
#include <gtkmm/container.h>
#include <gtkmm/stockid.h>

#include <gtkmm/toolbar_elements.h> //deprecated helper API


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToolbar GtkToolbar;
typedef struct _GtkToolbarClass GtkToolbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Toolbar_Class; } // namespace Gtk
namespace Gtk
{


/** @defgroup Toolbars Toolbar classes
 */

class Toolbar;
class RadioButtonGroup;

namespace Toolbar_Helpers
{

//Forward declaration, needed when GTKMM_DISABLE_DEPRECATED is defined.
class ToolList;

#ifndef GTKMM_DISABLE_DEPRECATED

 
//TODO: I think that we must deprecate ToolList because we must deprecate Tool because it
//derives from the deprecated GtkToolBarChild. Or maybe we can reimplement it in another way.
//murrayc
  
  
class ToolList : public Glib::HelperList< Tool, const Element, Glib::List_Iterator< Tool > >
{
public:
  ToolList();
  explicit ToolList(GtkToolbar* gparent);
  ToolList(const ToolList& src);
  virtual ~ToolList() {}

  ToolList& operator=(const ToolList& src);

  typedef Glib::HelperList< Tool, const Element,  Glib::List_Iterator< Tool > > type_base;

  GtkToolbar* gparent();
  const GtkToolbar* gparent() const;

  virtual GList*& glist() const;      // front of list

  virtual void erase(iterator start, iterator stop);
  virtual iterator erase(iterator);  //Implented as custom or by LIST_CONTAINER_REMOVE
  virtual void remove(const_reference); //Implented as custom or by LIST_CONTAINER_REMOVE

  /// This is order n. (use at own risk)
  reference operator[](size_type l) const;

public:
  iterator insert(iterator position, element_type& e); //custom-implemented.

  template <class InputIterator>
  inline void insert(iterator position, InputIterator first, InputIterator last)
  {
    for(;first != last; ++first)
      position = insert(position, *first);
  }

 inline void push_front(element_type& e)
    { insert(begin(), e); }
  inline void push_back(element_type& e)
    { insert(end(), e); }


  //The standard iterator, instead of List_Cpp_Iterator,
  //only works because Child is derived from GtkToolbarChild.

  virtual void remove(Widget& widget);
  
  iterator find(const_reference c);
  iterator find(Widget&);

  };


#endif //GTKMM_DISABLE_DEPRECATED

} //namespace Toolbar_Helpers


/** Bars of buttons and other widgets.
 * The STL-style container is available via the tools() method.
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup Toolbars
 */

class Toolbar : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Toolbar CppObjectType;
  typedef Toolbar_Class CppClassType;
  typedef GtkToolbar BaseObjectType;
  typedef GtkToolbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Toolbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Toolbar_Class;
  static CppClassType toolbar_class_;

  // noncopyable
  Toolbar(const Toolbar&);
  Toolbar& operator=(const Toolbar&);

protected:
  explicit Toolbar(const Glib::ConstructParams& construct_params);
  explicit Toolbar(GtkToolbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkToolbar*       gobj()       { return reinterpret_cast<GtkToolbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkToolbar* gobj() const { return reinterpret_cast<GtkToolbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_orientation_changed(Orientation orientation);
  virtual void on_toolbar_style_changed(ToolbarStyle style);
  virtual bool on_popup_context_menu(int x, int y, int button_number);


private:

public:

#ifndef GTKMM_DISABLE_DEPRECATED
  typedef Toolbar_Helpers::ToolList ToolList;
#endif //GTKMM_DISABLE_DEPRECATED

  Toolbar();

  //TODO: Add sigc::Slot parameter as well?
  
  /** Insert a Gtk::ToolItem into the toolbar at position @a pos . If @a pos  is
   * 0 the item is prepended to the start of the toolbar. If @a pos  is
   * negative, the item is appended to the end of the toolbar.
   * 
   * Since: 2.4
   * @param item A Gtk::ToolItem.
   * @param pos The position of the new item.
   */
  void insert(ToolItem& item, int pos);
  void append(ToolItem& item);
  void prepend(ToolItem& item);
  
  
  /** Returns the position of @a item  on the toolbar, starting from 0.
   * It is an error if @a item  is not a child of the toolbar.
   * @param item A Gtk::ToolItem that is a child of @a toolbar .
   * @return The position of item on the toolbar.
   * 
   * Since: 2.4.
   */
  int get_item_index(const ToolItem& item);
  
  /** Returns the number of items on the toolbar.
   * @return The number of items on the toolbar
   * 
   * Since: 2.4.
   */
  int get_n_items() const;
  
  /** Returns the @a n &lt;!-- --&gt;'s item on @a toolbar , or <tt>0</tt> if the
   * toolbar does not contain an @a n &lt;!-- --&gt;'th item.
   * @param n A position on the toolbar.
   * @return The @a n &lt;!-- --&gt;'th Gtk::ToolItem on @a toolbar , or <tt>0</tt> if there
   * isn't an @a n &lt;!-- --&gt;th item.
   * 
   * Since: 2.4.
   */
  ToolItem* get_nth_item(int n);
  
  /** Returns the @a n &lt;!-- --&gt;'s item on @a toolbar , or <tt>0</tt> if the
   * toolbar does not contain an @a n &lt;!-- --&gt;'th item.
   * @param n A position on the toolbar.
   * @return The @a n &lt;!-- --&gt;'th Gtk::ToolItem on @a toolbar , or <tt>0</tt> if there
   * isn't an @a n &lt;!-- --&gt;th item.
   * 
   * Since: 2.4.
   */
  const ToolItem* get_nth_item(int n) const;
  
  /** Returns whether the toolbar has an overflow menu.
   * See set_show_arrow()
   * @return Since: 2.4.
   */
  bool get_show_arrow() const;
  
  /** Sets whether to show an overflow menu when
   *  @a toolbar  doesn't have room for all items on it. If <tt>true</tt>,
   * items that there are not room are available through an
   * overflow menu.
   * 
   * Since: 2.4
   * @param show_arrow Whether to show an overflow menu.
   */
  void set_show_arrow(bool show_arrow = true);


/* Style methods */
  
  /** Sets whether a toolbar should appear horizontally or vertically.
   * @param orientation A new Gtk::Orientation.
   */
  void set_orientation(Orientation orientation);
  
  /** Retrieves the current orientation of the toolbar. See
   * set_orientation().
   * @return The orientation.
   */
  Orientation get_orientation() const;

  
  /** Alters the view of @a toolbar  to display either icons only, text only, or both.
   * @param style The new style for @a toolbar .
   */
  void set_toolbar_style(ToolbarStyle style);
  
  /** Retrieves whether the toolbar has text, icons, or both . See
   * set_style().
   * @return The current style of @a toolbar .
   */
  ToolbarStyle get_toolbar_style() const;

  
  /** Sets if the tooltips of a toolbar should be active or not.
   * @param enable Set to <tt>false</tt> to disable the tooltips, or <tt>true</tt> to enable them.
   */
  void set_tooltips(bool enable = true);
  
  /** Retrieves whether tooltips are enabled. See
   * set_tooltips().
   * @return <tt>true</tt> if tooltips are enabled.
   */
  bool get_tooltips() const;

  
  /** This function sets the size of stock icons in the toolbar. You
   * can call it both before you add the icons and after they've been
   * added. The size you set will override user preferences for the default
   * icon size.
   * @param icon_size The Gtk::IconSize that stock icons in the toolbar shall have.
   */
  void set_icon_size(IconSize icon_size);
  
  /** Retrieves the icon size fo the toolbar. See set_icon_size().
   * @return The current icon size for the icons on the toolbar.
   */
  IconSize get_icon_size() const;

  
  /** Unsets a toolbar style set with set_style(), so that
   * user preferences will be used to determine the toolbar style.
   */
  void unset_toolbar_style();
  
  /** Unsets toolbar icon size set with set_icon_size(), so that
   * user preferences will be used to determine the icon size.
   */
  void unset_icon_size();
 
  
  /** Returns the relief style of buttons on @a toolbar . See
   * gtk_button_set_relief_style().
   * @return The relief style of buttons on @a toolbar .
   * 
   * Since: 2.4.
   */
  ReliefStyle get_relief_style() const;
  
  /** Returns the position corresponding to the indicated point on
   *  @a toolbar . This is useful when dragging items to the toolbar:
   * this function returns the position a new item should be
   * inserted.
   * 
   *  @a x  and @a y  are in @a toolbar  coordinates.
   * @param x X coordinate of a point on the toolbar.
   * @param y Y coordinate of a point on the toolbar.
   * @return The position corresponding to the point ( @a x , @a y ) on the toolbar.
   * 
   * Since: 2.4.
   */
  int get_drop4_index(int x, int y) const;
  
  /** Highlights @a toolbar  to give an idea of what it would look like
   * if @a item  was added to @a toolbar  at position indicated by @a index . If @a item 
   * is <tt>0</tt>, highlighting is turned off. In that case @a index  is ignored.
   * 
   * The @a tool_item  passed to this function must not be part of any widget
   * hierarchy. When an item is set as drop highlight item it can not
   * added to any widget hierarchy or used as highlight item for another
   * toolbar.
   * 
   * Since: 2.4
   * @param item A Gtk::ToolItem, or <tt>0</tt> to turn of highlighting.
   * @param index A position on @a toolbar .
   */
  void set_drop_highlight_item(ToolItem& tool_item, int index);
  void unset_drop_highlight_item();


  #ifndef GTKMM_DISABLE_DEPRECATED

  ///STL-style container.
  ToolList& tools();
  
  ///STL-style container.
  const ToolList& tools() const;

  typedef Toolbar_Helpers::Callback0 Callback0;
  Gtk::Widget* append_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Gtk::Widget& icon, Callback0 slot);
  Gtk::Widget* append_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot);
  
    
  Gtk::Widget* prepend_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Gtk::Widget& icon, Callback0 slot);
  Gtk::Widget* prepend_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot);
  
    
  Gtk::Widget* insert_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Gtk::Widget& icon, Callback0 slot,
    int position);
  Gtk::Widget* insert_item(const Glib::ustring& text, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot,
    int position);
  

  Gtk::Widget* insert_stock(const Gtk::StockID& stock_id, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text,
    Callback0 slot,
    int position);
  

  /** Adds a new space to the end of the toolbar.
   */
  void append_space();
  
  /** Adds a new space to the beginning of the toolbar.
   */
  void prepend_space();
  
  /** Inserts a new space in the toolbar at the specified position.
   * @param position The number of widgets after which a space should be inserted.
   */
  void insert_space(int position);
  
  /** Removes a space from the specified position.
   * @param position The index of the space to remove.
   */
  void remove_space(int position);

  
  /** Adds a widget to the end of the given toolbar.
   * @param widget A Gtk::Widget to add to the toolbar.
   * @param tooltip_text The element's tooltip.
   * @param tooltip_private_text Used for context-sensitive help about this toolbar element.
   */
  void append_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text = Glib::ustring(), const Glib::ustring& tooltip_private_text = Glib::ustring());
  
  /** Adds a widget to the beginning of the given toolbar.
   * @param widget A Gtk::Widget to add to the toolbar.
   * @param tooltip_text The element's tooltip.
   * @param tooltip_private_text Used for context-sensitive help about this toolbar element.
   */
  void prepend_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text = Glib::ustring(), const Glib::ustring& tooltip_private_text = Glib::ustring());
  
  /** Inserts a widget in the toolbar at the given position.
   * @param widget A Gtk::Widget to add to the toolbar.
   * @param tooltip_text The element's tooltip.
   * @param tooltip_private_text Used for context-sensitive help about this toolbar element.
   * @param position The number of widgets to insert this widget after.
   */
  void insert_widget(Gtk::Widget& widget, const Glib::ustring& tooltip_text, const Glib::ustring& tooltip_private_text, int position);

  //Let's not wrap gtk_toolbar_*_element(), because they don't do anything extra, and it's an unclear API.
  

  #endif //GTKMM_DISABLE_DEPRECATED

  //TODO: Is this the same as Container::children().size()?
  //_MEMBER_GET(num_children, num_children, int, gint)

  //There is already set/get_orientation():
  //_MEMBER_GET(orientation, orientation, GtkOrientation, Orientation)

  //There is already set/get_toolbar_style():
  //_MEMBER_GET(style, style, GtkToolbarStyle, ToolbarStyle)

  //There is already set/get_icon_size():
  //_MEMBER_GET(icon_size, icon_size, int, gint)

  
  Glib::SignalProxy1< void,Orientation > signal_orientation_changed();

  
  Glib::SignalProxy1< void,ToolbarStyle > signal_toolbar_style_changed();

  
  Glib::SignalProxy3< bool,int,int,int > signal_popup_context_menu();

  
    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Orientation> property_orientation() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Orientation> property_orientation() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ToolbarStyle> property_toolbar_style() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ToolbarStyle> property_toolbar_style() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_arrow() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_arrow() const;


protected:
  //deprecated:
  //We use a pointer, because that allows us only to declare the type
  //with a prototype, so we can deprecate the type.
  typedef std::auto_ptr<Toolbar_Helpers::ToolList> tools_proxy_ptr_type;
  mutable tools_proxy_ptr_type tools_proxy_;


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Toolbar
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Toolbar* wrap(GtkToolbar* object, bool take_copy = false);
}
#endif /* _GTKMM_TOOLBAR_H */

