/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_FontButton
#define _Included_org_gnu_gtk_FontButton
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024LifeCycleListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024FocusListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024KeyListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024MouseListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragDestinationListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragSourceListener */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024ContainerListener */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024ButtonListener */
/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_font_button_get_type();
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_font_button_new();
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_new_with_font
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1new_1with_1font
  (JNIEnv *env, jclass cls, jstring font)
{
	const gchar* f = (*env)->GetStringUTFChars(env, font, NULL);
	jint ret = (jint)gtk_font_button_new_with_font(f);
	(*env)->ReleaseStringUTFChars(env, font, f);
	return ret;
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_get_title
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1get_1title
  (JNIEnv *env, jclass cls, jint fb)
{
	const gchar* ret = gtk_font_button_get_title((GtkFontButton*)fb);
	return (*env)->NewStringUTF(env, ret);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_set_title
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1set_1title
  (JNIEnv *env, jclass cls, jint fb, jstring title)
{
	const gchar* t = (*env)->GetStringUTFChars(env, title, NULL);
	gtk_font_button_set_title((GtkFontButton*)fb, t);
	(*env)->ReleaseStringUTFChars(env, title, t);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_get_use_font
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1get_1use_1font
  (JNIEnv *env, jclass cls, jint fb)
{
	return (jboolean)gtk_font_button_get_use_font((GtkFontButton*)fb);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_set_use_font
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1set_1use_1font
  (JNIEnv *env, jclass cls, jint fb, jboolean val)
{
	gtk_font_button_set_use_font((GtkFontButton*)fb, (gboolean)val);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_get_use_size
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1get_1use_1size
  (JNIEnv *env, jclass cls, jint fb)
{
	return (jboolean)gtk_font_button_get_use_size((GtkFontButton*)fb);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_set_use_size
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1set_1use_1size
  (JNIEnv *env, jclass cls, jint fb, jboolean val)
{
	gtk_font_button_set_use_size((GtkFontButton*)fb, (gboolean)val);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_get_font_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1get_1font_1name
  (JNIEnv *env, jclass cls, jint fb)
{
	return (*env)->NewStringUTF(env, gtk_font_button_get_font_name((GtkFontButton*)fb));
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_set_font_name
 * Signature: (ILjava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1set_1font_1name
  (JNIEnv *env, jclass cls, jint fb, jstring font)
{
	const gchar* f = (*env)->GetStringUTFChars(env, font, NULL);
	jboolean ret = (jboolean)gtk_font_button_set_font_name((GtkFontButton*)fb, f);
	(*env)->ReleaseStringUTFChars(env, font, f);
	return ret;
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_get_show_style
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1get_1show_1style
  (JNIEnv *env, jclass cls, jint fb)
{
	return (jboolean)gtk_font_button_get_show_style((GtkFontButton*)fb);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_set_show_style
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1set_1show_1style
  (JNIEnv *env, jclass cls, jint fb, jboolean val)
{
	gtk_font_button_set_show_style((GtkFontButton*)fb, (gboolean)val);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_get_show_size
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1get_1show_1size
  (JNIEnv *env, jclass cls, jint fb)
{
	return (jboolean)gtk_font_button_get_show_size((GtkFontButton*)fb);
}

/*
 * Class:     org_gnu_gtk_FontButton
 * Method:    gtk_font_button_set_show_size
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_FontButton_gtk_1font_1button_1set_1show_1size
  (JNIEnv *env, jclass cls, jint fb, jboolean val)
{
	gtk_font_button_set_show_size((GtkFontButton*)fb, (gboolean)val);
}

#ifdef __cplusplus
}
#endif
#endif
