/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

/**
 */
public class ToggleAction extends Action {

	public ToggleAction() {
		if (-1 != handle)
			handle = allocate();
	}
	
	ToggleAction(int handle) {
		super(handle);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		free(handle);
	}

	public void setActive(boolean active) {
		gtk_toggle_action_set_active(handle, active);
	}
	
	public boolean getActive() {
		return gtk_toggle_action_get_active(handle);
	}
	
	public void setDrawAsRadio(boolean drawAsRadio) {
		gtk_toggle_action_set_draw_as_radio(handle, drawAsRadio);
	}
	
	public boolean getDrawAsRadio() {
		return gtk_toggle_action_get_draw_as_radio(handle);
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_toggle_action_get_type ();
	native static final protected void gtk_toggle_action_toggled(int action);
	native static final protected void gtk_toggle_action_set_active(int action, boolean isActive);
	native static final protected boolean gtk_toggle_action_get_active(int action);
	native static final protected void gtk_toggle_action_set_draw_as_radio(int action, boolean radio);
	native static final protected boolean gtk_toggle_action_get_draw_as_radio(int action);
	native static protected int allocate();
	native static protected void free(int action);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
