/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:40 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * A RadioMenuItem is a CheckMenuItem that belongs to a group.
 * At each instant exactly one of the RadioMenuItems from the
 * group is selected.
 */
public class RadioMenuItem extends CheckMenuItem {

	/**
	 * Create a new RadioMenuItem object adding it to the same <i>group</i>
	 * as the provided RadioMenuItem.  If this is the first RadioMenuItem
	 * pass <code>null</code> for this parameter.
	 * 
	 * @param group A RadioMenuItem that belongs to the group that we wish
	 * to add this newly constructed RadioMenuItem to.  If this is the first
	 * RadioMenuItem in the group just pass <code>null</code>.
	 * @param label The text label to assign to this RadioButton.
	 * @param hasMnemonic An indicator to inform the widget if the label
	 * contains a mnemonic.
	 */
	public RadioMenuItem(RadioMenuItem group, String label, boolean hasMnemonic) {
		int groupHandle = 0;
		if (null != group) {
			groupHandle = group.getHandle();
		}
		if (hasMnemonic) {
			gtk_radio_menu_item_new_with_mnemonic(groupHandle, label);
		} else {
			gtk_radio_menu_item_new_with_label(groupHandle, label);
		}
		initializeEventHandlers();
	}
	
	/**
	 * Construct a RadioMenuItem using a handle to a native resource.
	 */
	public RadioMenuItem(int handle) {
	    super(handle);
	}

	protected void noopInit() {}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_radio_menu_item_get_type());
	}

    native static final protected int gtk_radio_menu_item_new_with_label(int group, String label);
    native static final protected int gtk_radio_menu_item_new_with_mnemonic(int group, String label);
	
	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_radio_menu_item_get_type();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
