/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:13 EDT
 */
 
 /*
  * TODO:
  * Everything but the constructor.
  */

package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 * Image represents an area for drawing graphics.
 */
public class Image extends GObject 
{
	
	public Image(int handle){
		this.handle=handle;
	}
	
	/**
	 * Create a new Image.
	 */
	public Image(ImageType type, Visual visual, int width, int height) {
		handle = gdk_image_new(type.getValue(), visual.getHandle(), width, height);
	}
	
	/**
	 * Retrieves the colormap for a given image.
	 */
	public Colormap getColormap() {
		return new Colormap(gdk_image_get_colormap(handle));
	}
	
	/**
	 * Sets the colormap for the image.
	 */
	public void setColormap(Colormap cmap) {
		gdk_image_set_colormap(handle, cmap.getHandle());
	}
	
	
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getVisual (int obj);
    native static final protected int getByteOrder (int obj);
    native static final protected int getWidth (int obj);
    native static final protected int getHeight (int obj);
    native static final protected int getDepth (int obj);
    native static final protected int getBpp (int obj);
    native static final protected int getBpl (int obj);
    native static final protected int getBitsPerPixel (int obj);
    native static final protected int gdk_image_get_type ();
    native static final protected int gdk_image_new (int type, int visual, int width, int height);
    native static final protected void gdk_image_put_pixel (int image, int x, int y, int pixel);
    native static final protected int gdk_image_get_pixel (int image, int x, int y);
    native static final protected void gdk_image_set_colormap (int image, int colormap);
    native static final protected int gdk_image_get_colormap (int image);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

