/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:36 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * A single RadioButton performs the same basic function as a {@link CheckButton},
 * as it's position in the object hierarchy reflects.  It is only when
 * multiple RadioButtons are grouped together that they become a different
 * user interface component.
 * <p>
 * Every RadioButton is a member of some group of RadioButtons.  When
 * one is selected, all of the other RadioButtons in the same group are
 * deselected.
 * <p>
 * A RadioButton is created by the constructor passing a <code>null</code>
 * value for the RadioButton objection for the first object, and the First
 * object as a parameter for the remaining objects.
 */
public class RadioButton extends CheckButton {
	
	/**
	 * Create a new RadioButton object adding it to the same <i>group</i>
	 * as the provided RadioButton.  If this is the first RadioButton
	 * pass <code>null</code> for this parameter.
	 * 
	 * @param group A RadioButton that belongs to the group that we wish
	 * to add this newly constructed RadioButton to.  If this is the first
	 * RadioButton in the group just pass <code>null</code>.
	 */
	public RadioButton(RadioButton group) {
		if (null == group) {
			handle = gtk_radio_button_new();
		} else {
			handle = RadioButton.gtk_radio_button_new_from_widget(group.getHandle());
		}
		initializeEventHandlers();
	}
	
	/**
	 * Create a new RadioButton object adding it to the same <i>group</i>
	 * as the provided RadioButton.  If this is the first RadioButton
	 * pass <code>null</code> for this parameter.
	 * 
	 * @param group A RadioButton that belongs to the group that we wish
	 * to add this newly constructed RadioButton to.  If this is the first
	 * RadioButton in the group just pass <code>null</code>.
	 * @param label The text label to assign to this RadioButton.
	 * @param hasMnemonic An indicator to inform the widget if the label
	 * contains a mnemonic.
	 */
	public RadioButton(RadioButton group, String label, boolean hasMnemonic) {
		if (hasMnemonic) {
			if (null == group) {
				handle = gtk_radio_button_new_with_mnemonic_without_widget(label);
			}else{
				handle = gtk_radio_button_new_with_mnemonic_from_widget(group.getHandle(), label);
			}
		} else {
			if (null == group) {
				handle = gtk_radio_button_new_with_mnemonic_without_widget(label);
			}else{
				handle = gtk_radio_button_new_with_label_from_widget(group.getHandle(), label);
			}
		}
		initializeEventHandlers();
	}
	
	/**
	 * Construct a radio button using a handle to a native resource.
	 */
	public RadioButton(int handle) {
	    super(handle);
	}

	protected void noopInit() {}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_radio_button_get_type());
	}

    native static final protected int gtk_radio_button_new();
	native static final protected int gtk_radio_button_new_with_label_without_widget( String label);
	native static final protected int gtk_radio_button_new_with_mnemonic_without_widget( String label);

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_radio_button_get_type();
	native static final protected int gtk_radio_button_new_from_widget(int group);
	native static final protected int gtk_radio_button_new_with_label_from_widget(int group, String label);
	native static final protected int gtk_radio_button_new_with_mnemonic_from_widget(int group, String label);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
