/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-01 07:00:27 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/

    gchar * GdkDevice_get_name (GdkDevice * cptr) 
    {
        return cptr->name;
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    getName
     * Signature: (I)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Device_getName (JNIEnv *env, jclass cls, jint obj)
    {
        GdkDevice *obj_g = (GdkDevice *)obj;
        gchar *result_g = GdkDevice_get_name (obj_g);
        jstring result = (*env)->NewStringUTF(env, result_g);
        return result;
    }

    GdkInputSource GdkDevice_get_source (GdkDevice * cptr) 
    {
        return cptr->source;
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    getSource
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Device_getSource (JNIEnv *env, jclass cls, jint obj) 
    {
        GdkDevice *obj_g = (GdkDevice *)obj;
        {
            jint result_j = (jint) (GdkDevice_get_source (obj_g));
            return result_j;
        }
    }

    GdkInputMode GdkDevice_get_mode (GdkDevice * cptr) 
    {
        return cptr->mode;
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    getMode
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Device_getMode (JNIEnv *env, jclass cls, jint obj) 
    {
        GdkDevice *obj_g = (GdkDevice *)obj;
        {
            jint result_j = (jint) (GdkDevice_get_mode (obj_g));
            return result_j;
        }
    }

    gboolean GdkDevice_get_has_cursor (GdkDevice * cptr) 
    {
        return cptr->has_cursor;
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    getHasCursor
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Device_getHasCursor (JNIEnv *env, jclass cls, jint 
        obj) 
    {
        GdkDevice *obj_g = (GdkDevice *)obj;
        {
            jboolean result_j = (jboolean) (GdkDevice_get_has_cursor (obj_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_device_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Device_gdk_1device_1get_1type (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gdk_device_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_devices_list
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Device_gdk_1devices_1list (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gdk_devices_list ();
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_device_set_source
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Device_gdk_1device_1set_1source (JNIEnv *env, jclass 
        cls, jint device, jint source) 
    {
        GdkDevice *device_g = (GdkDevice *)device;
        GdkInputSource source_g = (GdkInputSource) source;
        {
            gdk_device_set_source (device_g, source_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_device_set_mode
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Device_gdk_1device_1set_1mode (JNIEnv *env, jclass cls, 
        jint device, jint mode) 
    {
        GdkDevice *device_g = (GdkDevice *)device;
        GdkInputMode mode_g = (GdkInputMode) mode;
        {
            gdk_device_set_mode (device_g, mode_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_device_set_key
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Device_gdk_1device_1set_1key (JNIEnv *env, jclass cls, 
        jint device, jint index, jint keyval, jint modifiers) 
    {
        GdkDevice *device_g = (GdkDevice *)device;
        gint32 index_g = (gint32) index;
        gint32 keyval_g = (gint32) keyval;
        GdkModifierType modifiers_g = (GdkModifierType) modifiers;
        {
            gdk_device_set_key (device_g, index_g, keyval_g, modifiers_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_device_set_axis_use
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Device_gdk_1device_1set_1axis_1use (JNIEnv *env, jclass 
        cls, jint device, jint index, jint use) 
    {
        GdkDevice *device_g = (GdkDevice *)device;
        gint32 index_g = (gint32) index;
        GdkAxisUse use_g = (GdkAxisUse) use;
        {
            gdk_device_set_axis_use (device_g, index_g, use_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_device_get_axis
     * Signature: (I[Ldouble ;I[Ldouble ;)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Device_gdk_1device_1get_1axis (JNIEnv *env, jclass 
        cls, jint device, jdoubleArray axes, jint use, jdoubleArray value) 
    {
        GdkDevice *device_g = (GdkDevice *)device;
        gdouble *axes_g = (gdouble *) (*env)->GetDoubleArrayElements (env, axes, NULL);
        GdkAxisUse use_g = (GdkAxisUse) use;
        gdouble *value_g = (gdouble *) (*env)->GetDoubleArrayElements (env, value, NULL);
        {
            jboolean result_j = (jboolean) (gdk_device_get_axis (device_g, axes_g, use_g, value_g));
            (*env)->ReleaseDoubleArrayElements (env, axes, (jdouble *) axes_g, 0);
            (*env)->ReleaseDoubleArrayElements (env, value, (jdouble *) value_g, 0);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.Device
     * Method:    gdk_device_get_core_pointer
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Device_gdk_1device_1get_1core_1pointer (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)gdk_device_get_core_pointer ();
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
