/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:03 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
import org.gnu.gtk.VBox;
/**
 * This widget provides an entry box with history and a button which can pop up a
 * file selector dialog box.  It also accepts DND drops from the filemanager and 
 * other sources.
 */
public class FileEntry extends VBox {
	/**
	 * Create a new FileEntry widget
	 */
	public FileEntry(String historyID, String browseDialogTitle) {
		handle = gnome_file_entry_new(historyID, browseDialogTitle);
		initializeEventHandlers();
	}

	protected FileEntry() {
	}

	/**
	 * Construct a new FileEntry from a handle to a native resource.
	 */
	public FileEntry(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {
	}

	/**
	 * Returns the Gnome Entry widget.
	 */
	public Entry getEntry() {
		return new Entry(gnome_file_entry_gnome_entry(handle));
	}

	/**
	 * Sets the title of the browse dialog.
	 */
	public void setTitle(String browseDialogTitle) {
		gnome_file_entry_set_title(handle, browseDialogTitle);
	}

	/**
	 * Sets the default path for the browse dialog.
	 */
	public void setDefaultPath(String path) {
		gnome_file_entry_set_default_path(handle, path);
	}

	/**
	 * Sets whether this is a directory only entry.
	 */
	public void setDirectorySelection(boolean directoryEntry) {
		gnome_file_entry_set_directory_entry(handle, directoryEntry);
	}

	/**
	 * Gets the full absolute path of the file from the entry.
	 */
	public String getFullPath(boolean fileMustExist) {
		return gnome_file_entry_get_full_path(handle, fileMustExist);
	}

	/**
	 * Sets the modality of the browse dialog.
	 */
	public void setModal(boolean isModal) {
		gnome_file_entry_set_modal(handle, isModal);
	}

	/**
	 * Returns if the browse dialog is modal.
	 */
	public boolean getModal() {
		return gnome_file_entry_get_modal(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_file_entry_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_file_entry_get_type();
	native static final protected int gnome_file_entry_new(String historyId, String browseDialogTitle);
	native static final protected int gnome_file_entry_gnome_entry(int fentry);
	native static final protected int gnome_file_entry_gtk_entry(int fentry);
	native static final protected void gnome_file_entry_set_title(int fentry, String browseDialogTitle);
	native static final protected void gnome_file_entry_set_default_path(int fentry, String path);
	native static final protected void gnome_file_entry_set_directory_entry(int fentry, boolean directoryEntry);
	native static final protected boolean gnome_file_entry_get_directory_entry(int fentry);
	native static final protected String gnome_file_entry_get_full_path(int fentry, boolean fileMustExist);
	native static final protected void gnome_file_entry_set_filename(int fentry, String filename);
	native static final protected void gnome_file_entry_set_modal(int fentry, boolean isModal);
	native static final protected boolean gnome_file_entry_get_modal(int fentry);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
