/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:21:59 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gnome.WindowIcon
     * Method:    gnome_window_icon_set_from_default
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_WindowIcon_gnome_1window_1icon_1set_1from_1default (
        JNIEnv *env, jclass cls, jint window) 
    {
        GtkWindow *window_g = (GtkWindow *)window;
        {
            gnome_window_icon_set_from_default (window_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.WindowIcon
     * Method:    gnome_window_icon_set_from_file
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_WindowIcon_gnome_1window_1icon_1set_1from_1file (
        JNIEnv *env, jclass cls, jint window, jstring filename) 
    {
        GtkWindow *window_g = (GtkWindow *)window;
        const gchar* filename_g = (*env)->GetStringUTFChars( env, filename, NULL );
		gnome_window_icon_set_from_file (window_g, filename_g);
		(*env)->ReleaseStringUTFChars(env, filename, filename_g);
    }

    /*
     * Class:     org.gnu.gnome.WindowIcon
     * Method:    gnome_window_icon_set_from_file_list
     * Signature: ([Ijava/lang/String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_WindowIcon_gnome_1window_1icon_1set_1from_1file_1list (
        JNIEnv *env, jclass cls, jint window, jobjectArray filenames) 
    {
        GtkWindow *window_g = (GtkWindow *)window;
        const gchar **filenames_g = getStringArray(env, filenames);
        gnome_window_icon_set_from_file_list (window_g, filenames_g);
        freeStringArray(env, filenames, filenames_g);
    }

    /*
     * Class:     org.gnu.gnome.WindowIcon
     * Method:    gnome_window_icon_set_default_from_file
     * Signature: ([B)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_gnome_WindowIcon_gnome_1window_1icon_1set_1default_1from_1file (JNIEnv *env, 
        jclass cls, jstring filename) 
    {
        const gchar* filename_g = (*env)->GetStringUTFChars(env, filename, NULL);
		gnome_window_icon_set_default_from_file (filename_g);
		(*env)->ReleaseStringUTFChars(env, filename, filename_g);
    }

    /*
     * Class:     org.gnu.gnome.WindowIcon
     * Method:    gnome_window_icon_set_default_from_file_list
     * Signature: ([Ljava/lang/String;)V
     */
    JNIEXPORT void JNICALL 
    Java_org_gnu_gnome_WindowIcon_gnome_1window_1icon_1set_1default_1from_1file_1list (JNIEnv *env, 
        jclass cls, jobjectArray filenames) 
    {
        const gchar **filenames_g = getStringArray(env, filenames);
        gnome_window_icon_set_default_from_file_list (filenames_g);
        freeStringArray(env, filenames, filenames_g);
    }

    /*
     * Class:     org.gnu.gnome.WindowIcon
     * Method:    gnome_window_icon_init
     * Signature: ()V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_WindowIcon_gnome_1window_1icon_1init (JNIEnv *env, 
        jclass cls) 
    {
        {
            gnome_window_icon_init ();
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
