/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:21:58 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif
  
  GnomeUIInfo *app_getUIInfoArray(JNIEnv *env, jintArray uiinfo) 
  {
    gint *uiinfo_g_g = (gint *) (*env)->GetIntArrayElements (env, uiinfo, NULL);
    jint uiinfo_len = (*env)->GetArrayLength(env, uiinfo);
    GnomeUIInfo *uiinfo_g = g_new(GnomeUIInfo, uiinfo_len);
    int i = 0;
    for (i = 0; i < uiinfo_len; i++)
      uiinfo_g[i] = *(GnomeUIInfo *)uiinfo_g_g[i];
    (*env)->ReleaseIntArrayElements (env, uiinfo, (jint*)uiinfo_g_g, 0);
    return uiinfo_g;
  }
  
  /****************************************
   * BEGINNING OF GENERATED CODE
   ****************************************/
  gchar * GnomeApp_get_name (GnomeApp * cptr) 
  {
    return cptr->name;
  }
  
  /*
   * Class:     org.gnu.gnome.App
   * Method:    getName
   * Signature: (I)[B
   */
  JNIEXPORT jstring JNICALL Java_org_gnu_gnome_App_getName (JNIEnv *env, jclass cls, jint cptr)
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (*env)->NewStringUTF(env, (gchar*)GnomeApp_get_name (cptr_g));
  }
  
  gchar * GnomeApp_get_prefix (GnomeApp * cptr) 
  {
    return cptr->prefix;
  }
  
  /*
   * Class:     org.gnu.gnome.App
   * Method:    getPrefix
   * Signature: (I)[B
   */
  JNIEXPORT jstring JNICALL Java_org_gnu_gnome_App_getPrefix (JNIEnv *env, jclass cls, jint 
							      cptr) 
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (*env)->NewStringUTF(env, (gchar*)GnomeApp_get_prefix (cptr_g));
  }

  GtkWidget * GnomeApp_get_dock (GnomeApp * cptr) 
  {
    return cptr->dock;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    getDock
   * Signature: (I)I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_getDock (JNIEnv *env, jclass cls, jint cptr) 
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (jint)GnomeApp_get_dock (cptr_g);
  }

  GtkWidget * GnomeApp_get_statusbar (GnomeApp * cptr) 
  {
    return cptr->statusbar;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    getStatusbar
   * Signature: (I)I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_getStatusbar (JNIEnv *env, jclass cls, jint cptr) 
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (jint)GnomeApp_get_statusbar (cptr_g);
  }

  GtkWidget * GnomeApp_get_vbox (GnomeApp * cptr) 
  {
    return cptr->vbox;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    getVbox
   * Signature: (I)I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_getVbox (JNIEnv *env, jclass cls, jint cptr) 
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (jint)GnomeApp_get_vbox (cptr_g);
  }

  GtkWidget * GnomeApp_get_menubar (GnomeApp * cptr) 
  {
    return cptr->menubar;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    getMenubar
   * Signature: (I)I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_getMenubar (JNIEnv *env, jclass cls, jint cptr) 
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (jint)GnomeApp_get_menubar (cptr_g);
  }

  GtkWidget * GnomeApp_get_contents (GnomeApp * cptr) 
  {
    return cptr->contents;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    getContents
   * Signature: (I)I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_getContents (JNIEnv *env, jclass cls, jint cptr) 
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (jint)GnomeApp_get_contents (cptr_g);
  }

  GtkAccelGroup * GnomeApp_get_accel_group (GnomeApp * cptr) 
  {
    return cptr->accel_group;
  }
  
  /*
   * Class:     org.gnu.gnome.App
   * Method:    getAccelGroup
   * Signature: (I)I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_getAccelGroup (JNIEnv *env, jclass cls, jint cptr)
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    return (jint)GnomeApp_get_accel_group (cptr_g);
  }

  gboolean GnomeApp_get_enable_layout_config (GnomeApp * cptr) 
  {
    return cptr->enable_layout_config;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    getEnableLayoutConfig
   * Signature: (I)Z
   */
  JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_App_getEnableLayoutConfig (JNIEnv *env, jclass 
									   cls, jint cptr) 
  {
    GnomeApp *cptr_g = (GnomeApp *)cptr;
    jboolean result_j = (jboolean) (GnomeApp_get_enable_layout_config (cptr_g));
    return result_j;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_get_type
   * Signature: ()I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_gnome_1app_1get_1type (JNIEnv *env, jclass cls) 
  {
    return (jint)gnome_app_get_type ();
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_new
   * Signature: ([B[B)I
   */
  JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_gnome_1app_1new (JNIEnv *env, jclass cls, 
								 jstring appname, jstring title) 
  {
    const gchar* appname_g = (*env)->GetStringUTFChars(env, appname, NULL);
    const gchar* title_g = (*env)->GetStringUTFChars(env, title, NULL);
    jint retval =  (jint)gnome_app_new (appname_g, title_g);
    (*env)->ReleaseStringUTFChars(env, appname, appname_g);
    (*env)->ReleaseStringUTFChars(env, title, title_g);
    return retval;
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_set_menus
   * Signature: (II)V
   */
  JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1set_1menus (JNIEnv *env, jclass cls, 
									jint app, jint menubar) 
  {
    GnomeApp *app_g = (GnomeApp *)app;
    GtkMenuBar *menubar_g = (GtkMenuBar *)menubar;
    gnome_app_set_menus (app_g, menubar_g);
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_set_toolbar
   * Signature: (II)V
   */
  JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1set_1toolbar (JNIEnv *env, jclass cls, jint app, jint toolbar) 
  {
    GnomeApp *app_g = (GnomeApp *)app;
    GtkToolbar *toolbar_g = (GtkToolbar *)toolbar;
    gnome_app_set_toolbar (app_g, toolbar_g);
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_set_statusbar
   * Signature: (II)V
   */
  JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1set_1statusbar (JNIEnv *env, jclass cls, jint app, jint statusbar) 
  {
    GnomeApp *app_g = (GnomeApp *)app;
    GtkWidget *statusbar_g = (GtkWidget *)statusbar;
    gnome_app_set_statusbar (app_g, statusbar_g);
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_set_statusbar_custom
   * Signature: (III)V
   */
  JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1set_1statusbar_1custom (JNIEnv *env, jclass cls, jint app, jint container, jint statusbar) 
  {
    GnomeApp *app_g = (GnomeApp *)app;
    GtkWidget *container_g = (GtkWidget *)container;
    GtkWidget *statusbar_g = (GtkWidget *)statusbar;
    gnome_app_set_statusbar_custom (app_g, container_g, statusbar_g);
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_set_contents
   * Signature: (II)V
   */
  JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1set_1contents (JNIEnv *env, jclass cls, jint app, jint contents) 
  {
    GnomeApp *app_g = (GnomeApp *)app;
    GtkWidget *contents_g = (GtkWidget *)contents;
    gnome_app_set_contents (app_g, contents_g);
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_enable_layout_config
   * Signature: (IZ)V
   */
  JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1enable_1layout_1config (JNIEnv *env, jclass cls, jint app, jboolean enable) 
  {
    GnomeApp *app_g = (GnomeApp *)app;
    gboolean enable_g = (gboolean) enable;
    gnome_app_enable_layout_config (app_g, enable_g);
  }

  /*
   * Class:     org.gnu.gnome.App
   * Method:    gnome_app_ui_configure_configurable
   * Signature: ([Lint ;)V
   */
  JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1ui_1configure_1configurable (JNIEnv *env, jclass cls, jint uiinfo) 
  {
    gnome_app_ui_configure_configurable ( (GnomeUIInfo *) uiinfo);
  }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_create_menus
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1create_1menus (JNIEnv *env, jclass 
        cls, jint app, jint uiinfo) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        GnomeUIInfo *uiinfo_g = (GnomeUIInfo *) uiinfo;
        gnome_app_create_menus (app_g, uiinfo_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_create_menus_custom
     * Signature: (I[Lint ;I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1create_1menus_1custom (JNIEnv *env, 
        jclass cls, jint app, int uiinfo, jint uibdate) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        GnomeUIInfo *uiinfo_g = (GnomeUIInfo *) uiinfo;
        GnomeUIBuilderData *uibdate_g = (GnomeUIBuilderData *)uibdate;
        gnome_app_create_menus_custom (app_g, uiinfo_g, uibdate_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_create_toolbar
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1create_1toolbar (JNIEnv *env, jclass 
        cls, jint app, int uiinfo)
    {
		
        GnomeApp *app_g = (GnomeApp *)app;
        GnomeUIInfo *uiinfo_g = (GnomeUIInfo *) uiinfo;
		gnome_app_create_toolbar (app_g, uiinfo_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_create_toolbar_custom
     * Signature: (I[Lint ;I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1create_1toolbar_1custom (JNIEnv *env, 
        jclass cls, jint app, jintArray uiinfo, jint uibdata) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        GnomeUIInfo *uiinfo_g = app_getUIInfoArray(env, uiinfo);
        GnomeUIBuilderData *uibdata_g = (GnomeUIBuilderData *)uibdata;
        gnome_app_create_toolbar_custom (app_g, uiinfo_g, uibdata_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_find_menu_pos
     * Signature: (I[BI)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_gnome_1app_1find_1menu_1pos (JNIEnv *env, jclass 
        cls, jint parent, jstring path, jint pos) 
    {
        GtkWidget *parent_g = (GtkWidget *)parent;
        gint32 pos_g = (gint32) pos;
        const gchar* path_g = (*env)->GetStringUTFChars(env, path, NULL);
	jint retval =  (jint)gnome_app_find_menu_pos (parent_g, path_g, pos_g);
	(*env)->ReleaseStringUTFChars(env, path, path_g);
	return retval;
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_remove_menus
     * Signature: (I[BI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1remove_1menus (JNIEnv *env, jclass 
        cls, jint app, jstring path, jint items) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        gint32 items_g = (gint32) items;
        const gchar* path_g = (*env)->GetStringUTFChars(env, path, NULL);
	gnome_app_remove_menus (app_g, path_g, items_g);
	(*env)->ReleaseStringUTFChars(env, path, path_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_remove_menu_range
     * Signature: (I[BII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1remove_1menu_1range (JNIEnv *env, 
        jclass cls, jint app, jstring path, jint start, jint items) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        gint32 start_g = (gint32) start;
        gint32 items_g = (gint32) items;
        const gchar* path_g = (*env)->GetStringUTFChars(env, path, NULL);
	gnome_app_remove_menu_range (app_g, path_g, start_g, items_g);
	(*env)->ReleaseStringUTFChars(env, path, path_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_insert_menus_custom
     * Signature: (I[B[Lint ;I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1insert_1menus_1custom (JNIEnv *env, 
        jclass cls, jint app, jstring path, jint menuinfo, jint uibdata) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        GnomeUIBuilderData *uibdata_g = (GnomeUIBuilderData *)uibdata;
        const gchar* path_g = (*env)->GetStringUTFChars(env, path, NULL);
	gnome_app_insert_menus_custom (app_g, path_g, (GnomeUIInfo *) menuinfo, uibdata_g);
	(*env)->ReleaseStringUTFChars(env, path, path_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_insert_menus
     * Signature: (I[B[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1insert_1menus (JNIEnv *env, jclass 
        cls, jint app, jstring path, jintArray menuinfo) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        const gchar* path_g = (*env)->GetStringUTFChars(env, path, NULL);
	gnome_app_insert_menus (app_g, path_g, (GnomeUIInfo *) menuinfo);
	(*env)->ReleaseStringUTFChars(env, path, path_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_install_appbar_menu_hints
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1install_1appbar_1menu_1hints (JNIEnv 
        *env, jclass cls, jint appbar, jint uiinfo) 
    {
        GnomeAppBar *appbar_g = (GnomeAppBar *)appbar;
        gnome_app_install_appbar_menu_hints (appbar_g, (GnomeUIInfo *) uiinfo);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_install_statusbar_menu_hints
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1install_1statusbar_1menu_1hints (
        JNIEnv *env, jclass cls, jint bar, jint uiinfo) 
    {
        GtkStatusbar *bar_g = (GtkStatusbar *)bar;
        gnome_app_install_statusbar_menu_hints (bar_g, (GnomeUIInfo *) uiinfo);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_install_menu_hints
     * Signature: (I[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1install_1menu_1hints (JNIEnv *env, 
        jclass cls, jint app, jint uiinfo) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        gnome_app_install_menu_hints (app_g, (GnomeUIInfo *) uiinfo);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_fill_menu
     * Signature: (IIIZI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1fill_1menu (JNIEnv *env, jclass cls, 
        jint menuShell, jint uiInfo, jint accelGroup, jboolean ulineAccels, jint pos) 
    {
        GtkMenuShell *menuShell_g = (GtkMenuShell *)menuShell;
        GnomeUIInfo *uiInfo_g = (GnomeUIInfo *)uiInfo;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        gboolean ulineAccels_g = (gboolean) ulineAccels;
        gint32 pos_g = (gint32) pos;
	gnome_app_fill_menu (menuShell_g, uiInfo_g, accelGroup_g, ulineAccels_g, pos_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_fill_menu_with_data
     * Signature: (IIIZII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1fill_1menu_1with_1data (JNIEnv *env, 
        jclass cls, jint menuShell, jint uiInfo, jint accelGroup, jboolean ulineAccels, jint pos, 
        jint userData) 
    {
        GtkMenuShell *menuShell_g = (GtkMenuShell *)menuShell;
        GnomeUIInfo *uiInfo_g = (GnomeUIInfo *)uiInfo;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        gboolean ulineAccels_g = (gboolean) ulineAccels;
        gint32 pos_g = (gint32) pos;
        gpointer *userData_g = (gpointer *)userData;
	gnome_app_fill_menu_with_data (menuShell_g, uiInfo_g, accelGroup_g, ulineAccels_g, pos_g, userData_g);
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_fill_menu_custom
     * Signature: (IIIIZI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1fill_1menu_1custom (JNIEnv *env, 
        jclass cls, jint menuShell, jint uiInfo, jint uiBData, jint accelGroup, jboolean 
        ulineAccels, jint pos) 
    {
        GtkMenuShell *menuShell_g = (GtkMenuShell *)menuShell;
        GnomeUIInfo *uiInfo_g = (GnomeUIInfo *)uiInfo;
        GnomeUIBuilderData *uiBData_g = (GnomeUIBuilderData *)uiBData;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        gboolean ulineAccels_g = (gboolean) ulineAccels;
        gint32 pos_g = (gint32) pos;
        {
            gnome_app_fill_menu_custom (menuShell_g, uiInfo_g, uiBData_g, accelGroup_g, 
                ulineAccels_g, pos_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_fill_toolbar
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1fill_1toolbar (JNIEnv *env, jclass 
        cls, jint toolbar, jint uiInfo, jint accelGroup) 
    {
        GtkToolbar *toolbar_g = (GtkToolbar *)toolbar;
        GnomeUIInfo *uiInfo_g = (GnomeUIInfo *)uiInfo;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        {
            gnome_app_fill_toolbar (toolbar_g, uiInfo_g, accelGroup_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_fill_toolbar_with_data
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1fill_1toolbar_1with_1data (JNIEnv 
        *env, jclass cls, jint toolbar, jint uiInfo, jint accelGroup, jint userData) 
    {
        GtkToolbar *toolbar_g = (GtkToolbar *)toolbar;
        GnomeUIInfo *uiInfo_g = (GnomeUIInfo *)uiInfo;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        gpointer *userData_g = (gpointer *)userData;
        {
            gnome_app_fill_toolbar_with_data (toolbar_g, uiInfo_g, accelGroup_g, userData_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_fill_toolbar_custom
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1fill_1toolbar_1custom (JNIEnv *env, 
        jclass cls, jint toolbar, jint uiInfo, jint uiBData, jint accelGroup) 
    {
        GtkToolbar *toolbar_g = (GtkToolbar *)toolbar;
        GnomeUIInfo *uiInfo_g = (GnomeUIInfo *)uiInfo;
        GnomeUIBuilderData *uiBData_g = (GnomeUIBuilderData *)uiBData;
        GtkAccelGroup *accelGroup_g = (GtkAccelGroup *)accelGroup;
        {
            gnome_app_fill_toolbar_custom (toolbar_g, uiInfo_g, uiBData_g, accelGroup_g);
        }
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_message
     * Signature: (I[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_gnome_1app_1message (JNIEnv *env, jclass cls, 
        jint app, jstring message) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        const gchar* message_g = (*env)->GetStringUTFChars(env, message, NULL);
	GtkWidget *w =  gnome_app_message (app_g, message_g);
	jint retval = (NULL == w) ? 0 : (jint)w;
	(*env)->ReleaseStringUTFChars( env, message, message_g );
	return retval;
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_flash
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gnome_App_gnome_1app_1flash (JNIEnv *env, jclass cls, jint 
        app, jstring flash) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        const gchar* flash_g = (*env)->GetStringUTFChars(env, flash, NULL);
	gnome_app_flash (app_g, flash_g);
	(*env)->ReleaseStringUTFChars( env, flash, flash_g );
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_error
     * Signature: (I[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_gnome_1app_1error (JNIEnv *env, jclass cls, jint 
        app, jstring error) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        const gchar* error_g = (*env)->GetStringUTFChars(env, error, NULL);
	GtkWidget *w =  gnome_app_error (app_g, error_g);
	jint retval = (NULL == w) ? 0 : (jint)w;
	(*env)->ReleaseStringUTFChars( env, error, error_g );
	return retval;
    }

    /*
     * Class:     org.gnu.gnome.App
     * Method:    gnome_app_warning
     * Signature: (I[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_App_gnome_1app_1warning (JNIEnv *env, jclass cls, 
        jint app, jstring warning) 
    {
        GnomeApp *app_g = (GnomeApp *)app;
        const gchar* warning_g = (*env)->GetStringUTFChars(env, warning, NULL);
	GtkWidget *w =  gnome_app_warning (app_g, warning_g);
	jint retval = (NULL == w) ? 0 : (jint)w;
	(*env)->ReleaseStringUTFChars( env, warning, warning_g );
	return retval;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
