/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:07 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
import org.gnu.gtk.Button;
/**
 * The HRef widget displays a frameless button that, when
 * selected, issues a command for the web browser to connect to a web
 * site. The actual command to the browser is defined globally as the
 * default member of URL Handler list in the GNOME Control Center.
 */
public class HRef extends Button {

	/**
	 * Creates a new HRef with the given URL and label.
	 * @param url The URL to show in the web browser when the HRef is clicked.
	 * @param lable The caption for the HRef.
	 */
	public HRef(String url, String lable) {
		handle = gnome_href_new(url, lable);
		initializeEventHandlers();
	}

	/**
	 * Construct a HRef using a handle to a native resource.
	 */
        public HRef(int handle) {
	    super(handle);
	}

	protected void noopInit() {
	}

	/**
	 * Returns the caption for the HRef.
	 * @return The text displayed by the HRef.
	 */
	public String getText() {
		return new String(gnome_href_get_text(handle));
	}

	/**
	 * Returns the URL referenced by the HRef.
	 * @return The url to show when the HRef is clicked.
	 */
	public String getURL() {
		return new String(gnome_href_get_url(handle));
	}

	/**
	 * Returns the caption for the HRef.
	 * @param text The text displayed by the HRef.
	 */
	public void setText(String text) {
		gnome_href_set_text(handle, text);
	}

	/**
	 * Returns the URL referenced by the HRef.
	 * @param url The url to show when the HRef is clicked.
	 */
	public void setURL(String url) {
		gnome_href_set_url(handle, url);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_href_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_href_get_type();
	native static final protected int gnome_href_new(String url, String lable);
	native static final protected void gnome_href_set_url(int href, String url);
	native static final protected String gnome_href_get_url(int href);
	native static final protected void gnome_href_set_text(int href, String text);
	native static final protected String gnome_href_get_text(int label);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
