// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_LAYOUTITER_H
#define _PANGOMM_LAYOUTITER_H

#include <glibmm.h>

/* $Id: layoutiter.hg,v 1.1.1.1 2003/01/21 13:41:06 murrayc Exp $ */

/* layoutiter.h
 *
 * Copyright 2001-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <pangomm/layoutline.h>
#include <pangomm/layoutrun.h>
#include <pango/pango-layout.h>


namespace Pango
{

/** A Pango::LayoutIter can be used to iterate over the visual extents of a Pango::Layout.
 */
class LayoutIter
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef LayoutIter CppObjectType;
  typedef PangoLayoutIter BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  // There's no other ctor, and the default ctor creates an invalid object.
  // Therefore, Pango::LayoutIter is usable only as output argument.
  LayoutIter();
  ~LayoutIter();

  
  int get_index() const;
  
  LayoutRun get_run() const;
  
  Glib::RefPtr<LayoutLine> get_line() const;
  
  bool at_last_line() const;

  
  bool next_char();
  
  bool next_cluster();
  
  bool next_run();
  
  bool next_line();

  /** Gets the extents of the current character, in layout coordinates (origin is the top left of the entire layout).
   * Only logical extents can sensibly be obtained for characters; ink extents make sense only down to the level of clusters.
   * @return The logical extents of the current character.
   */
  Rectangle get_char_extents() const;

  
  void get_cluster_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Gets the ink extents of the current cluster, in layout coordinates (origin is the top left of the entire layout).
   * @return The extents of the current cluster as drawn.
   */
  Rectangle get_cluster_ink_extents() const;

  /** Gets the logical extents of the current cluster, in layout coordinates (origin is the top left of the entire layout).
   * @return The logical extents of the current cluster.
   */
  Rectangle get_cluster_logical_extents() const;

  
  void get_run_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Gets the ink extents of the current run in layout coordinates (origin is the top left of the entire layout).
   * @return The extents of the current run as drawn.
   */
  Rectangle get_run_ink_extents() const;

  /** Gets the logical extents of the current run in layout coordinates (origin is the top left of the entire layout).
   * @return The logical extents of the current run.
   */
  Rectangle get_run_logical_extents() const;

  
  void get_line_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Obtains the ink extents of the current line.
   * @return The extents of the current line as drawn.
   */
  Rectangle get_line_ink_extents() const;

  /** Obtains the logical extents of the current line.
   * @return The logical extents of the current line.
   */
  Rectangle get_line_logical_extents() const;

  
  void get_line_yrange(int& y0, int& y1) const;

  
  void get_layout_extents(Rectangle& ink_rect, Rectangle& logical_rect) const;

  /** Obtains the ink extents of the Pango::Layout being iterated over.
   * @return The extents of the layout as drawn.
   */
  Rectangle get_layout_ink_extents() const;

  /** Obtains the logical extents of the Pango::Layout being iterated over.
   * @return The logical extents of the layout.
   */
  Rectangle get_layout_logical_extents() const;

  
  int get_baseline() const;

  PangoLayoutIter*       gobj()       { return gobject_; }
  const PangoLayoutIter* gobj() const { return gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  void assign_gobj(PangoLayoutIter* src);
#endif

protected:
  PangoLayoutIter* gobject_;

private:
  // noncopyable
  LayoutIter(const LayoutIter&);
  LayoutIter& operator=(const LayoutIter&);


};

} //namespace Pango


#endif /* _PANGOMM_LAYOUTITER_H */

