// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEVIEWCOLUMN_H
#define _GTKMM_TREEVIEWCOLUMN_H

#include <glibmm.h>

/* $Id: treeviewcolumn.hg,v 1.6 2003/12/09 06:42:51 murrayc Exp $ */

/* Copyright(C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/object.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/widget.h>
#include <gdkmm/window.h>
#include <gtkmm/treemodel.h>
#include <glibmm/listhandle.h>
#include <gtkmm/cellrenderer_generation.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeViewColumn GtkTreeViewColumn;
typedef struct _GtkTreeViewColumnClass GtkTreeViewColumnClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeViewColumn_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TreeViewColumnSizing
{
  TREE_VIEW_COLUMN_GROW_ONLY,
  TREE_VIEW_COLUMN_AUTOSIZE,
  TREE_VIEW_COLUMN_FIXED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeViewColumnSizing> : public Glib::Value_Enum<Gtk::TreeViewColumnSizing>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** Typedefed as Gtk::TreeView::Column.
 * This is a visible column in a Gtk::TreeView widget. It determines the geometry, type.
 *
 * @ingroup TreeView
*/

class TreeViewColumn : public Gtk::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeViewColumn CppObjectType;
  typedef TreeViewColumn_Class CppClassType;
  typedef GtkTreeViewColumn BaseObjectType;
  typedef GtkTreeViewColumnClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TreeViewColumn();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TreeViewColumn_Class;
  static CppClassType treeviewcolumn_class_;

  // noncopyable
  TreeViewColumn(const TreeViewColumn&);
  TreeViewColumn& operator=(const TreeViewColumn&);

protected:
  explicit TreeViewColumn(const Glib::ConstructParams& construct_params);
  explicit TreeViewColumn(GtkTreeViewColumn* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkTreeViewColumn*       gobj()       { return reinterpret_cast<GtkTreeViewColumn*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkTreeViewColumn* gobj() const { return reinterpret_cast<GtkTreeViewColumn*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_clicked();


private:

  
public:
  typedef TreeViewColumn Column;

  TreeViewColumn();

  explicit TreeViewColumn(const Glib::ustring& title);
  TreeViewColumn(const Glib::ustring& title, CellRenderer& cell);

  /** Create a default view column for the given model column type.
   */
  template<class T_ModelColumnType>
  TreeViewColumn(const Glib::ustring& title, const TreeModelColumn<T_ModelColumnType>& column);

  
  void pack_start(CellRenderer& cell, bool expand = true);
  
  void pack_end(CellRenderer& cell, bool expand = true);


  template<class T_ModelColumnType>
  void pack_start(const TreeModelColumn<T_ModelColumnType>& column, bool expand = true);

  template<class T_ModelColumnType>
  void pack_end(const TreeModelColumn<T_ModelColumnType>& column, bool expand = true);

  
  void clear();

  /** Gets the CellRenderer for the column.
    * You should dynamic_cast<> to the expected derived CellRenderer type.
    * This assumes that the TreeViewColumn contains only one CellRenderer.
    */
  CellRenderer* get_first_cell_renderer();

  /** Gets the CellRenderer for the column.
    * You should dynamic_cast<> to the expected derived CellRenderer type.
    * This assumes that the TreeViewColumn contains only one CellRenderer.
    */
  const CellRenderer* get_first_cell_renderer() const;

  
  Glib::ListHandle<CellRenderer*> get_cell_renderers();
  
  Glib::ListHandle<const CellRenderer*> get_cell_renderers() const;

  
  void add_attribute(CellRenderer& cell_renderer, const Glib::ustring& attribute, int column);

  void add_attribute(const Glib::PropertyProxy_Base& property, const TreeModelColumnBase& column);
  

  void set_renderer(Gtk::CellRenderer& renderer, const TreeModelColumnBase& column);

 // _WRAP_METHOD(void set_attributes(CellRenderer& cell_renderer, ...), )

  typedef SigC::Slot2<void, CellRenderer*, const Gtk::TreeModel::iterator&> SlotCellData;

  void set_cell_data_func(CellRenderer& cell_renderer, const SlotCellData& slot);
  void unset_cell_data_func(CellRenderer& cell_renderer);

  
  void clear_attributes(CellRenderer& cell_renderer);
  
  void set_spacing(int spacing);
  
  int get_spacing() const;
  
  void set_visible(bool visible = true);
  
  bool get_visible() const;
  
  void set_resizable(bool resizable = true);
  
  bool get_resizable() const;
  
  void set_sizing(TreeViewColumnSizing type);
  
  TreeViewColumnSizing get_sizing();
  
  int get_width() const;
  
  int get_fixed_width() const;
  
  void set_fixed_width(int fixed_width);
  
  void set_min_width(int min_width);
  
  int get_min_width() const;
  
  void set_max_width(int max_width);
  
  int get_max_width() const;
  
  void clicked();

  
  void set_title(const Glib::ustring& title);
  
  Glib::ustring get_title() const;

  
  void set_expand(bool expand = true);
  
  bool get_expand() const;

  
  void set_clickable(bool clickable = true);
  
  bool get_clickable() const;
  
  void set_widget(Gtk::Widget& widget);
  
  Widget* get_widget();
  
  const Widget* get_widget() const;

  
  void set_alignment(float xalign);
  
  void set_alignment(AlignmentEnum xalign);

  
  float get_alignment() const;
  
  void set_reorderable(bool reorderable = true);
  
  bool get_reorderable() const;

  
  void set_sort_column_id(const TreeModelColumnBase& sort_column_id);
  
  void set_sort_column_id(int sort_column_id);
  
  int get_sort_column_id() const;
  
  void set_sort_indicator(bool setting);
  
  bool get_sort_indicator() const;
  
  void set_sort_order(SortType order);
  
  SortType get_sort_order() const;


  void cell_set_cell_data(const Glib::RefPtr<TreeModel>& tree_model, const TreeModel::iterator& iter, bool is_expander, bool is_expanded);
  
  void cell_get_size(Gdk::Rectangle& cell_area, int& x_offset, int& y_offset, int& width, int& height) const;
  
  bool cell_is_visible() const;
  
  void focus_cell(CellRenderer& cell);

  
  bool get_cell_position(const CellRenderer& cell_renderer, int& start_pos, int& width) const;

  
  /**
   * @par Prototype:
   * <tt>void %clicked()</tt>
   */
  Glib::SignalProxy0< void > signal_clicked();


  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_visible();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy_ReadOnly<int> property_width();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<TreeViewColumnSizing> property_sizing();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_fixed_width();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_min_width();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_max_width();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<Glib::ustring> property_title();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_expand();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_clickable();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<Widget*> property_widget();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<float> property_alignment();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_reorderable();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_sort_indicator();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<SortType> property_sort_order();


#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  // Only necessary because of the templated ctor, see below.
  static const Glib::Class& class_init_();
#endif //DOXYGEN_SHOULD_SKIP_THIS


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template<class T_ModelColumnType>
void TreeViewColumn::pack_start(const TreeModelColumn<T_ModelColumnType>& column, bool expand)
{
  //Generate appropriate Renderer for the column:
  CellRenderer* pCellRenderer = manage( CellRenderer_Generation::generate_cellrenderer<T_ModelColumnType>() );

  //Use the renderer:
  pack_start(*pCellRenderer, expand);
  set_renderer(*pCellRenderer, column);
}

template<class T_ModelColumnType>
void TreeViewColumn::pack_end(const TreeModelColumn<T_ModelColumnType>& column, bool expand)
{
  //Generate appropriate Renderer for the column:
  CellRenderer* pCellRenderer= manage( CellRenderer_Generation::generate_cellrenderer<T_ModelColumnType>() );

  //Use the renderer:
  pack_end(*pCellRenderer, expand);
  set_renderer(*pCellRenderer, column);
}


template <class T_ModelColumnType>
TreeViewColumn::TreeViewColumn(const Glib::ustring& title,
                               const TreeModelColumn<T_ModelColumnType>& column)
:
  Glib::ObjectBase(0), // not (yet) a custom class
  Gtk::Object(Glib::ConstructParams(class_init_(), "title", title.c_str(), (char*) 0))
{
  pack_start(column, true /* expand */);
}


#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::TreeViewColumn */
  Gtk::TreeViewColumn* wrap(GtkTreeViewColumn* object, bool take_copy = false);
}
#endif /* _GTKMM_TREEVIEWCOLUMN_H */

