/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import org.gnu.gdk.Color;

/**
 */
public class ColorButton extends Button {

	public ColorButton() {
		if (-1 == handle)
			handle = gtk_color_button_new();
	}
	
	public ColorButton(Color color) {
		handle = gtk_color_button_new_with_color(color.getHandle());
	}
	
	public void setColor(Color color) {
		gtk_color_button_set_color(handle, color.getHandle());
	}
	
	public Color getColor() {
		return new Color(gtk_color_button_get_color(handle));
	}
	
	public void setAlpha(int alpha) {
		gtk_color_button_set_alpha(handle, alpha);
	}
	
	public int getAlpha() {
		return gtk_color_button_get_alpha(handle);
	}
	
	public void setUseAlpha(boolean useAlpha) {
		gtk_color_button_set_use_alpha(handle, useAlpha);
	}
	
	public boolean getUseAlpha() {
		return gtk_color_button_get_use_alpha(handle);
	}
	
	public void setTitle(String title) {
		gtk_color_button_set_title(handle, title);
	}
	
	public String getTitle() {
		return gtk_color_button_get_title(handle);
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_color_button_get_type ();
	native static final protected int gtk_color_button_new();
	native static final protected int gtk_color_button_new_with_color(int color);
	native static final protected void gtk_color_button_set_color(int button, int color);
	native static final protected void gtk_color_button_set_alpha(int button, int alpha);
	native static final protected int gtk_color_button_get_color(int button);
	native static final protected int gtk_color_button_get_alpha(int button);
	native static final protected void gtk_color_button_set_use_alpha(int button, boolean useAlpha);
	native static final protected boolean gtk_color_button_get_use_alpha(int button);
	native static final protected void gtk_color_button_set_title(int button, String title);
	native static final protected String gtk_color_button_get_title(int button);                                                                                
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
