/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:19 EDT
 */

 /*
  * TODO:
  *	Some methods look ugly and unusable. Are they going to be implemented? 
  *	
  * 
  */
 
package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 *	
 */
public class Colormap extends GObject 
{
	
	/**
	 * Create a Colormap initialized to the system's
	 * default colormap.
	 */
	public Colormap() {
		handle = Colormap.gdk_colormap_get_system();
	}
	
	/**
	 * Create a new Colormap from a handle to a native resource.
	 */
	public Colormap(int handle){
		this.handle=handle;
	}
	
	/**
	*	Creates a new colormap for the given visual.
	*	
	*/
	public Colormap(org.gnu.gdk.Visual v, boolean private_){
		this(Colormap.gdk_colormap_new(v.getHandle(), private_ == true ? 1 : 0));
	} 
	
	/**
	*	Returns the system's default colormap.
	*/
	public static Colormap getSystem(){
		return new Colormap(Colormap.gdk_colormap_get_system());
	}
	
	/**
	*	Returns the visual for which a given colormap was created.
	*/
	public Visual getVisual(){
		return new Visual(Colormap.gdk_colormap_get_visual(handle));
	}
	
	/**
	 * Allocates a single color from a colormap.
	 * 
	 * @param color The color to allocate
	 * @param writable If true the color is allocated writable.
	 * @param bestMatch If true GDK will attempt to do matching against existing
	 * colors if the color cannot be allocated as requested.
	 */
	public boolean allocateColor(Color color, boolean writable, boolean bestMatch) {
		return Colormap.gdk_colormap_alloc_color(handle, color.getHandle(), writable, bestMatch);
	}
	
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_colormap_get_type ();
    native static final protected int gdk_colormap_new (int visual, int allocate);
    native static final protected int gdk_colormap_get_system ();
    native static final protected int gdk_colormap_alloc_colors (int colormap, int [] colors, int 
        numColors, boolean writable, boolean bestMatch, boolean[] success);
    native static final protected boolean gdk_colormap_alloc_color (int colormap, int color, 
        boolean writable, boolean best_match);
    native static final protected void gdk_colormap_free_colors (int colormap, int [] colors, int 
        numColors);
    native static final protected void gdk_colormap_query_color (int colormap, long pixel, int 
        result);
    native static final protected int gdk_colormap_get_visual (int colormap);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

