// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_CONTEXT_H
#define _PANGOMM_CONTEXT_H

#include <glibmm.h>

/* $Id: context.hg,v 1.1.1.1 2003/01/21 13:41:02 murrayc Exp $ */

/* context.h
 * 
 * Copyright (C) 1998-1999 The gtkmm Development Team 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <glibmm/arrayhandle.h>
#include <glibmm/listhandle.h>
#include <pangomm/fontdescription.h>
#include <pangomm/fontmetrics.h>
#include <pangomm/fontset.h>
#include <pangomm/fontmap.h>
#include <pangomm/item.h>
#include <pangomm/attrlist.h>
#include <pango/pango-context.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _PangoContext PangoContext;
typedef struct _PangoContextClass PangoContextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{ class Context_Class; } // namespace Pango
namespace Pango
{


/** @addtogroup pangommEnums Enums and Flags */

/**
 * @ingroup pangommEnums
 */
enum Direction
{
  DIRECTION_LTR,
  DIRECTION_RTL,
  DIRECTION_TTB_LTR,
  DIRECTION_TTB_RTL
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Direction> : public Glib::Value_Enum<Pango::Direction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{


/** A Pango::Context stores global information used to control the itemization process.
 * You can retrieve a Pango::Context object with Gtk::Widget::create_pango_context() or
 * Gtk::Widget::get_pango_context(). If you don't use gtkmm call some c function of the
 * pango backend you intend to use and create a wrapper for the returned context,
 * e.g. Glib::wrap(pango_x_get_context()).
 *
 * Creating a Pango::Context object is the starting point of every rendering process.
 * You can either use it to create a high level Pango::Layout object which does all
 * the hard work for you by passing it into
 * Pango::Layout::create() or to generate glyph strings from character strings with
 * the help of itemize() and Pango::Item::shape() subsequently.
 *
 * Which fonts are used for rendering can be influenced by setting the default
 * font description, language and base direction of the context.
 *
 * If you want to calculate the space some text will need to be displayed you
 * might find the functions of Pango::FontMetrics useful. Use get_metrics() to
 * obtain the Pango::FontMetrics object for a specific Pango::FontDescription.
 * For more detailed calculations in a rendering-system-independant manner
 * and to determine whether specific characters can be represented by the
 * font that would be used for a specific Pango::FontDescription load a
 * Pango::Fontset with load_fontset() (load_font() returns the Pango::Font
 * that is the closest match for a Pango::FontDescription; however that's not
 * necessarily the font that will be used for rendering).
 */

class Context : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Context CppObjectType;
  typedef Context_Class CppClassType;
  typedef PangoContext BaseObjectType;
  typedef PangoContextClass BaseClassType;

private:  friend class Context_Class;
  static CppClassType context_class_;

private:
  // noncopyable
  Context(const Context&);
  Context& operator=(const Context&);

protected:
  explicit Context(const Glib::ConstructParams& construct_params);
  explicit Context(PangoContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Context();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  PangoContext*       gobj()       { return reinterpret_cast<PangoContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const PangoContext* gobj() const { return reinterpret_cast<PangoContext*>(gobject_); }

  PangoContext* gobj_copy();

private:

    //PANGO_ENABLE_BACKEND
   
protected:
  Context();

public:
  /** List all available font families for a context.
   * You can specify one of these as your desired font family in the Pango::FontDesciption
   * objects you use, e.g. in the default font description of the context.
   * @return An array of Pango::FontFamily objects.
   */
  Glib::ArrayHandle< Glib::RefPtr<FontFamily> > list_families() const;

  
  Glib::RefPtr<Font> load_font(const FontDescription& desc) const;
  
  Glib::RefPtr<Fontset> load_fontset(const FontDescription& desc, const Language& language) const;

  /** Get overall metric information for a particular font description.
   * The metrics may be substantially different for different scripts. However this
   * function overload returns the metrics of the entire font.
   * @param desc A Pango::FontDescription object.
   * @return A Pango::FontMetrics object.
   */
  FontMetrics get_metrics(const FontDescription& desc) const;
  
  FontMetrics get_metrics(const FontDescription& desc, const Language& language) const;
  
  void set_font_description(const FontDescription& desc);
  
  FontDescription get_font_description() const;
  
  Language get_language() const;
  
  void set_language(const Language& language);
  
  void set_base_dir(Direction direction);
  
  Direction get_base_dir() const;

  /** Breaks a piece of text into segments with consistent directional level and shaping engine.
   * Each byte of @a text will be contained in exactly one of the items in the returned list.
   * The generated list of items will be in logical order (the start offsets of the items
   * are ascending).
   * @param text The text to itemize.
   * @return A list of Pango::Item objects.
   */
  ListHandle_Item itemize(const Glib::ustring& text, const AttrList& attrs) const;

  /** Breaks a piece of text into segments with consistent directional level and shaping engine.
   * Each byte of @a text will be contained in exactly one of the items in the returned list. 
   * The generated list of items will be in logical order (the start offsets of the items
   * are ascending).
   *
   * @a cached_iter should be an iterator over @a attrs currently positioned at a range before
   * or containing @a start_index. @a cached_iter will be advanced to the range covering the
   * position just after @a start_index + @a length. (i.e. if itemizing in a loop, just keep
   * passing in the same @a cached_iter).
   *
   * @param text The text to itemize.
   * @param start_index First byte in @a text to process.
   * @param length The number of bytes (not characters) to process after @a start_index. This must be >= <tt>0</tt>.
   * @param attrs The set of attributes that apply to @a text.
   * @param cached_iter Cached attribute iterator.
   * @return A list of Pango::Item structures.
   */
  ListHandle_Item itemize(const Glib::ustring& text, int start_index, int length,
                          const AttrList& attrs, AttrIter& cached_iter) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Pango */


namespace Glib
{
  /** @relates Pango::Context */
  Glib::RefPtr<Pango::Context> wrap(PangoContext* object, bool take_copy = false);
}


#endif /* _PANGOMM_CONTEXT_H */

