// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PRINTOPERATION_H
#define _GTKMM_PRINTOPERATION_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>

#include <gtkmm/pagesetup.h>
#include <gtkmm/printcontext.h>
#include <gtkmm/printoperationpreview.h>
#include <gtkmm/printsettings.h>
#include <gtkmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPrintOperation GtkPrintOperation;
typedef struct _GtkPrintOperationClass GtkPrintOperationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class PrintOperation_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum PrintStatus
{
  PRINT_STATUS_INITIAL,
  PRINT_STATUS_PREPARING,
  PRINT_STATUS_GENERATING_DATA,
  PRINT_STATUS_SENDING_DATA,
  PRINT_STATUS_PENDING,
  PRINT_STATUS_PENDING_ISSUE,
  PRINT_STATUS_PRINTING,
  PRINT_STATUS_FINISHED,
  PRINT_STATUS_FINISHED_ABORTED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintStatus> : public Glib::Value_Enum<Gtk::PrintStatus>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PrintOperationResult
{
  PRINT_OPERATION_RESULT_ERROR,
  PRINT_OPERATION_RESULT_APPLY,
  PRINT_OPERATION_RESULT_CANCEL,
  PRINT_OPERATION_RESULT_IN_PROGRESS
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintOperationResult> : public Glib::Value_Enum<Gtk::PrintOperationResult>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PrintOperationAction
{
  PRINT_OPERATION_ACTION_PRINT_DIALOG,
  PRINT_OPERATION_ACTION_PRINT,
  PRINT_OPERATION_ACTION_PREVIEW,
  PRINT_OPERATION_ACTION_EXPORT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintOperationAction> : public Glib::Value_Enum<Gtk::PrintOperationAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

class PrintError : public Glib::Error
{
public:
  enum Code
  {
    GENERAL,
    INTERNAL_ERROR,
    NOMEM,
    INVALID_FILE
  };

  PrintError(Code error_code, const Glib::ustring& error_message);
  explicit PrintError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()
#endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintError::Code> : public Glib::Value_Enum<Gtk::PrintError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @defgroup Printing Printing
 */

/** PrintOperation is the high-level, portable printing API. It looks a bit different than other
 * GTK+ dialogs such as the FileChooser, since some platforms don't expose enough infrastructure
 * to implement a good print dialog. On such platforms, PrintOperation uses the native print
 * dialog. On platforms which do not provide a native print dialog, GTK+ uses its own, see PrintUnixDialog.
 *
 * The typical way to use the high-level printing API is to create a PrintOperation object
 * when the user chooses to print. Then you set some properties on it,such as the page size, any PrintSettings
 * from previous print operations, the number of  pages, the current page, etc.
 *
 * Then you start the print operation by calling run(). It will then show a dialog to
 * let the user select a printer and options. When the user finishes the dialog various signals will be
 * emitted by the PrintOperation for you to handle, the main one being draw_page. You should then
 * render the page on the provided PrintContext using Cairo.
 *
 * @newin{2,10}
 *
 * @ingroup Printing
 */

class PrintOperation :
  public Glib::Object,
  public PrintOperationPreview
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef PrintOperation CppObjectType;
  typedef PrintOperation_Class CppClassType;
  typedef GtkPrintOperation BaseObjectType;
  typedef GtkPrintOperationClass BaseClassType;

private:  friend class PrintOperation_Class;
  static CppClassType printoperation_class_;

private:
  // noncopyable
  PrintOperation(const PrintOperation&);
  PrintOperation& operator=(const PrintOperation&);

protected:
  explicit PrintOperation(const Glib::ConstructParams& construct_params);
  explicit PrintOperation(GtkPrintOperation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~PrintOperation();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkPrintOperation*       gobj()       { return reinterpret_cast<GtkPrintOperation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkPrintOperation* gobj() const { return reinterpret_cast<GtkPrintOperation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPrintOperation* gobj_copy();

private:

  
protected:
  PrintOperation();

public:
  
  static Glib::RefPtr<PrintOperation> create();


  /** Makes @a default_page_setup the default page setup for @a op.
   * 
   * This page setup will be used by run(),
   * but it can be overridden on a per-page basis by connecting
   * to the Gtk::PrintOperation::request-page-setup signal.
   * 
   * @newin{2,10}
   * @param default_page_setup A Gtk::PageSetup, or <tt>0</tt>.
   */
  void set_default_page_setup(const Glib::RefPtr<PageSetup>& default_page_setup);
  
  /** Returns the default page setup, see 
   * set_default_page_setup().
   * 
   * @newin{2,10}
   * @return The default page setup.
   */
  Glib::RefPtr<PageSetup> get_default_page_setup() const;

  
  /** Sets the print settings for @a op. This is typically used to
   * re-establish print settings from a previous print operation,
   * see run().
   * 
   * @newin{2,10}
   * @param print_settings Gtk::PrintSettings.
   */
  void set_print_settings(const Glib::RefPtr<PrintSettings>& print_settings);
  
  /** Returns the current print settings. 
   * 
   * Note that the return value is <tt>0</tt> until either 
   * set_print_settings() or 
   * run() have been called.
   * 
   * @newin{2,10}
   * @return The current print settings of @a op.
   */
  Glib::RefPtr<PrintSettings> get_print_settings() const;

  
  /** Sets the name of the print job. The name is used to identify 
   * the job (e.g. in monitoring applications like eggcups). 
   * 
   * If you don't set a job name, GTK+ picks a default one by 
   * numbering successive print jobs.
   * 
   * @newin{2,10}
   * @param job_name A string that identifies the print job.
   */
  void set_job_name(const Glib::ustring& job_name);
  
  /** Sets the number of pages in the document. 
   * 
   * This <emphasis>must</emphasis> be set to a positive number
   * before the rendering starts. It may be set in a 
   * Gtk::PrintOperation::begin-print signal hander.
   * 
   * Note that the page numbers passed to the 
   * Gtk::PrintOperation::request-page-setup 
   * and Gtk::PrintOperation::draw-page signals are 0-based, i.e. if 
   * the user chooses to print all pages, the last ::draw-page signal 
   * will be for page @a n_pages - 1.
   * 
   * @newin{2,10}
   * @param n_pages The number of pages.
   */
  void set_n_pages(int n_pages);
  
  /** Sets the current page.
   * 
   * If this is called before run(), 
   * the user will be able to select to print only the current page.
   * 
   * Note that this only makes sense for pre-paginated documents.
   * 
   * @newin{2,10}
   * @param current_page The current page, 0-based.
   */
  void set_current_page(int current_page);
  
  /** If @a full_page is <tt>true</tt>, the transformation for the cairo context 
   * obtained from Gtk::PrintContext puts the origin at the top left 
   * corner of the page (which may not be the top left corner of the 
   * sheet, depending on page orientation and the number of pages per 
   * sheet). Otherwise, the origin is at the top left corner of the
   * imageable area (i.e. inside the margins).
   * 
   * @newin{2,10}
   * @param full_page <tt>true</tt> to set up the Gtk::PrintContext for the full page.
   */
  void set_use_full_page(bool use_full_page = true);
  
  /** Sets up the transformation for the cairo context obtained from
   * Gtk::PrintContext in such a way that distances are measured in 
   * units of @a unit.
   * 
   * @newin{2,10}
   * @param unit The unit to use.
   */
  void set_unit(Unit unit);
  
  /** Sets up the Gtk::PrintOperation to generate a file instead
   * of showing the print dialog. The indended use of this function
   * is for implementing "Export to PDF" actions. Currently, PDF
   * is the only supported format.
   * 
   * "Print to PDF" support is independent of this and is done
   * by letting the user pick the "Print to PDF" item from the list
   * of printers in the print dialog.
   * 
   * @newin{2,10}
   * @param filename The filename for the exported file.
   */
  void set_export_filename(const std::string& filename);
  
  /** If track_status is <tt>true</tt>, the print operation will try to continue report
   * on the status of the print job in the printer queues and printer. This
   * can allow your application to show things like "out of paper" issues,
   * and when the print job actually reaches the printer.
   * 
   * This function is often implemented using some form of polling, so it should
   * not be enabled unless needed.
   * 
   * @newin{2,10}
   * @param track_status <tt>true</tt> to track status after printing.
   */
  void set_track_print_status(bool track_status = true);
  
  /** If @a show_progress is <tt>true</tt>, the print operation will show a 
   * progress dialog during the print operation.
   * 
   * @newin{2,10}
   * @param show_progress <tt>true</tt> to show a progress dialog.
   */
  void set_show_progress (bool show_progress = true);
  
  /** Sets whether the run() may return
   * before the print operation is completed. Note that
   * some platforms may not allow asynchronous operation.
   * 
   * @newin{2,10}
   * @param allow_async <tt>true</tt> to allow asynchronous operation.
   */
  void set_allow_async(bool allow_async = true);
  
  /** Sets the label for the tab holding custom widgets.
   * 
   * @newin{2,10}
   * @param label The label to use, or <tt>0</tt> to use the default label.
   */
  void set_custom_tab_label(const Glib::ustring& label);

   
  PrintOperationResult run(PrintOperationAction action = PRINT_OPERATION_ACTION_PRINT_DIALOG);

  
  /** Runs the print operation, by first letting the user modify
   * print settings in the print dialog, and then print the document.
   * 
   * Normally that this function does not return until the rendering of all 
   * pages is complete. You can connect to the 
   * Gtk::PrintOperation::status-changed signal on @a op to obtain some 
   * information about the progress of the print operation. 
   * Furthermore, it may use a recursive mainloop to show the print dialog.
   * 
   * If you call set_allow_async() or set the 
   * Gtk::PrintOperation:allow-async property the operation will run 
   * asynchronously if this is supported on the platform. The 
   * Gtk::PrintOperation::done signal will be emitted with the result of the 
   * operation when the it is done (i.e. when the dialog is canceled, or when 
   * the print succeeds or fails).
   * |[
   * if (settings != <tt>0</tt>)
   * gtk_print_operation_set_print_settings (print, settings);
   * 
   * if (page_setup != <tt>0</tt>)
   * gtk_print_operation_set_default_page_setup (print, page_setup);
   * 
   * g_signal_connect (print, "begin-print", 
   * G_CALLBACK (begin_print), &data);
   * g_signal_connect (print, "draw-page", 
   * G_CALLBACK (draw_page), &data);
   * 
   * res = gtk_print_operation_run (print, 
   * GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, 
   * parent, 
   * &error);
   * 
   * if (res == GTK_PRINT_OPERATION_RESULT_ERROR)
   * {
   * error_dialog = gtk_message_dialog_new (GTK_WINDOW (parent),
   * GTK_DIALOG_DESTROY_WITH_PARENT,
   * GTK_MESSAGE_ERROR,
   * GTK_BUTTONS_CLOSE,
   * "Error printing file:<tt>\\n</tt>%s",
   * error->message);
   * g_signal_connect (error_dialog, "response", 
   * G_CALLBACK (gtk_widget_destroy), <tt>0</tt>);
   * gtk_widget_show (error_dialog);
   * g_error_free (error);
   * }
   * else if (res == GTK_PRINT_OPERATION_RESULT_APPLY)
   * {
   * if (settings != <tt>0</tt>)
   * g_object_unref (settings);
   * settings = g_object_ref (gtk_print_operation_get_print_settings (print));
   * }
   * ]|
   * 
   * Note that run() can only be called once on a
   * given Gtk::PrintOperation.
   * 
   * @newin{2,10}
   * @param action The action to start.
   * @param parent Transient parent of the dialog.
   * @return The result of the print operation. A return value of 
   * Gtk::PRINT_OPERATION_RESULT_APPLY indicates that the printing was
   * completed successfully. In this case, it is a good idea to obtain 
   * the used print settings with get_print_settings() 
   * and store them for reuse with the next print operation. A value of
   * Gtk::PRINT_OPERATION_RESULT_IN_PROGRESS means the operation is running
   * asynchronously, and will emit the Gtk::PrintOperation::done signal when 
   * done.
   */
  PrintOperationResult run(PrintOperationAction action, Window& parent);
  
  /** Returns the status of the print operation. 
   * Also see get_status_string().
   * 
   * @newin{2,10}
   * @return The status of the print operation.
   */
  PrintStatus get_status() const;
  
  /** Returns a string representation of the status of the 
   * print operation. The string is translated and suitable
   * for displaying the print status e.g. in a Gtk::Statusbar.
   * 
   * Use get_status() to obtain a status
   * value that is suitable for programmatic use. 
   * 
   * @newin{2,10}
   * @return A string representation of the status
   * of the print operation.
   */
  Glib::ustring get_status_string() const;
  
  /** Cancels a running print operation. This function may
   * be called from a Gtk::PrintOperation::begin-print, 
   * Gtk::PrintOperation::paginate or Gtk::PrintOperation::draw-page
   * signal handler to stop the currently running print 
   * operation.
   * 
   * @newin{2,10}
   */
  void cancel();
  
  /** A convenience function to find out if the print operation
   * is finished, either successfully (Gtk::PRINT_STATUS_FINISHED)
   * or unsuccessfully (Gtk::PRINT_STATUS_FINISHED_ABORTED).
   * 
   * @note when you enable print status tracking the print operation
   * can be in a non-finished state even after done has been called, as
   * the operation status then tracks the print job status on the printer.
   * 
   * @newin{2,10}
   * @return <tt>true</tt>, if the print operation is finished.
   */
  bool is_finished() const;

  
  /** Signalize that drawing of particular page is complete.
   * 
   * It is called after completion of page drawing (e.g. drawing in another
   * thread).
   * If set_defer_drawing() was called before, then this function
   * has to be called by application. In another case it is called by the library
   * itself.
   * 
   * @newin{2,16}
   */
  void draw_page_finish();
  
  /** Sets up the Gtk::PrintOperation to wait for calling of
   * draw_page_finish() from application. It can
   * be used for drawing page in another thread.
   * 
   * This function must be called in the callback of "draw-page" signal.
   * 
   * @newin{2,16}
   */
  void set_defer_drawing();


  /** Sets whether selection is supported by Gtk::PrintOperation.
   * 
   * @newin{2,18}
   * @param support_selection <tt>true</tt> to support selection.
   */
  void set_support_selection(bool support_selection = true);
  
  /** Gets the value of Gtk::PrintOperation::support-selection property.
   * 
   * @newin{2,18}
   * @return Whether the application supports print of selection.
   */
  bool get_support_selection() const;
  
  /** Sets whether there is a selection to print.
   * 
   * Application has to set number of pages to which the selection
   * will draw by set_n_pages() in a callback of
   * Gtk::PrintOperation::begin-print.
   * 
   * @newin{2,18}
   * @param has_selection <tt>true</tt> indicates that a selection exists.
   */
  void set_has_selection(bool has_selection = true);
  
  /** Gets the value of Gtk::PrintOperation::has-selection property.
   * 
   * @newin{2,18}
   * @return Whether there is a selection.
   */
  bool get_has_selection() const;

  
  /** Embed page size combo box and orientation combo box into page setup page.
   * Selected page setup is stored as default page setup in Gtk::PrintOperation.
   * 
   * @newin{2,18}
   * @param embed <tt>true</tt> to embed page setup selection in the Gtk::PrintDialog.
   */
  void set_embed_page_setup(bool embed = true);
  
  /** Gets the value of Gtk::PrintOperation::embed-page-setup property.
   * 
   * @newin{2,18}
   * @return Whether page setup selection combos are embedded.
   */
  bool get_embed_page_setup() const;
  
  /** Returns the number of pages that will be printed.
   * 
   * Note that this value is set during print preparation phase
   * (Gtk::PRINT_STATUS_PREPARING), so this function should never be
   * called before the data generation phase (Gtk::PRINT_STATUS_GENERATING_DATA).
   * You can connect to the Gtk::PrintOperation::status-changed signal
   * and call get_n_pages_to_print() when
   * print status is Gtk::PRINT_STATUS_GENERATING_DATA.
   * This is typically used to track the progress of print operation.
   * 
   * @newin{2,18}
   * @return The number of pages that will be printed.
   */
  int get_n_pages_to_print() const;

  
  //TODO: point out in the docs that the PrintOperationResult enum may also indicate
  // that an error occurred, and in that case it is up to him to handle it.
  
  /**
   * @par Prototype:
   * <tt>void on_my_%done(PrintOperationResult result)</tt>
   */

  Glib::SignalProxy1< void,PrintOperationResult > signal_done();


  /**
   * @par Prototype:
   * <tt>void on_my_%begin_print(const Glib::RefPtr<PrintContext>& context)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& > signal_begin_print();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%paginate(const Glib::RefPtr<PrintContext>& context)</tt>
   */

  Glib::SignalProxy1< bool,const Glib::RefPtr<PrintContext>& > signal_paginate();


  /**
   * @par Prototype:
   * <tt>void on_my_%request_page_setup(const Glib::RefPtr<PrintContext>& context, int page_no, const Glib::RefPtr<PageSetup>& setup)</tt>
   */

  Glib::SignalProxy3< void,const Glib::RefPtr<PrintContext>&,int,const Glib::RefPtr<PageSetup>& > signal_request_page_setup();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%draw_page(const Glib::RefPtr<PrintContext>& context, int page_nr)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<PrintContext>&,int > signal_draw_page();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%end_print(const Glib::RefPtr<PrintContext>& context)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<PrintContext>& > signal_end_print();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%status_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_status_changed();


  /**
   * @par Prototype:
   * <tt>Widget* on_my_%create_custom_widget()</tt>
   */

  Glib::SignalProxy0< Widget* > signal_create_custom_widget();


  /**
   * @par Prototype:
   * <tt>void on_my_%custom_widget_apply(Widget* widget)</tt>
   */

  Glib::SignalProxy1< void,Widget* > signal_custom_widget_apply();


  //TODO: This is causing crashes. Is it still causing crashes? murrayc.
  
  /**
   * @par Prototype:
   * <tt>bool on_my_%preview(const Glib::RefPtr<PrintOperationPreview>& preview, const Glib::RefPtr<PrintContext>& context, Window* parent)</tt>
   */

  Glib::SignalProxy3< bool,const Glib::RefPtr<PrintOperationPreview>&,const Glib::RefPtr<PrintContext>&,Window* > signal_preview();


  //TODO: Remove no_default_handler when we can break ABI.
   

  /**
   * @par Prototype:
   * <tt>void on_my_%update_custom_widget(Gtk::Widget* widget, const Glib::RefPtr<PageSetup>& setup, const Glib::RefPtr<PrintSettings>& settings)</tt>
   */

  Glib::SignalProxy3< void,Gtk::Widget*,const Glib::RefPtr<PageSetup>&,const Glib::RefPtr<PrintSettings>& > signal_update_custom_widget();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPageSetup used by default.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<PageSetup> > property_default_page_setup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPageSetup used by default.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PageSetup> > property_default_page_setup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPrintSettings used for initializing the dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<PrintSettings> > property_print_settings() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkPrintSettings used for initializing the dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<PrintSettings> > property_print_settings() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A string used for identifying the print job.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_job_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A string used for identifying the print job.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_job_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of pages in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_n_pages() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of pages in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_n_pages() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The current page in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_current_page() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The current page in the document.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_current_page() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the origin of the context should be at the corner of the page and not the corner of the imageable area.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_full_page() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the origin of the context should be at the corner of the page and not the corner of the imageable area.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_full_page() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the print operation will continue to report on the print job status after the print data has been sent to the printer or print server.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_track_print_status() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the print operation will continue to report on the print job status after the print data has been sent to the printer or print server.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_track_print_status() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The unit in which distances can be measured in the context.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Unit> property_unit() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The unit in which distances can be measured in the context.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Unit> property_unit() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if a progress dialog is shown while printing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_progress() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if a progress dialog is shown while printing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_progress() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if print process may run asynchronous.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_allow_async() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if print process may run asynchronous.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_allow_async() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Export filename.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<std::string> property_export_filename() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Export filename.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<std::string> property_export_filename() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The status of the print operation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PrintStatus> property_status() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A human-readable description of the status.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_status_string() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Label for the tab containing custom widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_custom_tab_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Label for the tab containing custom widgets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_custom_tab_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the print operation will support print of selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_support_selection() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the print operation will support print of selection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_support_selection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if a selection exists.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_has_selection() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if a selection exists.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_selection() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if page setup combos are embedded in GtkPrintDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_embed_page_setup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if page setup combos are embedded in GtkPrintDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_embed_page_setup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of pages that will be printed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_n_pages_to_print() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_done(PrintOperationResult result);
  virtual void on_begin_print(const Glib::RefPtr<PrintContext>& context);
  virtual bool on_paginate(const Glib::RefPtr<PrintContext>& context);
  virtual void on_request_page_setup(const Glib::RefPtr<PrintContext>& context, int page_no, const Glib::RefPtr<PageSetup>& setup);
  virtual void on_draw_page(const Glib::RefPtr<PrintContext>& context, int page_nr);
  virtual void on_end_print(const Glib::RefPtr<PrintContext>& context);
  virtual void on_status_changed();
  virtual Widget* on_create_custom_widget();
  virtual void on_custom_widget_apply(Widget* widget);
  virtual bool on_preview(const Glib::RefPtr<PrintOperationPreview>& preview, const Glib::RefPtr<PrintContext>& context, Window* parent);


};

  //TODO: Make these static members of a class instead of non-class functions?

  //Note: gtk_run_page_setup_dialog() can take a null page_setup object, but the application should always
  //store and reuse a page_setup object, so I see no need to provide an overload for that. murrayc.
  //TODO: The parent parameter may also be null, so maybe we should add an overload for that.

  /** Runs a page setup dialog, letting the user modify the values from page_setup.
   * If the user cancels the dialog, the returned PageSetup is identical to that passed in @a page_setup,
   * otherwise it contains the modifications done in the dialog.
   *
   * Note that this function may use a recursive mainloop to show the page setup dialog.
   * See run_page_setup_dialog_async() if this is a problem.
   *
   * @param parent Transient parent.
   * @param page_setup An existing GtkPageSetup.
   * @param settings Print settings.
   * @result A new PageSetup object.
   *
   * @since 2.10
   */
  Glib::RefPtr<PageSetup> run_page_setup_dialog(Window& parent,
                                                const Glib::RefPtr<const PageSetup>& page_setup,
                                                const Glib::RefPtr<const PrintSettings>& print_settings);

  /** Runs a page setup dialog, letting the user modify the values from page_setup.
   * If the user cancels the dialog, the returned PageSetup is identical to that passed in @a page_setup,
   * otherwise it contains the modifications done in the dialog.
   *
   * Note that this function may use a recursive mainloop to show the page setup dialog.
   * See run_page_setup_dialog_async() if this is a problem.
   *
   * @param parent Transient parent.
   * @param settings Print settings.
   * @result A new PageSetup object.
   *
   * @since 2.22
   */
  Glib::RefPtr<PageSetup> run_page_setup_dialog(Window& parent,
                                                const Glib::RefPtr<const PrintSettings>& print_settings);

  /** For example,
   * void on_setup_done(const Glib::RefPtr<PageSetup>& page_setup);
   */
  typedef sigc::slot< void, const Glib::RefPtr<PageSetup>& > SlotPrintSetupDone;

  /** Runs a page setup dialog, letting the user modify the values from page_setup.
   *
   * In contrast to run_page_setup_dialog(), this function returns after showing the
   * page setup dialog on platforms that support this, and calls the @a slot from a
   * signal handler for the ::response signal of the dialog.
   *
   * @param parent Transient parent.
   * @param page_setup An existing GtkPageSetup.
   * @param settings Print settings.
   * @result A new PageSetup object.
   * @param slot
   *
   * @since 2.10
   */
  void run_page_setup_dialog_async(Window& parent,
                                   const Glib::RefPtr<const PageSetup>& page_setup,
                                   const Glib::RefPtr<const PrintSettings>& print_settings,
                                   const SlotPrintSetupDone& slot);

  /** Runs a page setup dialog, letting the user modify the values from page_setup.
   *
   * In contrast to run_page_setup_dialog(), this function returns after showing the
   * page setup dialog on platforms that support this, and calls the @a slot from a
   * signal handler for the ::response signal of the dialog.
   *
   * @param parent Transient parent.
   * @param page_setup An existing GtkPageSetup.
   * @param settings Print settings.
   * @result A new PageSetup object.
   * @param slot
   *
   * @since 2.22
   */
  void run_page_setup_dialog_async(Window& parent,
                                   const Glib::RefPtr<const PrintSettings>& print_settings,
                                   const SlotPrintSetupDone& slot);

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::PrintOperation
   */
  Glib::RefPtr<Gtk::PrintOperation> wrap(GtkPrintOperation* object, bool take_copy = false);
}


#endif /* _GTKMM_PRINTOPERATION_H */

