// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PROGRESSBAR_H
#define _GTKMM_PROGRESSBAR_H


#include <glibmm.h>

/* $Id: progressbar.hg,v 1.2 2004/11/10 22:05:57 murrayc Exp $ */

/* progressbar.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkProgressBar GtkProgressBar;
typedef struct _GtkProgressBarClass GtkProgressBarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ProgressBar_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum ProgressBarStyle
{
  PROGRESS_CONTINUOUS,
  PROGRESS_DISCRETE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ProgressBarStyle> : public Glib::Value_Enum<Gtk::ProgressBarStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ProgressBarOrientation
{
  PROGRESS_LEFT_TO_RIGHT,
  PROGRESS_RIGHT_TO_LEFT,
  PROGRESS_BOTTOM_TO_TOP,
  PROGRESS_TOP_TO_BOTTOM
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ProgressBarOrientation> : public Glib::Value_Enum<Gtk::ProgressBarOrientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** A widget which indicates progress visually.
 *
 * The Gtk::ProgressBar is typically used to display the progress of a long
 * running operation. It provides a visual clue that processing is underway.
 * The Gtk::ProgressBar can be used in two different modes: percentage mode
 * and activity mode.
 *
 * When an application can determine how much work needs to take place (e.g.
 * read a fixed number of bytes from a file) and can monitor its progress,
 * it can use the Gtk::ProgressBar in percentage mode and the user sees a
 * growing bar indicating the percentage of the work that has been
 * completed. In this mode, the application is required to call
 * set_fraction() periodically to update the progress bar.
 *
 * When an application has no accurate way of knowing the amount of work to
 * do, it can use the Gtk::ProgressBar in activity mode, which shows
 * activity by a block moving back and forth within the progress area. In
 * this mode, the application is required to call pulse() perodically to
 * update the progress bar.
 *
 * There is quite a bit of flexibility provided to control the appearance of
 * the Gtk::ProgressBar. Functions are provided to control the orientation of
 * the bar, optional text can be displayed along with the bar, and the step
 * size used in activity mode can be set. 
 *
 * The ProgressBar widget looks like this:
 * @image html progressbar1.png
 *
 * @ingroup Widgets
 */

class ProgressBar : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ProgressBar CppObjectType;
  typedef ProgressBar_Class CppClassType;
  typedef GtkProgressBar BaseObjectType;
  typedef GtkProgressBarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ProgressBar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ProgressBar_Class;
  static CppClassType progressbar_class_;

  // noncopyable
  ProgressBar(const ProgressBar&);
  ProgressBar& operator=(const ProgressBar&);

protected:
  explicit ProgressBar(const Glib::ConstructParams& construct_params);
  explicit ProgressBar(GtkProgressBar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkProgressBar*       gobj()       { return reinterpret_cast<GtkProgressBar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkProgressBar* gobj() const { return reinterpret_cast<GtkProgressBar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  ProgressBar();

  
  /** Indicates that some progress is made, but you don't know how much.
   * Causes the progress bar to enter "activity mode," where a block
   * bounces back and forth. Each call to pulse()
   * causes the block to move by a little bit (the amount of movement
   * per pulse is determined by set_pulse_step()).
   */
  void pulse();

  
  /** Retrieves the text displayed superimposed on the progress bar,
   * if any.
   * @return Text.
   */
  Glib::ustring get_text() const;
  
  /** Causes the given @a text to appear superimposed on the progress bar.
   * @param text (allow-none): a UTF-8 string, or <tt>0</tt>.
   */
  void set_text(const Glib::ustring& text);

  
  /** Return value: a fraction from 0.0 to 1.0
   * @return A fraction from 0.0 to 1.0.
   */
  double get_fraction() const;
  
  /** Causes the progress bar to "fill in" the given fraction
   * of the bar. The fraction should be between 0.0 and 1.0,
   * inclusive.
   * @param fraction Fraction of the task that's been completed.
   */
  void set_fraction(double fraction);

  
  /** Retrieves the pulse step set with set_pulse_step()
   * @return A fraction from 0.0 to 1.0.
   */
  double get_pulse_step() const;
  
  /** Sets the fraction of total progress bar length to move the
   * bouncing block for each call to pulse().
   * @param fraction Fraction between 0.0 and 1.0.
   */
  void set_pulse_step(double fraction);

  
  /** Causes the progress bar to switch to a different orientation
   * (left-to-right, right-to-left, top-to-bottom, or bottom-to-top).
   * @param orientation Orientation of the progress bar.
   */
  void set_orientation(ProgressBarOrientation orientation = PROGRESS_LEFT_TO_RIGHT);
  
  /** Retrieves the current progress bar orientation.
   * @return Orientation of the progress bar.
   */
  ProgressBarOrientation get_orientation() const;

  
  /** Sets the mode used to ellipsize (add an ellipsis: "...") the text 
   * if there is not enough space to render the entire string.
   * 
   * @newin{2,6}
   * @param mode A Pango::EllipsizeMode.
   */
  void set_ellipsize(Pango::EllipsizeMode mode);
  
  /** Return value: Pango::EllipsizeMode
   * @return Pango::EllipsizeMode
   * 
   * @newin{2,6}.
   */
  Pango::EllipsizeMode get_ellipsize() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The fraction of total work that has been completed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_fraction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The fraction of total work that has been completed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_fraction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The fraction of total progress to move the bouncing block when pulsed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_pulse_step() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The fraction of total progress to move the bouncing block when pulsed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_pulse_step() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Orientation and growth direction of the progress bar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ProgressBarOrientation> property_orientation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Orientation and growth direction of the progress bar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ProgressBarOrientation> property_orientation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text to be displayed in the progress bar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Text to be displayed in the progress bar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred place to ellipsize the string
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_ellipsize() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred place to ellipsize the string
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_ellipsize() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ProgressBar
   */
  Gtk::ProgressBar* wrap(GtkProgressBar* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_PROGRESSBAR_H */

