// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_TRANSFER_PROGRESS_2_H
#define _LIBGNOMEVFSMM_TRANSFER_PROGRESS_2_H


#include <glibmm.h>

// -*- c++ -*-
/* Copyright 2006 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfs/gnome-vfs-xfer.h>

#include <libgnomevfsmm/enums.h>
#include <libgnomevfsmm/types.h>


namespace Gnome
{

namespace Vfs
{

namespace Transfer2
{

/** Provides progress information for the transfer operation.
 * This is especially useful for interactive programs.
 */
class ProgressInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ProgressInfo CppObjectType;
  typedef GnomeVFSXferProgressInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  ProgressInfo();
  ProgressInfo(GnomeVFSXferProgressInfo* src);
  ~ProgressInfo();

  // Test whether this is a valid instance.
  operator bool() const;

  GnomeVFSXferProgressInfo*       gobj()       { return gobject_; }
  const GnomeVFSXferProgressInfo* gobj() const { return gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  void assign_gobj(GnomeVFSXferProgressInfo* src);
#endif

  //_GET_MEMBER() should really be able to do this automatically,
  // but it's not a problem because it has already been done.

  ProgressStatus get_status() const;
  Result get_vfs_status() const;
  Phase get_phase() const;
  Glib::ustring get_source_name() const;
  Glib::ustring get_target_name() const;
  long int get_file_index() const;
  long int get_total_files() const;
  FileSize get_total_bytes() const;
  FileSize get_file_size() const;
  FileSize get_bytes_copied() const;
  FileSize get_total_bytes_copied() const;
  Glib::ustring get_duplicate_name() const;
  int get_duplicate_count() const;
  bool get_top_level_item() const;

protected:
  GnomeVFSXferProgressInfo* gobject_;

private:
  ProgressInfo(const ProgressInfo&);
  ProgressInfo& operator=(const ProgressInfo&);


};

} // namespace Transfer2
} // namespace Vfs
} // namespace Gnome


#endif /* _LIBGNOMEVFSMM_TRANSFER_PROGRESS_2_H */

