// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgnomevfsmm/async-handle.h>
#include <libgnomevfsmm/private/async-handle_p.h>

#include <libgnomevfs/gnome-vfs-enum-types.h>
/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfsmm/async-handle.h>
#include <libgnomevfsmm/private.h>
#include <libgnomevfs/gnome-vfs-job-limit.h>

namespace //anonymous
{

GnomeVFSGetFileInfoResult* gnome_vfsmm_file_info_result_copy(GnomeVFSGetFileInfoResult* src)
{
  if(!src)
    return 0;

  GnomeVFSGetFileInfoResult* copy = g_new0(GnomeVFSGetFileInfoResult, 1);

  //TODO: Add copy and free to gnome-vfs:
  //Copy and ref the objects.
  copy->uri = src->uri;
  gnome_vfs_uri_ref(copy->uri);

  copy->result = src->result;

  copy->file_info = src->file_info;
  gnome_vfs_file_info_ref(copy->file_info);

  return copy;
}

void gnome_vfsmm_file_info_result_free(GnomeVFSGetFileInfoResult* src)
{
  if(src)
  {
    gnome_vfs_uri_unref(src->uri);
    src->uri = 0;

    //src->result = 0;

    gnome_vfs_file_info_unref(src->file_info);
    src->file_info = 0;

    g_free(src);
  }
}

GnomeVFSFindDirectoryResult* gnome_vfsmm_find_directory_result_copy(GnomeVFSFindDirectoryResult* src)
{
  if(!src)
    return 0;

  GnomeVFSFindDirectoryResult* copy = g_new0(GnomeVFSFindDirectoryResult, 1);

  //TODO: Add copy and free to gnome-vfs:
  //Copy and ref the objects.
  copy->uri = src->uri;
  gnome_vfs_uri_ref(copy->uri);

  copy->result = src->result;

  return copy;
}

void gnome_vfsmm_find_directory_result_free(GnomeVFSFindDirectoryResult* src)
{
  if(src)
  {
    gnome_vfs_uri_unref(src->uri);
    src->uri = 0;

    //src->result = 0;
    
    g_free(src);
  }
}

} //anonymous namespace

namespace Gnome
{

namespace Vfs
{

namespace Async
{

namespace
{

class SignalProxy_AsyncOpen
{
public:
  typedef Async::Handle::SlotOpen SlotType;

  SignalProxy_AsyncOpen(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncOpen();

  static void c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncOpen::SignalProxy_AsyncOpen(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncOpen::~SignalProxy_AsyncOpen()
{}

void SignalProxy_AsyncOpen::c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gpointer callback_data)
{
  SignalProxy_AsyncOpen *const self = static_cast<SignalProxy_AsyncOpen*>(callback_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, static_cast<Result>(result));
    delete self; //This callback will be called once and only once.
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncOpenAsChannel
{
public:
  typedef Async::Handle::SlotOpenAsChannel SlotType;

  SignalProxy_AsyncOpenAsChannel(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncOpenAsChannel();

  static void c_callback(GnomeVFSAsyncHandle *handle, GIOChannel *channel, GnomeVFSResult result, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncOpenAsChannel::SignalProxy_AsyncOpenAsChannel(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncOpenAsChannel::~SignalProxy_AsyncOpenAsChannel()
{}

void SignalProxy_AsyncOpenAsChannel::c_callback(GnomeVFSAsyncHandle *handle, GIOChannel *channel, GnomeVFSResult result, gpointer callback_data)
{
  SignalProxy_AsyncOpenAsChannel *const self = static_cast<SignalProxy_AsyncOpenAsChannel*>(callback_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, Glib::wrap(channel), static_cast<Result>(result));
    delete self; //This callback will be called once and only once.
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncTransferProgress
{
public:
  typedef Async::Handle::SlotTransferProgress SlotType;

  SignalProxy_AsyncTransferProgress(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncTransferProgress();

  static gint c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSXferProgressInfo *info, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncTransferProgress::SignalProxy_AsyncTransferProgress(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncTransferProgress::~SignalProxy_AsyncTransferProgress()
{}

gint SignalProxy_AsyncTransferProgress::c_callback(GnomeVFSAsyncHandle* handle, GnomeVFSXferProgressInfo* info, gpointer callback_data)
{
  SignalProxy_AsyncTransferProgress *const self = static_cast<SignalProxy_AsyncTransferProgress*>(callback_data);
  Gnome::Vfs::Transfer::ProgressInfo progInfo(info);
  gint result = FALSE;

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    result = (self->slot_)(*asyncTemp, progInfo);

    //TODO MemoryLeak: call "delete self;" if last callback call
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  return result;
}

class SignalProxy_Progress
{
public:
  typedef Gnome::Vfs::Transfer::SlotProgress SlotType;

  SignalProxy_Progress(const SlotType& slot);
  ~SignalProxy_Progress();

  static gint c_callback(GnomeVFSXferProgressInfo *info, gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_Progress::SignalProxy_Progress(const SlotType& slot)
:
  slot_ (slot)
{}

SignalProxy_Progress::~SignalProxy_Progress()
{}

gint SignalProxy_Progress::c_callback(GnomeVFSXferProgressInfo* info, gpointer data)
{
  SignalProxy_Progress *const self = static_cast<SignalProxy_Progress*>(data);
  Gnome::Vfs::Transfer::ProgressInfo progInfo(info);
  gint result = FALSE; //It's really meant to be a gboolean.
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    result = (self->slot_)(progInfo);

    //TODO MemoryLeak: call "delete self;" if last callback call
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  return result;
}

class SignalProxy_AsyncRead
{
public:
  typedef Async::Handle::SlotRead SlotType;

  SignalProxy_AsyncRead(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncRead();

  static void c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gpointer buffer, GnomeVFSFileSize bytes_requested, GnomeVFSFileSize bytes_read, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncRead::SignalProxy_AsyncRead(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncRead::~SignalProxy_AsyncRead()
{}

void SignalProxy_AsyncRead::c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gpointer buffer, GnomeVFSFileSize bytes_requested, GnomeVFSFileSize bytes_read, gpointer callback_data)
{
  SignalProxy_AsyncRead *const self = static_cast<SignalProxy_AsyncRead*>(callback_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, static_cast<Result>(result), buffer, static_cast<FileSize>(bytes_requested), static_cast<FileSize>(bytes_read));
    delete self; //This callback will be called once and only once.
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncWrite
{
public:
  typedef Async::Handle::SlotWrite SlotType;

  SignalProxy_AsyncWrite(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncWrite();

  static void c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gconstpointer buffer, GnomeVFSFileSize bytes_requested, GnomeVFSFileSize bytes_read, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncWrite::SignalProxy_AsyncWrite(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncWrite::~SignalProxy_AsyncWrite()
{}

void SignalProxy_AsyncWrite::c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gconstpointer buffer, GnomeVFSFileSize bytes_requested, GnomeVFSFileSize bytes_read, gpointer callback_data)
{
  SignalProxy_AsyncWrite *const self = static_cast<SignalProxy_AsyncWrite*>(callback_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, static_cast<Result>(result), buffer, static_cast<FileSize>(bytes_requested), static_cast<FileSize>(bytes_read));
    delete self; //This callback will be called once and only once.
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncGetFileInfo
{
public:
  typedef Async::Handle::SlotGetFileInfo SlotType;

  SignalProxy_AsyncGetFileInfo(const SlotType& slot, const Async::Handle* async_handle);
  ~SignalProxy_AsyncGetFileInfo();

  static void c_callback(GnomeVFSAsyncHandle *handle, GList *results, gpointer callback_data);
  
protected:
  SlotType slot_;
  const Async::Handle* handle_;
};

SignalProxy_AsyncGetFileInfo::SignalProxy_AsyncGetFileInfo(const SlotType& slot, const Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncGetFileInfo::~SignalProxy_AsyncGetFileInfo()
{}

void SignalProxy_AsyncGetFileInfo::c_callback(GnomeVFSAsyncHandle *handle, GList *results, gpointer callback_data)
{
  SignalProxy_AsyncGetFileInfo *const self = static_cast<SignalProxy_AsyncGetFileInfo*>(callback_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    ListHandleFileInfoResults cppList(results, Glib::OWNERSHIP_SHALLOW);
    (self->slot_)(*asyncTemp, cppList);
    delete self; //This callback will be called once and only once.
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncSetFileInfo
{
public:
  typedef Async::Handle::SlotSetFileInfo SlotType;

  SignalProxy_AsyncSetFileInfo(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncSetFileInfo();

  static void c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, GnomeVFSFileInfo *file_info, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncSetFileInfo::SignalProxy_AsyncSetFileInfo(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncSetFileInfo::~SignalProxy_AsyncSetFileInfo()
{}

void SignalProxy_AsyncSetFileInfo::c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, GnomeVFSFileInfo *file_info, gpointer callback_data)
{
  SignalProxy_AsyncSetFileInfo *const self = static_cast<SignalProxy_AsyncSetFileInfo*>(callback_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, static_cast<Result>(result), Glib::wrap(file_info));
    delete self; //This callback will be called once and only once.
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncLoadDirectory
{
public:
  typedef Async::Handle::SlotLoadDirectory SlotType;

  SignalProxy_AsyncLoadDirectory(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncLoadDirectory();

  static void c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, GList *list, guint entries_read, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncLoadDirectory::SignalProxy_AsyncLoadDirectory(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncLoadDirectory::~SignalProxy_AsyncLoadDirectory()
{}

void SignalProxy_AsyncLoadDirectory::c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, GList *list, guint entries_read, gpointer callback_data)
{
  SignalProxy_AsyncLoadDirectory *const self = static_cast<SignalProxy_AsyncLoadDirectory*>(callback_data);

  #ifdef GLIBM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, static_cast<Result>(result), Glib::ListHandle<Glib::RefPtr<FileInfo> >(list, Glib::OWNERSHIP_NONE), entries_read);

    if (static_cast<Result>(result) == Gnome::Vfs::ERROR_EOF)
      delete self; //This callback will not be called any more.
  #ifdef GLIBM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncFindDirectory
{
public:
  typedef Async::Handle::SlotFindDirectory SlotType;

  SignalProxy_AsyncFindDirectory(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncFindDirectory();

  static void c_callback(GnomeVFSAsyncHandle *handle, GList *results, gpointer callback_data);
  
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncFindDirectory::SignalProxy_AsyncFindDirectory(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncFindDirectory::~SignalProxy_AsyncFindDirectory()
{}

void SignalProxy_AsyncFindDirectory::c_callback(GnomeVFSAsyncHandle *handle, GList *results, gpointer callback_data)
{
  SignalProxy_AsyncFindDirectory *const self = static_cast<SignalProxy_AsyncFindDirectory*>(callback_data);

  #ifdef GLIBM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, ListHandleFindDirectoryResult(results, Glib::OWNERSHIP_SHALLOW));

    delete self; //This callback will be called once and only once.
  #ifdef GLIBM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

class SignalProxy_AsyncFileControl
{
public:
  typedef Async::Handle::SlotFileControl SlotType;

  SignalProxy_AsyncFileControl(const SlotType& slot, Async::Handle* async_handle);
  ~SignalProxy_AsyncFileControl();

  static void c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gpointer operation_data, gpointer callback_data);
  static void c_callback_destroy(gpointer callback_data);
 
protected:
  SlotType slot_;
  Async::Handle* handle_;
};

SignalProxy_AsyncFileControl::SignalProxy_AsyncFileControl(const SlotType& slot, Async::Handle* async_handle)
: slot_(slot), handle_(async_handle)
{}

SignalProxy_AsyncFileControl::~SignalProxy_AsyncFileControl()
{}

void SignalProxy_AsyncFileControl::c_callback(GnomeVFSAsyncHandle *handle, GnomeVFSResult result, gpointer operation_data, gpointer callback_data)
{
  SignalProxy_AsyncFileControl *const self = static_cast<SignalProxy_AsyncFileControl*>(callback_data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    //Instead of getting a 2nd C++ wrapper instance, by doing this:
    //Gnome::Vfs::MonitorHandle monitorTemp(monitor, false /* = does not have ownership */); 
    //We get the same instance that we started with:
    const Gnome::Vfs::Async::Handle* asyncTemp = self->handle_;
    //We need to do this because, calling cancel on it in the C++ callback, will destroy it's underlying instance,
    //and every wrapping instance would need to know about that.
    //
    //I guess that Glib::wrap() would normally just give us the same instance a 2nd time,
    //but that's not available to us here because it's not a real wrapper.

    (self->slot_)(*asyncTemp, static_cast<Result>(result), operation_data);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

void SignalProxy_AsyncFileControl::c_callback_destroy(gpointer callback_data)
{
  delete static_cast<SignalProxy_AsyncFileControl*>(callback_data);
}

} // Anonymous namespace


Handle::Handle()
: gobject_ (0)
{
}

Handle::~Handle()
{
  if(gobject_)
    gnome_vfs_async_cancel(gobject_);
}

void Handle::assign_gobj(GnomeVFSAsyncHandle* src)
{
  if(src != gobject_)
  {
    if(gobject_)
      gnome_vfs_async_cancel(gobject_);

    gobject_ = src;
  }
}

void Handle::open(const Glib::ustring& text_uri, OpenMode open_mode, int priority, const SlotOpen& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpen* proxy = new SignalProxy_AsyncOpen(slot, this);
  
  gnome_vfs_async_open(gobj_addr(), text_uri.c_str(), static_cast<GnomeVFSOpenMode>(open_mode), priority, &SignalProxy_AsyncOpen::c_callback, proxy);
}

void Handle::open(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, int priority, const SlotOpen& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpen* proxy = new SignalProxy_AsyncOpen(slot, this);
  
  gnome_vfs_async_open_uri(gobj_addr(), uri->gobj(), static_cast<GnomeVFSOpenMode>(open_mode), priority, &SignalProxy_AsyncOpen::c_callback, proxy);
}

void Handle::open_as_channel(const Glib::ustring& text_uri, OpenMode open_mode, guint advised_block_size, int priority, const SlotOpenAsChannel& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpenAsChannel* proxy = new SignalProxy_AsyncOpenAsChannel(slot, this);

  gnome_vfs_async_open_as_channel(gobj_addr(), text_uri.c_str(), static_cast<GnomeVFSOpenMode>(open_mode), advised_block_size, priority, &SignalProxy_AsyncOpenAsChannel::c_callback, proxy);
}

void Handle::open_as_channel(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, guint advised_block_size, int priority, const SlotOpenAsChannel& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpenAsChannel* proxy = new SignalProxy_AsyncOpenAsChannel(slot, this);

  gnome_vfs_async_open_uri_as_channel(gobj_addr(), uri->gobj(), static_cast<GnomeVFSOpenMode>(open_mode), advised_block_size, priority, &SignalProxy_AsyncOpenAsChannel::c_callback, proxy);
}

void Handle::create(const Glib::ustring& text_uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotOpen& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpen* proxy = new SignalProxy_AsyncOpen(slot, this);

  gnome_vfs_async_create(gobj_addr(), text_uri.c_str(), static_cast<GnomeVFSOpenMode>(open_mode), exclusive, perm, priority, &SignalProxy_AsyncOpen::c_callback, proxy);
}

void Handle::create(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotOpen& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpen* proxy = new SignalProxy_AsyncOpen(slot, this);

  gnome_vfs_async_create_uri(gobj_addr(), uri->gobj(), static_cast<GnomeVFSOpenMode>(open_mode), exclusive, perm, priority, &SignalProxy_AsyncOpen::c_callback, proxy);
}

void Handle::create_symbolic_link(const Glib::RefPtr<Uri>& uri, const Glib::ustring& uri_reference, int priority, const SlotOpen& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpen* proxy = new SignalProxy_AsyncOpen(slot, this);

  gnome_vfs_async_create_symbolic_link(gobj_addr(), uri->gobj(), uri_reference.c_str(), priority, &SignalProxy_AsyncOpen::c_callback, proxy);
}

void Handle::create_as_channel(const Glib::ustring& text_uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotCreateAsChannel& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpenAsChannel* proxy = new SignalProxy_AsyncOpenAsChannel(slot, this);

  gnome_vfs_async_create_as_channel(gobj_addr(), text_uri.c_str(), static_cast<GnomeVFSOpenMode>(open_mode), exclusive, perm, priority, &SignalProxy_AsyncOpenAsChannel::c_callback, proxy);
}

/*void Handle::create_as_channel(const Glib::RefPtr<Uri> uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotCreateAsChannel& slot)
{
  SignalProxy_AsyncOpenAsChannel proxy(slot, this);
  gnome_vfs_async_create_uri_as_channel(gobj_addr(), uri->gobj(), static_cast<GnomeVFSOpenMode>(open_mode), exclusive, perm, priority, &SignalProxy_AsyncOpenAsChannel::c_callback, &proxy);
}*/

void Handle::close(const SlotClose& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncOpen* proxy = new SignalProxy_AsyncOpen(slot, this);
  gnome_vfs_async_close(gobj(), &SignalProxy_AsyncOpen::c_callback, proxy);
}

void Handle::read(gpointer buffer, guint bytes, const SlotRead& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncRead* proxy = new SignalProxy_AsyncRead(slot, this);
  gnome_vfs_async_read(gobj(), buffer, bytes, &SignalProxy_AsyncRead::c_callback, proxy);
}

void Handle::write(gconstpointer buffer, guint bytes, const SlotWrite& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncWrite* proxy = new SignalProxy_AsyncWrite(slot, this);
  gnome_vfs_async_write(gobj(), buffer, bytes, &SignalProxy_AsyncWrite::c_callback, proxy);
}

void Handle::get_file_info(const ListHandleUris& uri_list, FileInfoOptions options, int priority, const SlotGetFileInfo& slot) const
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncGetFileInfo* proxy = new SignalProxy_AsyncGetFileInfo(slot, this);

  GnomeVFSAsyncHandle* gobject = const_cast<GnomeVFSAsyncHandle*>(gobj());
  gnome_vfs_async_get_file_info(&gobject, uri_list.data(), static_cast<GnomeVFSFileInfoOptions>(options), priority, &SignalProxy_AsyncGetFileInfo::c_callback, proxy);
}

void Handle::set_file_info(const Glib::RefPtr<Uri>& uri, const Glib::RefPtr<FileInfo>& info, SetFileInfoMask mask, FileInfoOptions options, int priority, const SlotSetFileInfo& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncSetFileInfo* proxy = new SignalProxy_AsyncSetFileInfo(slot, this);

  gnome_vfs_async_set_file_info(gobj_addr(), uri->gobj(), info->gobj(), static_cast<GnomeVFSSetFileInfoMask>(mask), static_cast<GnomeVFSFileInfoOptions>(options), priority, &SignalProxy_AsyncSetFileInfo::c_callback, proxy);
}

void Handle::load_directory(const Glib::ustring& text_uri, FileInfoOptions options, guint items_per_notification, int priority, const SlotLoadDirectory& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncLoadDirectory* proxy = new SignalProxy_AsyncLoadDirectory(slot, this);

  gnome_vfs_async_load_directory(gobj_addr(), text_uri.c_str(), static_cast<GnomeVFSFileInfoOptions>(options), items_per_notification, priority, &SignalProxy_AsyncLoadDirectory::c_callback, proxy);
}

void Handle::load_directory(const Glib::RefPtr<Uri>& uri, FileInfoOptions options, guint items_per_notification, int priority, const SlotLoadDirectory& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncLoadDirectory* proxy = new SignalProxy_AsyncLoadDirectory(slot, this);

  gnome_vfs_async_load_directory_uri(gobj_addr(), uri->gobj(), static_cast<GnomeVFSFileInfoOptions>(options), items_per_notification, priority, &SignalProxy_AsyncLoadDirectory::c_callback, proxy);
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Handle::transfer(const Transfer::ListHandleUris& source_uri_list, const Transfer::ListHandleUris& target_uri_list, TransferOptions xfer_options, ErrorMode error_mode, OverwriteMode overwrite_mode, int priority, const SlotTransferProgress& progress_update_callback, const Transfer::SlotProgress& progress_sync_callback)
#else
void Handle::transfer(const Transfer::ListHandleUris& source_uri_list, const Transfer::ListHandleUris& target_uri_list, TransferOptions xfer_options, ErrorMode error_mode, OverwriteMode overwrite_mode, int priority, const SlotTransferProgress& progress_update_callback, const Transfer::SlotProgress& progress_sync_callback, std::auto_ptr<Gnome::Vfs::exception>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  g_warning("gnome-vfsmm Async::Handle::transfer(): This method currently leaks memory.");

  //TODO: Add a verions of gnome_vfs_async_xfer() to gnome-vfs that has a destroy-callback, where we can delete the proxy.
  SignalProxy_AsyncTransferProgress* proxy = new SignalProxy_AsyncTransferProgress(progress_update_callback, this);

  SignalProxy_Progress* proxy_prog = new SignalProxy_Progress(progress_sync_callback);
  GnomeVFSResult result = gnome_vfs_async_xfer(gobj_addr(), source_uri_list.data(), target_uri_list.data(), static_cast<GnomeVFSXferOptions>(xfer_options), static_cast<GnomeVFSXferErrorMode>(error_mode), static_cast<GnomeVFSXferOverwriteMode>(overwrite_mode), priority, &SignalProxy_AsyncTransferProgress::c_callback, proxy, &SignalProxy_Progress::c_callback, proxy_prog);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  handle_result(result);
  #else
  handle_result(result, error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED
}

void Handle::find_directory(const ListHandleUris& near_uri_list, FindDirectoryKind kind, bool create_if_needed, bool find_if_needed, guint permissions, int priority, const SlotFindDirectory& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncFindDirectory* proxy = new SignalProxy_AsyncFindDirectory(slot, this);

  gnome_vfs_async_find_directory(gobj_addr(), near_uri_list.data(), static_cast<GnomeVFSFindDirectoryKind>(kind), create_if_needed, find_if_needed, permissions, priority, &SignalProxy_AsyncFindDirectory::c_callback, proxy);
}

void Handle::file_control(const Glib::ustring& operation, gpointer operation_data, const SlotFileControl& slot)
{
  //This will be deleted in the callback, which will be called once and only once.
  SignalProxy_AsyncFileControl* proxy = new SignalProxy_AsyncFileControl(slot, this);

  gnome_vfs_async_file_control(gobj(), operation.c_str(), operation_data, &SignalProxy_AsyncFileControl::c_callback_destroy, &SignalProxy_AsyncFileControl::c_callback, proxy);
}

void Handle::cancel()
{
  //TODO: When we add versions of the async functions to gnome-vfs, with destroy-callbacks,
  //then those destroy-callbacks will be called when gnome_vfs_async_cancel() is called, and there will be no more leak.
  g_warning("gnome-vfsmm Async::Handle::cancel(): This method currently leaks memory.");

  gnome_vfs_async_cancel(gobj());
}


} //namespace Async

} //namespace Vfs

} //namespace Gnome

//TODO: Fix gmmproc so that it generates correct value_type() specializations so we don't need to hand-code them:
// static
GType Glib::Value<Gnome::Vfs::FindDirectoryKind>::value_type()
{
  return gnome_vfs_find_directory_kind_get_type();
}

namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Vfs::FileInfoResult wrap(GnomeVFSGetFileInfoResult* object, bool take_copy /* = false */)
{
  return Gnome::Vfs::FileInfoResult(object, take_copy);
}

} // namespace Glib


namespace Gnome
{

namespace Vfs
{


FileInfoResult::FileInfoResult()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

FileInfoResult::FileInfoResult(const FileInfoResult& src)
:
  gobject_ ((src.gobject_) ? gnome_vfsmm_file_info_result_copy(src.gobject_) : 0)
{}

FileInfoResult::FileInfoResult(GnomeVFSGetFileInfoResult* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = gnome_vfsmm_file_info_result_copy(castitem);
    else
      gobject_ = 0;
  }
}

FileInfoResult& FileInfoResult::operator=(const FileInfoResult& src)
{
  GnomeVFSGetFileInfoResult *const new_gobject = (src.gobject_) ? gnome_vfsmm_file_info_result_copy(src.gobject_) : 0;

  if(gobject_)
    gnome_vfsmm_file_info_result_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

FileInfoResult::~FileInfoResult()
{
  if(gobject_)
    gnome_vfsmm_file_info_result_free(gobject_);
}

GnomeVFSGetFileInfoResult* FileInfoResult::gobj_copy() const
{
  return gnome_vfsmm_file_info_result_copy(gobject_);
}


 Glib::RefPtr<Uri> FileInfoResult::get_uri() const
{
  return Glib::wrap(gobj()->uri);
}
 
 Result FileInfoResult::get_result() const
{
  return (Result)(gobj()->result);
}
 
 Glib::RefPtr<FileInfo> FileInfoResult::get_file_info() const
{
  return Glib::wrap(gobj()->file_info);
}
 

} // namespace Vfs

} // namespace Gnome


namespace Glib
{

Gnome::Vfs::FindDirectoryResult wrap(GnomeVFSFindDirectoryResult* object, bool take_copy /* = false */)
{
  return Gnome::Vfs::FindDirectoryResult(object, take_copy);
}

} // namespace Glib


namespace Gnome
{

namespace Vfs
{


FindDirectoryResult::FindDirectoryResult()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

FindDirectoryResult::FindDirectoryResult(const FindDirectoryResult& src)
:
  gobject_ ((src.gobject_) ? gnome_vfsmm_find_directory_result_copy(src.gobject_) : 0)
{}

FindDirectoryResult::FindDirectoryResult(GnomeVFSFindDirectoryResult* castitem, bool make_a_copy /* = false */)
{
  if(!make_a_copy)
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
  else
  {
    // We are probably getting it via direct access to a struct,
    // so we can not just take it - we have to take a copy of it.
    if(castitem)
      gobject_ = gnome_vfsmm_find_directory_result_copy(castitem);
    else
      gobject_ = 0;
  }
}

FindDirectoryResult& FindDirectoryResult::operator=(const FindDirectoryResult& src)
{
  GnomeVFSFindDirectoryResult *const new_gobject = (src.gobject_) ? gnome_vfsmm_find_directory_result_copy(src.gobject_) : 0;

  if(gobject_)
    gnome_vfsmm_find_directory_result_free(gobject_);

  gobject_ = new_gobject;

  return *this;
}

FindDirectoryResult::~FindDirectoryResult()
{
  if(gobject_)
    gnome_vfsmm_find_directory_result_free(gobject_);
}

GnomeVFSFindDirectoryResult* FindDirectoryResult::gobj_copy() const
{
  return gnome_vfsmm_find_directory_result_copy(gobject_);
}

 Glib::RefPtr<Uri> FindDirectoryResult::get_uri() const
{
  return Glib::wrap(gobj()->uri);
}
 
 Result FindDirectoryResult::get_result() const
{
  return (Result)(gobj()->result);
}
 

} // namespace Vfs

} // namespace Gnome


namespace Gnome
{

namespace Vfs
{

namespace Async
{


} // namespace Async

} // namespace Vfs

} // namespace Gnome


