// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/targetlist.h>
#include <gtkmm/private/targetlist_p.h>

#include <gtk/gtkselection.h>
/* Copyright 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gtk
{

Glib::RefPtr<Gtk::TargetList> TargetList::create(const ArrayHandle_TargetEntry& targets)
{
  return Glib::wrap(gtk_target_list_new(targets.data(), targets.size()));
}

void TargetList::add(const ArrayHandle_TargetEntry& targets)
{
  gtk_target_list_add_table(gobj(), targets.data(), targets.size());
}

} // namespace Gtk


namespace
{
} // anonymous namespace


/* Why reinterpret_cast<TargetList*>(gobject) is needed:
 *
 * A TargetList instance is in fact always a GtkTargetList instance.
 * Unfortunately, GtkTargetList cannot be a member of TargetList,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because TargetList does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gtk::TargetList> wrap(GtkTargetList* object, bool take_copy)
{
  if(take_copy && object)
    gtk_target_list_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gtk::TargetList>(reinterpret_cast<Gtk::TargetList*>(object));
}

} // namespace Glib


namespace Gtk
{


void TargetList::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_target_list_ref(reinterpret_cast<GtkTargetList*>(const_cast<TargetList*>(this)));
}

void TargetList::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_target_list_unref(reinterpret_cast<GtkTargetList*>(const_cast<TargetList*>(this)));
}

GtkTargetList* TargetList::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GtkTargetList*>(this);
}

const GtkTargetList* TargetList::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GtkTargetList*>(this);
}

GtkTargetList* TargetList::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GtkTargetList *const gobject = reinterpret_cast<GtkTargetList*>(const_cast<TargetList*>(this));
  gtk_target_list_ref(gobject);
  return gobject;
}


void TargetList::add(const Glib::ustring& target, TargetFlags flags, guint info)
{
    gtk_target_list_add(gobj(), Gdk::AtomString::to_c_type(target), (guint)(flags), info);

}


void TargetList::remove(const Glib::ustring& target)
{
    gtk_target_list_remove(gobj(), Gdk::AtomString::to_c_type(target));

}


bool TargetList::find(const Glib::ustring& target, guint* info) const
{
    return gtk_target_list_find(const_cast<GtkTargetList*>(gobj()), Gdk::AtomString::to_c_type(target), info);

}


} // namespace Gtk


