/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * Application settings such as theme, fonts, toolbar icon size and cursor blink
 * times. Most of these are set in the gtk theme or gnome control center and so
 * changing them within applications is discouraged.
 *
 * <p>These have not yet been implemented in Java-Gnome
 */
public class Settings extends GObject 
{

    public Settings() {
        super( getType() );
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gtk_settings_get_type());
    }

    native static final protected int gtk_settings_get_type ();
    native static final protected Handle gtk_settings_get_default ();
}

