/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * The HScrollBar displays a horizontal scrollbar with a slider and
 * a pair of arrow buttons. To create a scrollbar, you must specify the
 * beginning and ending values, the size of the slider, an initial
 * slider position, and how far the slider moves when a mouse clicks
 * the slot.
 * @see VScrollBar
 */
public class HScrollBar extends ScrollBar 
{
	/**
	 * Creates a new ScrollBar
	 * @param adjustment The GtkAdjustment to use, or null to create a 
	 * new adjustment.
	 */
	public HScrollBar(Adjustment adjustment){
		super(gtk_hscrollbar_new(adjustment == null ? null : adjustment.getHandle()));
	}
	
	/**
	 * Construct a HScrollBar from a handle to a native resource.
	 */
	public HScrollBar(Handle handle) {
	    super(handle);
	}
    
    /**
     * Construct a HScrollBar from a handle to a native resource.
     */
    public static HScrollBar getHScrollBar(Handle handle) {
        if (handle == null)
            return null;
        
        HScrollBar obj = (HScrollBar) GObject.getGObjectFromHandle(handle);
        
        if (obj == null)
            obj = new HScrollBar(handle);
        
        return obj;
    }
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hscrollbar_get_type());
	}


    native static final protected int gtk_hscrollbar_get_type ();
    native static final protected Handle gtk_hscrollbar_new (Handle adjustment);

}

