/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <glib.h>
#include "jg_jnu.h"
#ifdef __cplusplus
extern "C" 
{
#endif

GQuark  GError_get_domain (GError * cptr) 
{
    return cptr->domain;
}

/*
 * Class:     org.gnu.glib.Error
 * Method:    getDomain
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_glib_Error_getDomain (JNIEnv *env, jclass cls, jobject obj) 
{
    GError *obj_g = (GError *)getPointerFromHandle(env, obj);
    return (jint)GError_get_domain(obj_g);
}


gint32 GError_get_code (GError * cptr) 
{
    return cptr->code;
}

/*
 * Class:     org.gnu.glib.Error
 * Method:    getCode
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_glib_Error_getCode (JNIEnv *env, jclass cls, jobject obj) 
{
    GError *obj_g = (GError *)getPointerFromHandle(env, obj);
    jint result_j = (jint) (GError_get_code (obj_g));
    return result_j;
}

gchar * GError_get_message (GError * cptr) 
{
    return cptr->message;
}

/*
 * Class:     org.gnu.glib.Error
 * Method:    getMessage
 * Signature: (Lorg/gnu/glib/Handle;)java/Lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_glib_Error_getMessage (JNIEnv *env, jclass cls, jobject obj) 
{
    GError *obj_g = (GError *)getPointerFromHandle(env, obj);
    const gchar *result_g = GError_get_message (obj_g);
    jstring str = (*env)->NewStringUTF(env, result_g);
    return str;
}

/*
 * Class:     org.gnu.glib.Error
 * Method:    g_error_new_literal
 * Signature: (Lorg/gnu/glib/Handle;Ijava.lang.String;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Error_g_1error_1new_1literal (JNIEnv *env, jclass cls, 
    jobject domain, jint code, jstring message) 
{
    GQuark *domain_g = (GQuark *)getPointerFromHandle(env, domain);
    gint32 code_g = (gint32) code;
    const gchar* message_g = (*env)->GetStringUTFChars(env, message, 0);
    jobject retval = getHandleFromPointer(env, g_error_new_literal ((GQuark)domain_g, code_g, message_g));
    (*env)->ReleaseStringUTFChars(env, message, message_g);
    return retval;
}

/*
 * Class:     org.gnu.glib.Error
 * Method:    g_error_free
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_Error_g_1error_1free (JNIEnv *env, jclass cls, jobject error) 
{
    GError *error_g = (GError *)getPointerFromHandle(env, error);
    g_error_free (error_g);
}

#ifdef __cplusplus
}

#endif
