# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtkhtml
VER=3.24.2
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

DEPS=`latest --arch=${ARCH} intltool glib enchant atk pixman libpng cairo pango gtk+ libIDL ORBit2 libbonobo GConf libgnome libxml2 libbonoboui gnome-mime-data gnome-vfs libgnomeui libart-lgpl libglade fontconfig freetype libgnomecanvas gnome-icon-theme libsoup iso-codes`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`
POPT=`latest --arch=${ARCH} popt`
LIBGNURX=`latest --arch=${ARCH} libgnurx`
ZLIB=`latest --arch=${ARCH} zlib`

PKG_CONFIG_PATH=/dummy
for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
    [ -d /devel/dist/${ARCH}/$D/share/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/share/pkgconfig:$PKG_CONFIG_PATH
done

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# shared library, and give the warning "Trying to link with static lib
# archive [...] But I can only do this if you have shared version of
# the library, which you do not appear to have."

# I know what I am doing. I do want to link with a static libintl
# now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include -I/devel/dist/${ARCH}/${LIBGNURX}/include" LDFLAGS="-L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -L/devel/dist/${ARCH}/${POPT}/lib -L/devel/dist/${ARCH}/${LIBGNURX}/lib -L/devel/dist/${ARCH}/${ZLIB}/lib -Wl,--enable-auto-image-base" CFLAGS=-O2 ./configure --disable-static --prefix=c:/devel/target/$HEX &&
libtoolcacheize &&

PATH=/devel/target/$HEX/bin:.libs:$PATH make -j3 install &&

./gtkhtml-zip &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
