/* minefield-view.c generated by valac 0.21.1.1-0d6f, the Vala compiler
 * generated from minefield-view.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <librsvg/rsvg.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_POSITION (position_get_type ())
#define POSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITION, Position))
#define POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POSITION, PositionClass))
#define IS_POSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITION))
#define IS_POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POSITION))
#define POSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POSITION, PositionClass))

typedef struct _Position Position;
typedef struct _PositionClass PositionClass;
typedef struct _PositionPrivate PositionPrivate;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
typedef struct _MinefieldViewPrivate MinefieldViewPrivate;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _minefield_unref0(var) ((var == NULL) ? NULL : (var = (minefield_unref (var), NULL)))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_FLAG_TYPE (flag_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_PangoAttrList_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoAttrList_free (var), NULL)))

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

struct _Position {
	GObject parent_instance;
	PositionPrivate * priv;
};

struct _PositionClass {
	GObjectClass parent_class;
};

struct _PositionPrivate {
	gboolean _is_set;
	gint _x;
	gint _y;
};

struct _MinefieldView {
	GtkDrawingArea parent_instance;
	MinefieldViewPrivate * priv;
};

struct _MinefieldViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _MinefieldViewPrivate {
	gboolean use_question_marks;
	gboolean use_overmine_warning;
	gboolean use_autoflag;
	Position* keyboard_cursor;
	Position* selected;
	gboolean use_number_border;
	guint render_size;
	cairo_pattern_t* flag_pattern;
	cairo_pattern_t* mine_pattern;
	cairo_pattern_t* question_pattern;
	cairo_pattern_t* bang_pattern;
	cairo_pattern_t* warning_pattern;
	cairo_pattern_t** number_patterns;
	gint number_patterns_length1;
	gint _number_patterns_size_;
	Minefield* _minefield;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Neighbour {
	gint x;
	gint y;
};


static gpointer position_parent_class = NULL;
static gpointer minefield_view_parent_class = NULL;

GType position_get_type (void) G_GNUC_CONST;
#define POSITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POSITION, PositionPrivate))
enum  {
	POSITION_DUMMY_PROPERTY,
	POSITION_IS_SET,
	POSITION_IS_VALID,
	POSITION_X,
	POSITION_Y
};
Position* position_new (void);
Position* position_construct (GType object_type);
gboolean position_get_is_set (Position* self);
void position_set_is_set (Position* self, gboolean value);
gboolean position_get_is_valid (Position* self);
gint position_get_x (Position* self);
gint position_get_y (Position* self);
void position_set_x (Position* self, gint value);
void position_set_y (Position* self, gint value);
void position_set_position (Position* self, gint* value, int value_length1);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void position_finalize (GObject* obj);
static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType minefield_view_get_type (void) G_GNUC_CONST;
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD_VIEW, MinefieldViewPrivate))
enum  {
	MINEFIELD_VIEW_DUMMY_PROPERTY,
	MINEFIELD_VIEW_MINEFIELD
};
MinefieldView* minefield_view_new (void);
MinefieldView* minefield_view_construct (GType object_type);
void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks);
void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning);
void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag);
void minefield_view_set_use_number_border (MinefieldView* self, gboolean use_number_border);
static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
GType flag_type_get_type (void) G_GNUC_CONST;
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y);
static cairo_pattern_t* minefield_view_render_svg_pattern (MinefieldView* self, cairo_t* cr, const gchar* filename);
static guint minefield_view_get_mine_size (MinefieldView* self);
static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n);
static PangoAttrList* _vala_PangoAttrList_copy (PangoAttrList* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void _vala_PangoAttrList_free (PangoAttrList* self);
static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
Minefield* minefield_view_get_minefield (MinefieldView* self);
static guint minefield_view_get_minimum_size (MinefieldView* self);
static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static guint minefield_view_get_x_offset (MinefieldView* self);
static guint minefield_view_get_y_offset (MinefieldView* self);
static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
gboolean minefield_is_location (Minefield* self, gint x, gint y);
gboolean minefield_get_paused (Minefield* self);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr);
static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y);
guint minefield_get_n_flags (Minefield* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y);
static void minefield_view_multi_release (MinefieldView* self, guint x, guint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean minefield_get_is_complete (Minefield* self);
static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self);
static void _minefield_view_minefield___lambda2_ (MinefieldView* self, guint x, guint y);
static void __minefield_view_minefield___lambda2__position_redraw (Position* _sender, guint x, guint y, gpointer self);
static gint _minefield_view_minefield___lambda3_ (MinefieldView* self, gint x);
static gint __minefield_view_minefield___lambda3__position_set_x (Position* _sender, gint x, gpointer self);
static gint _minefield_view_minefield___lambda4_ (MinefieldView* self, gint y);
static gint __minefield_view_minefield___lambda4__position_set_y (Position* _sender, gint y, gpointer self);
static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self);
static gint _minefield_view_minefield___lambda5_ (MinefieldView* self, gint x);
static gint __minefield_view_minefield___lambda5__position_set_x (Position* _sender, gint x, gpointer self);
static gint _minefield_view_minefield___lambda6_ (MinefieldView* self, gint y);
static gint __minefield_view_minefield___lambda6__position_set_y (Position* _sender, gint y, gpointer self);
static gboolean _minefield_view_minefield___lambda7_ (MinefieldView* self, gint x, gint y);
static gboolean __minefield_view_minefield___lambda7__position_validate (Position* _sender, gint x, gint y, gpointer self);
static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self);
static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void _minefield_view_minefield___lambda8_ (MinefieldView* self);
static void __minefield_view_minefield___lambda8__minefield_paused_changed (Minefield* _sender, gpointer self);
static void minefield_view_finalize (GObject* obj);
static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const Neighbour neighbour_map[8];

Position* position_construct (GType object_type) {
	Position * self = NULL;
	self = (Position*) g_object_new (object_type, NULL);
	return self;
}


Position* position_new (void) {
	return position_construct (TYPE_POSITION);
}


gboolean position_get_is_set (Position* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_set;
	result = _tmp0_;
	return result;
}


void position_set_is_set (Position* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_is_set;
	_tmp2_ = value;
	if (_tmp1_ != _tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = position_get_is_valid (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp6_ = position_get_x (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = position_get_y (self);
		_tmp9_ = _tmp8_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp7_, (guint) _tmp9_);
	}
	_tmp10_ = value;
	self->priv->_is_set = _tmp10_;
	g_object_notify ((GObject *) self, "is-set");
}


gboolean position_get_is_valid (Position* self) {
	gboolean result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = position_get_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = position_get_y (self);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (self, "validate", _tmp1_, _tmp3_, &_tmp4_);
	result = _tmp4_;
	return result;
}


gint position_get_x (Position* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_x;
	result = _tmp0_;
	return result;
}


void position_set_x (Position* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_x;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp8_ = position_get_x (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = position_get_y (self);
		_tmp11_ = _tmp10_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp9_, (guint) _tmp11_);
	}
	_tmp12_ = value;
	g_signal_emit_by_name (self, "set-x", _tmp12_, &_tmp13_);
	self->priv->_x = _tmp13_;
	_tmp15_ = position_get_is_set (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = position_get_is_valid (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp19_ = _tmp14_;
	if (_tmp19_) {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp20_ = position_get_x (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = position_get_y (self);
		_tmp23_ = _tmp22_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp21_, (guint) _tmp23_);
	}
	g_object_notify ((GObject *) self, "x");
}


gint position_get_y (Position* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_y;
	result = _tmp0_;
	return result;
}


void position_set_y (Position* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_y;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp8_ = position_get_x (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = position_get_y (self);
		_tmp11_ = _tmp10_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp9_, (guint) _tmp11_);
	}
	_tmp12_ = value;
	g_signal_emit_by_name (self, "set-y", _tmp12_, &_tmp13_);
	self->priv->_y = _tmp13_;
	_tmp15_ = position_get_is_set (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = position_get_is_valid (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp19_ = _tmp14_;
	if (_tmp19_) {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp20_ = position_get_x (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = position_get_y (self);
		_tmp23_ = _tmp22_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp21_, (guint) _tmp23_);
	}
	g_object_notify ((GObject *) self, "y");
}


void position_set_position (Position* self, gint* value, int value_length1) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gint* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp29_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_x;
	_tmp2_ = value;
	_tmp2__length1 = value_length1;
	_tmp3_ = _tmp2_[0];
	if (_tmp1_ == _tmp3_) {
		gint _tmp4_ = 0;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		_tmp4_ = self->priv->_y;
		_tmp5_ = value;
		_tmp5__length1 = value_length1;
		_tmp6_ = _tmp5_[1];
		_tmp0_ = _tmp4_ == _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		return;
	}
	_tmp9_ = position_get_is_set (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = position_get_is_valid (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp14_ = position_get_x (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = position_get_y (self);
		_tmp17_ = _tmp16_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp15_, (guint) _tmp17_);
	}
	_tmp18_ = value;
	_tmp18__length1 = value_length1;
	_tmp19_ = _tmp18_[0];
	g_signal_emit_by_name (self, "set-x", _tmp19_, &_tmp20_);
	self->priv->_x = _tmp20_;
	_tmp21_ = value;
	_tmp21__length1 = value_length1;
	_tmp22_ = _tmp21_[1];
	g_signal_emit_by_name (self, "set-y", _tmp22_, &_tmp23_);
	self->priv->_y = _tmp23_;
	_tmp25_ = position_get_is_set (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		_tmp27_ = position_get_is_valid (self);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp29_ = _tmp24_;
	if (_tmp29_) {
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		_tmp30_ = position_get_x (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = position_get_y (self);
		_tmp33_ = _tmp32_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp31_, (guint) _tmp33_);
	}
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT_INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_INT__INT) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_INT__INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), data2);
	g_value_set_int (return_value, v_return);
}


static void position_class_init (PositionClass * klass) {
	position_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PositionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_position_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_position_set_property;
	G_OBJECT_CLASS (klass)->finalize = position_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_SET, g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_VALID, g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_X, g_param_spec_int ("x", "x", "x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_Y, g_param_spec_int ("y", "y", "y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("redraw", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("validate", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT_INT, G_TYPE_BOOLEAN, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("set_x", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
	g_signal_new ("set_y", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
}


static void position_instance_init (Position * self) {
	self->priv = POSITION_GET_PRIVATE (self);
	self->priv->_is_set = FALSE;
	self->priv->_x = 0;
	self->priv->_y = 0;
}


static void position_finalize (GObject* obj) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POSITION, Position);
	G_OBJECT_CLASS (position_parent_class)->finalize (obj);
}


GType position_get_type (void) {
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PositionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) position_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Position), 0, (GInstanceInitFunc) position_instance_init, NULL };
		GType position_type_id;
		position_type_id = g_type_register_static (G_TYPE_OBJECT, "Position", &g_define_type_info, 0);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		g_value_set_boolean (value, position_get_is_set (self));
		break;
		case POSITION_IS_VALID:
		g_value_set_boolean (value, position_get_is_valid (self));
		break;
		case POSITION_X:
		g_value_set_int (value, position_get_x (self));
		break;
		case POSITION_Y:
		g_value_set_int (value, position_get_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		position_set_is_set (self, g_value_get_boolean (value));
		break;
		case POSITION_X:
		position_set_x (self, g_value_get_int (value));
		break;
		case POSITION_Y:
		position_set_y (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


MinefieldView* minefield_view_construct (GType object_type) {
	MinefieldView * self = NULL;
	Position* _tmp0_ = NULL;
	Position* _tmp1_ = NULL;
	cairo_pattern_t** _tmp2_ = NULL;
	self = (MinefieldView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK));
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	_tmp0_ = position_new ();
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp0_;
	_tmp1_ = position_new ();
	_g_object_unref0 (self->priv->keyboard_cursor);
	self->priv->keyboard_cursor = _tmp1_;
	_tmp2_ = g_new0 (cairo_pattern_t*, 8 + 1);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	self->priv->number_patterns = _tmp2_;
	self->priv->number_patterns_length1 = 8;
	self->priv->_number_patterns_size_ = self->priv->number_patterns_length1;
	return self;
}


MinefieldView* minefield_view_new (void) {
	return minefield_view_construct (TYPE_MINEFIELD_VIEW);
}


void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_question_marks;
	self->priv->use_question_marks = _tmp0_;
}


void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_overmine_warning;
	self->priv->use_overmine_warning = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_autoflag;
	self->priv->use_autoflag = _tmp0_;
}


void minefield_view_set_use_number_border (MinefieldView* self, gboolean use_number_border) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->use_number_border;
	_tmp1_ = use_number_border;
	if (_tmp0_ != _tmp1_) {
		self->priv->render_size = (guint) 0;
	}
	_tmp2_ = use_number_border;
	self->priv->use_number_border = _tmp2_;
}


static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Minefield* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = minefield;
				_tmp5_ = _tmp4_->width;
				if (!(((guint) _tmp3_) < _tmp5_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_ = FALSE;
							gint _tmp9_ = 0;
							Minefield* _tmp10_ = NULL;
							guint _tmp11_ = 0U;
							gboolean _tmp12_ = FALSE;
							Minefield* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp27_ = FALSE;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = minefield;
							_tmp11_ = _tmp10_->height;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp13_ = minefield;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp16_ = minefield_has_mine (_tmp13_, (guint) _tmp14_, (guint) _tmp15_);
							if (_tmp16_) {
								_tmp12_ = TRUE;
							} else {
								gboolean _tmp17_ = FALSE;
								Minefield* _tmp18_ = NULL;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gboolean _tmp21_ = FALSE;
								gboolean _tmp26_ = FALSE;
								_tmp18_ = minefield;
								_tmp19_ = x;
								_tmp20_ = y;
								_tmp21_ = minefield_has_mine (_tmp18_, (guint) _tmp19_, (guint) _tmp20_);
								if (!_tmp21_) {
									Minefield* _tmp22_ = NULL;
									gint _tmp23_ = 0;
									gint _tmp24_ = 0;
									FlagType _tmp25_ = 0;
									_tmp22_ = minefield;
									_tmp23_ = x;
									_tmp24_ = y;
									_tmp25_ = minefield_get_flag (_tmp22_, (guint) _tmp23_, (guint) _tmp24_);
									_tmp17_ = _tmp25_ == FLAG_TYPE_FLAG;
								} else {
									_tmp17_ = FALSE;
								}
								_tmp26_ = _tmp17_;
								_tmp12_ = _tmp26_;
							}
							_tmp27_ = _tmp12_;
							if (_tmp27_) {
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								_tmp28_ = x;
								_tmp29_ = y;
								minefield_view_redraw_sector_cb (self, (guint) _tmp28_, (guint) _tmp29_);
							}
						}
					}
				}
			}
		}
	}
}


static cairo_pattern_t* minefield_view_render_svg_pattern (MinefieldView* self, cairo_t* cr, const gchar* filename) {
	cairo_pattern_t* result = NULL;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	cairo_surface_t* _tmp6_ = NULL;
	cairo_t* c = NULL;
	cairo_t* _tmp7_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	gint size = 0;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	GdkPixbuf* _tmp14_ = NULL;
	cairo_pattern_t* pattern = NULL;
	cairo_pattern_t* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cr != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = cr;
	_tmp1_ = cairo_get_target (_tmp0_);
	_tmp2_ = minefield_view_get_mine_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = cairo_surface_create_similar (_tmp1_, CAIRO_CONTENT_COLOR_ALPHA, (gint) _tmp3_, (gint) _tmp5_);
	surface = _tmp6_;
	_tmp7_ = cairo_create (surface);
	c = _tmp7_;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	size = ((gint) _tmp9_) - 2;
	{
		GdkPixbuf* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		_tmp11_ = filename;
		_tmp12_ = rsvg_pixbuf_from_file_at_size (_tmp11_, size, size, &_inner_error_);
		_tmp10_ = _tmp12_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp10_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, size, size);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp13_;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = pixbuf;
	gdk_cairo_set_source_pixbuf (c, _tmp14_, (gdouble) 1, (gdouble) 1);
	cairo_paint (c);
	_tmp15_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp15_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_g_object_unref0 (pixbuf);
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


static PangoAttrList* _vala_PangoAttrList_copy (PangoAttrList* self) {
	return g_boxed_copy (pango_attr_list_get_type (), self);
}


static gpointer __vala_PangoAttrList_copy0 (gpointer self) {
	return self ? _vala_PangoAttrList_copy (self) : NULL;
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static void _vala_PangoAttrList_free (PangoAttrList* self) {
	g_boxed_free (pango_attr_list_get_type (), self);
}


static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n) {
	cairo_pattern_t* result = NULL;
	PangoLayout* layout = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PangoLayout* _tmp3_ = NULL;
	PangoLayout* _tmp4_ = NULL;
	PangoLayout* _tmp5_ = NULL;
	PangoAttrList* attributes = NULL;
	PangoAttrList* _tmp6_ = NULL;
	PangoAttribute* color_attribute = NULL;
	gdouble color_outline[3] = {0};
	guint _tmp7_ = 0U;
	PangoAttribute* _tmp24_ = NULL;
	PangoAttribute* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	PangoAttrList* _tmp27_ = NULL;
	PangoAttribute* _tmp28_ = NULL;
	PangoFontDescription* font_desc = NULL;
	PangoFontDescription* _tmp29_ = NULL;
	PangoFontDescription* _tmp30_ = NULL;
	gdouble font_size = 0.0;
	guint _tmp31_ = 0U;
	guint _tmp32_ = 0U;
	PangoFontDescription* _tmp33_ = NULL;
	gdouble _tmp34_ = 0.0;
	PangoFontDescription* _tmp35_ = NULL;
	PangoAttrFontDesc* font_attribute = NULL;
	PangoFontDescription* _tmp36_ = NULL;
	PangoAttrFontDesc* _tmp37_ = NULL;
	PangoAttrFontDesc* _tmp38_ = NULL;
	PangoAttrFontDesc* _tmp39_ = NULL;
	guint _tmp40_ = 0U;
	PangoAttrList* _tmp41_ = NULL;
	PangoAttrFontDesc* _tmp42_ = NULL;
	PangoLayout* _tmp43_ = NULL;
	PangoAttrList* _tmp44_ = NULL;
	PangoAttrList* _tmp45_ = NULL;
	cairo_surface_t* surface = NULL;
	guint _tmp46_ = 0U;
	guint _tmp47_ = 0U;
	guint _tmp48_ = 0U;
	guint _tmp49_ = 0U;
	cairo_surface_t* _tmp50_ = NULL;
	cairo_t* c = NULL;
	cairo_surface_t* _tmp51_ = NULL;
	cairo_t* _tmp52_ = NULL;
	PangoRectangle extent = {0};
	PangoLayout* _tmp53_ = NULL;
	PangoRectangle _tmp54_ = {0};
	gint dx = 0;
	guint _tmp55_ = 0U;
	guint _tmp56_ = 0U;
	PangoRectangle _tmp57_ = {0};
	gint _tmp58_ = 0;
	gint dy = 0;
	guint _tmp59_ = 0U;
	guint _tmp60_ = 0U;
	PangoRectangle _tmp61_ = {0};
	gint _tmp62_ = 0;
	cairo_t* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	cairo_t* _tmp66_ = NULL;
	PangoLayout* _tmp67_ = NULL;
	gboolean _tmp68_ = FALSE;
	cairo_pattern_t* pattern = NULL;
	cairo_surface_t* _tmp79_ = NULL;
	cairo_pattern_t* _tmp80_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = n;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	layout = _tmp4_;
	_tmp5_ = layout;
	pango_layout_set_alignment (_tmp5_, PANGO_ALIGN_CENTER);
	_tmp6_ = pango_attr_list_new ();
	attributes = _tmp6_;
	_tmp7_ = n;
	switch (_tmp7_) {
		case 1:
		{
			PangoAttribute* _tmp8_ = NULL;
			gdouble _tmp9_[3] = {0};
			_tmp8_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp8_;
			_tmp9_[0] = 0.0;
			_tmp9_[1] = 0.0;
			_tmp9_[2] = 0.5;
			memcpy (color_outline, _tmp9_, 3 * sizeof (gdouble));
			break;
		}
		case 2:
		{
			PangoAttribute* _tmp10_ = NULL;
			gdouble _tmp11_[3] = {0};
			_tmp10_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xa0a0, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp10_;
			_tmp11_[0] = 0.0;
			_tmp11_[1] = 0.5 * 0.62745098039;
			_tmp11_[2] = 0.0;
			memcpy (color_outline, _tmp11_, 3 * sizeof (gdouble));
			break;
		}
		case 3:
		{
			PangoAttribute* _tmp12_ = NULL;
			gdouble _tmp13_[3] = {0};
			_tmp12_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp12_;
			_tmp13_[0] = 0.5;
			_tmp13_[1] = 0.0;
			_tmp13_[2] = 0.0;
			memcpy (color_outline, _tmp13_, 3 * sizeof (gdouble));
			break;
		}
		case 4:
		{
			PangoAttribute* _tmp14_ = NULL;
			gdouble _tmp15_[3] = {0};
			_tmp14_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x7fff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp14_;
			_tmp15_[0] = 0.0;
			_tmp15_[1] = 0.0;
			_tmp15_[2] = 0.5 * 0.49999237048;
			memcpy (color_outline, _tmp15_, 3 * sizeof (gdouble));
			break;
		}
		case 5:
		{
			PangoAttribute* _tmp16_ = NULL;
			gdouble _tmp17_[3] = {0};
			_tmp16_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp16_;
			_tmp17_[0] = 0.5 * 0.62745098039;
			_tmp17_[1] = 0.0;
			_tmp17_[2] = 0.0;
			memcpy (color_outline, _tmp17_, 3 * sizeof (gdouble));
			break;
		}
		case 6:
		{
			PangoAttribute* _tmp18_ = NULL;
			gdouble _tmp19_[3] = {0};
			_tmp18_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xffff, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp18_;
			_tmp19_[0] = 0.0;
			_tmp19_[1] = 0.5;
			_tmp19_[2] = 0.5;
			memcpy (color_outline, _tmp19_, 3 * sizeof (gdouble));
			break;
		}
		case 7:
		{
			PangoAttribute* _tmp20_ = NULL;
			gdouble _tmp21_[3] = {0};
			_tmp20_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0xa0a0);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp20_;
			_tmp21_[0] = 0.5 * 0.62745098039;
			_tmp21_[1] = 0.0;
			_tmp21_[2] = 0.5 * 0.62745098039;
			memcpy (color_outline, _tmp21_, 3 * sizeof (gdouble));
			break;
		}
		default:
		case 8:
		{
			PangoAttribute* _tmp22_ = NULL;
			gdouble _tmp23_[3] = {0};
			_tmp22_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp22_;
			_tmp23_[0] = 0.0;
			_tmp23_[1] = 0.0;
			_tmp23_[2] = 0.0;
			memcpy (color_outline, _tmp23_, 3 * sizeof (gdouble));
			break;
		}
	}
	_tmp24_ = color_attribute;
	_tmp24_->start_index = (guint) 0;
	_tmp25_ = color_attribute;
	_tmp26_ = G_MAXUINT;
	_tmp25_->end_index = _tmp26_;
	_tmp27_ = attributes;
	_tmp28_ = color_attribute;
	color_attribute = NULL;
	pango_attr_list_insert (_tmp27_, _tmp28_);
	_tmp29_ = pango_font_description_new ();
	font_desc = _tmp29_;
	_tmp30_ = font_desc;
	pango_font_description_set_family (_tmp30_, "Sans");
	_tmp31_ = minefield_view_get_mine_size (self);
	_tmp32_ = _tmp31_;
	font_size = ((_tmp32_ - 2) * PANGO_SCALE) * 0.85;
	_tmp33_ = font_desc;
	_tmp34_ = font_size;
	pango_font_description_set_absolute_size (_tmp33_, _tmp34_);
	_tmp35_ = font_desc;
	pango_font_description_set_weight (_tmp35_, PANGO_WEIGHT_BOLD);
	_tmp36_ = font_desc;
	_tmp37_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp36_);
	font_attribute = _tmp37_;
	_tmp38_ = font_attribute;
	((PangoAttribute*) _tmp38_)->start_index = (guint) 0;
	_tmp39_ = font_attribute;
	_tmp40_ = G_MAXUINT;
	((PangoAttribute*) _tmp39_)->end_index = _tmp40_;
	_tmp41_ = attributes;
	_tmp42_ = font_attribute;
	font_attribute = NULL;
	pango_attr_list_insert (_tmp41_, (PangoAttribute*) _tmp42_);
	_tmp43_ = layout;
	_tmp44_ = attributes;
	_tmp45_ = __vala_PangoAttrList_copy0 (_tmp44_);
	pango_layout_set_attributes (_tmp43_, _tmp45_);
	_tmp46_ = minefield_view_get_mine_size (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = minefield_view_get_mine_size (self);
	_tmp49_ = _tmp48_;
	_tmp50_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp47_, (gint) _tmp49_);
	surface = _tmp50_;
	_tmp51_ = surface;
	_tmp52_ = cairo_create (_tmp51_);
	c = _tmp52_;
	_tmp53_ = layout;
	pango_layout_get_extents (_tmp53_, NULL, &_tmp54_);
	extent = _tmp54_;
	_tmp55_ = minefield_view_get_mine_size (self);
	_tmp56_ = _tmp55_;
	_tmp57_ = extent;
	_tmp58_ = _tmp57_.width;
	dx = (((((gint) _tmp56_) - 2) - (_tmp58_ / PANGO_SCALE)) / 2) + 1;
	_tmp59_ = minefield_view_get_mine_size (self);
	_tmp60_ = _tmp59_;
	_tmp61_ = extent;
	_tmp62_ = _tmp61_.height;
	dy = (((((gint) _tmp60_) - 2) - (_tmp62_ / PANGO_SCALE)) / 2) + 1;
	_tmp63_ = c;
	_tmp64_ = dx;
	_tmp65_ = dy;
	cairo_move_to (_tmp63_, (gdouble) _tmp64_, (gdouble) _tmp65_);
	_tmp66_ = c;
	_tmp67_ = layout;
	pango_cairo_show_layout (_tmp66_, _tmp67_);
	_tmp68_ = self->priv->use_number_border;
	if (_tmp68_) {
		cairo_t* _tmp69_ = NULL;
		cairo_t* _tmp70_ = NULL;
		cairo_t* _tmp71_ = NULL;
		gdouble _tmp72_ = 0.0;
		gdouble _tmp73_ = 0.0;
		gdouble _tmp74_ = 0.0;
		cairo_t* _tmp75_ = NULL;
		PangoLayout* _tmp76_ = NULL;
		cairo_t* _tmp77_ = NULL;
		cairo_t* _tmp78_ = NULL;
		_tmp69_ = c;
		cairo_save (_tmp69_);
		_tmp70_ = c;
		cairo_set_line_width (_tmp70_, 1.0);
		_tmp71_ = c;
		_tmp72_ = color_outline[0];
		_tmp73_ = color_outline[1];
		_tmp74_ = color_outline[2];
		cairo_set_source_rgb (_tmp71_, _tmp72_, _tmp73_, _tmp74_);
		_tmp75_ = c;
		_tmp76_ = layout;
		pango_cairo_layout_path (_tmp75_, _tmp76_);
		_tmp77_ = c;
		cairo_stroke_preserve (_tmp77_);
		_tmp78_ = c;
		cairo_restore (_tmp78_);
	}
	_tmp79_ = surface;
	_tmp80_ = cairo_pattern_create_for_surface (_tmp79_);
	pattern = _tmp80_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	_pango_attribute_destroy0 (font_attribute);
	__vala_PangoFontDescription_free0 (font_desc);
	_pango_attribute_destroy0 (color_attribute);
	__vala_PangoAttrList_free0 (attributes);
	_g_object_unref0 (layout);
	return result;
}


static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->height;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_x_offset (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = minefield_view_get_mine_size (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = minefield_view_get_y_offset (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = y;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = minefield_view_get_mine_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = minefield_view_get_mine_size (self);
	_tmp13_ = _tmp12_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp1_ + (_tmp2_ * _tmp4_)), (gint) (_tmp6_ + (_tmp7_ * _tmp9_)), (gint) _tmp11_, (gint) _tmp13_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y) {
	gboolean is_down = FALSE;
	gboolean _tmp0_ = FALSE;
	Position* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Minefield* _tmp65_ = NULL;
	Minefield* _tmp66_ = NULL;
	guint _tmp67_ = 0U;
	guint _tmp68_ = 0U;
	gboolean _tmp69_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	is_down = FALSE;
	_tmp1_ = self->priv->selected;
	_tmp2_ = position_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Position* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->selected;
		_tmp5_ = position_get_is_set (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		guint _tmp10_ = 0U;
		Position* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp36_ = FALSE;
		_tmp10_ = x;
		_tmp11_ = self->priv->selected;
		_tmp12_ = position_get_x (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp10_ == ((guint) _tmp13_)) {
			guint _tmp14_ = 0U;
			Position* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			_tmp14_ = y;
			_tmp15_ = self->priv->selected;
			_tmp16_ = position_get_y (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp9_ = _tmp14_ == ((guint) _tmp17_);
		} else {
			_tmp9_ = FALSE;
		}
		_tmp18_ = _tmp9_;
		if (_tmp18_) {
			Minefield* _tmp19_ = NULL;
			Minefield* _tmp20_ = NULL;
			guint _tmp21_ = 0U;
			guint _tmp22_ = 0U;
			FlagType _tmp23_ = 0;
			_tmp19_ = minefield_view_get_minefield (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = x;
			_tmp22_ = y;
			_tmp23_ = minefield_get_flag (_tmp20_, _tmp21_, _tmp22_);
			_tmp8_ = _tmp23_ != FLAG_TYPE_FLAG;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp24_ = _tmp8_;
		is_down = _tmp24_;
		_tmp26_ = is_down;
		if (!_tmp26_) {
			Minefield* _tmp27_ = NULL;
			Minefield* _tmp28_ = NULL;
			Position* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			Position* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gboolean _tmp35_ = FALSE;
			_tmp27_ = minefield_view_get_minefield (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = self->priv->selected;
			_tmp30_ = position_get_x (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->selected;
			_tmp33_ = position_get_y (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = minefield_is_cleared (_tmp28_, (guint) _tmp31_, (guint) _tmp34_);
			_tmp25_ = _tmp35_;
		} else {
			_tmp25_ = FALSE;
		}
		_tmp36_ = _tmp25_;
		if (_tmp36_) {
			{
				Neighbour* neighbour_collection = NULL;
				gint neighbour_collection_length1 = 0;
				gint _neighbour_collection_size_ = 0;
				gint neighbour_it = 0;
				neighbour_collection = neighbour_map;
				neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
				for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
					Neighbour neighbour = {0};
					neighbour = neighbour_collection[neighbour_it];
					{
						gint nx = 0;
						Position* _tmp37_ = NULL;
						gint _tmp38_ = 0;
						gint _tmp39_ = 0;
						Neighbour _tmp40_ = {0};
						gint _tmp41_ = 0;
						gint ny = 0;
						Position* _tmp42_ = NULL;
						gint _tmp43_ = 0;
						gint _tmp44_ = 0;
						Neighbour _tmp45_ = {0};
						gint _tmp46_ = 0;
						Minefield* _tmp47_ = NULL;
						Minefield* _tmp48_ = NULL;
						gint _tmp49_ = 0;
						gint _tmp50_ = 0;
						gboolean _tmp51_ = FALSE;
						gboolean _tmp52_ = FALSE;
						gboolean _tmp53_ = FALSE;
						guint _tmp54_ = 0U;
						gint _tmp55_ = 0;
						gboolean _tmp58_ = FALSE;
						gboolean _tmp64_ = FALSE;
						_tmp37_ = self->priv->selected;
						_tmp38_ = position_get_x (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = neighbour;
						_tmp41_ = _tmp40_.x;
						nx = ((gint) _tmp39_) + _tmp41_;
						_tmp42_ = self->priv->selected;
						_tmp43_ = position_get_y (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = neighbour;
						_tmp46_ = _tmp45_.y;
						ny = ((gint) _tmp44_) + _tmp46_;
						_tmp47_ = minefield_view_get_minefield (self);
						_tmp48_ = _tmp47_;
						_tmp49_ = nx;
						_tmp50_ = ny;
						_tmp51_ = minefield_is_location (_tmp48_, _tmp49_, _tmp50_);
						if (!_tmp51_) {
							continue;
						}
						_tmp54_ = x;
						_tmp55_ = nx;
						if (_tmp54_ == ((guint) _tmp55_)) {
							guint _tmp56_ = 0U;
							gint _tmp57_ = 0;
							_tmp56_ = y;
							_tmp57_ = ny;
							_tmp53_ = _tmp56_ == ((guint) _tmp57_);
						} else {
							_tmp53_ = FALSE;
						}
						_tmp58_ = _tmp53_;
						if (_tmp58_) {
							Minefield* _tmp59_ = NULL;
							Minefield* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							gint _tmp62_ = 0;
							FlagType _tmp63_ = 0;
							_tmp59_ = minefield_view_get_minefield (self);
							_tmp60_ = _tmp59_;
							_tmp61_ = nx;
							_tmp62_ = ny;
							_tmp63_ = minefield_get_flag (_tmp60_, (guint) _tmp61_, (guint) _tmp62_);
							_tmp52_ = _tmp63_ != FLAG_TYPE_FLAG;
						} else {
							_tmp52_ = FALSE;
						}
						_tmp64_ = _tmp52_;
						if (_tmp64_) {
							is_down = TRUE;
						}
					}
				}
			}
		}
	}
	_tmp65_ = minefield_view_get_minefield (self);
	_tmp66_ = _tmp65_;
	_tmp67_ = x;
	_tmp68_ = y;
	_tmp69_ = minefield_is_cleared (_tmp66_, _tmp67_, _tmp68_);
	if (_tmp69_) {
		Minefield* _tmp70_ = NULL;
		Minefield* _tmp71_ = NULL;
		gboolean _tmp72_ = FALSE;
		gboolean _tmp73_ = FALSE;
		Minefield* _tmp74_ = NULL;
		Minefield* _tmp75_ = NULL;
		guint _tmp76_ = 0U;
		guint _tmp77_ = 0U;
		gboolean _tmp78_ = FALSE;
		_tmp70_ = minefield_view_get_minefield (self);
		_tmp71_ = _tmp70_;
		_tmp72_ = minefield_get_paused (_tmp71_);
		_tmp73_ = _tmp72_;
		if (_tmp73_) {
			return;
		}
		_tmp74_ = minefield_view_get_minefield (self);
		_tmp75_ = _tmp74_;
		_tmp76_ = x;
		_tmp77_ = y;
		_tmp78_ = minefield_has_mine (_tmp75_, _tmp76_, _tmp77_);
		if (_tmp78_) {
			cairo_pattern_t* _tmp79_ = NULL;
			cairo_t* _tmp84_ = NULL;
			cairo_pattern_t* _tmp85_ = NULL;
			cairo_t* _tmp86_ = NULL;
			guint _tmp87_ = 0U;
			guint _tmp88_ = 0U;
			guint _tmp89_ = 0U;
			guint _tmp90_ = 0U;
			cairo_t* _tmp91_ = NULL;
			_tmp79_ = self->priv->bang_pattern;
			if (_tmp79_ == NULL) {
				cairo_t* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
				cairo_pattern_t* _tmp83_ = NULL;
				_tmp80_ = cr;
				_tmp81_ = g_build_filename (DATA_DIRECTORY, "bang.svg", NULL);
				_tmp82_ = _tmp81_;
				_tmp83_ = minefield_view_render_svg_pattern (self, _tmp80_, _tmp82_);
				_cairo_pattern_destroy0 (self->priv->bang_pattern);
				self->priv->bang_pattern = _tmp83_;
				_g_free0 (_tmp82_);
			}
			_tmp84_ = cr;
			_tmp85_ = self->priv->bang_pattern;
			cairo_set_source (_tmp84_, _tmp85_);
			_tmp86_ = cr;
			_tmp87_ = minefield_view_get_mine_size (self);
			_tmp88_ = _tmp87_;
			_tmp89_ = minefield_view_get_mine_size (self);
			_tmp90_ = _tmp89_;
			cairo_rectangle (_tmp86_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp88_, (gdouble) _tmp90_);
			_tmp91_ = cr;
			cairo_fill (_tmp91_);
		} else {
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_ = FALSE;
			gboolean _tmp99_ = FALSE;
			guint n = 0U;
			Minefield* _tmp113_ = NULL;
			Minefield* _tmp114_ = NULL;
			guint _tmp115_ = 0U;
			guint _tmp116_ = 0U;
			guint _tmp117_ = 0U;
			guint _tmp118_ = 0U;
			_tmp93_ = self->priv->use_overmine_warning;
			if (_tmp93_) {
				Minefield* _tmp94_ = NULL;
				Minefield* _tmp95_ = NULL;
				guint _tmp96_ = 0U;
				guint _tmp97_ = 0U;
				gboolean _tmp98_ = FALSE;
				_tmp94_ = minefield_view_get_minefield (self);
				_tmp95_ = _tmp94_;
				_tmp96_ = x;
				_tmp97_ = y;
				_tmp98_ = minefield_has_flag_warning (_tmp95_, _tmp96_, _tmp97_);
				_tmp92_ = _tmp98_;
			} else {
				_tmp92_ = FALSE;
			}
			_tmp99_ = _tmp92_;
			if (_tmp99_) {
				cairo_pattern_t* _tmp100_ = NULL;
				cairo_t* _tmp105_ = NULL;
				cairo_pattern_t* _tmp106_ = NULL;
				cairo_t* _tmp107_ = NULL;
				guint _tmp108_ = 0U;
				guint _tmp109_ = 0U;
				guint _tmp110_ = 0U;
				guint _tmp111_ = 0U;
				cairo_t* _tmp112_ = NULL;
				_tmp100_ = self->priv->warning_pattern;
				if (_tmp100_ == NULL) {
					cairo_t* _tmp101_ = NULL;
					gchar* _tmp102_ = NULL;
					gchar* _tmp103_ = NULL;
					cairo_pattern_t* _tmp104_ = NULL;
					_tmp101_ = cr;
					_tmp102_ = g_build_filename (DATA_DIRECTORY, "warning.svg", NULL);
					_tmp103_ = _tmp102_;
					_tmp104_ = minefield_view_render_svg_pattern (self, _tmp101_, _tmp103_);
					_cairo_pattern_destroy0 (self->priv->warning_pattern);
					self->priv->warning_pattern = _tmp104_;
					_g_free0 (_tmp103_);
				}
				_tmp105_ = cr;
				_tmp106_ = self->priv->warning_pattern;
				cairo_set_source (_tmp105_, _tmp106_);
				_tmp107_ = cr;
				_tmp108_ = minefield_view_get_mine_size (self);
				_tmp109_ = _tmp108_;
				_tmp110_ = minefield_view_get_mine_size (self);
				_tmp111_ = _tmp110_;
				cairo_rectangle (_tmp107_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp109_, (gdouble) _tmp111_);
				_tmp112_ = cr;
				cairo_fill (_tmp112_);
			}
			_tmp113_ = minefield_view_get_minefield (self);
			_tmp114_ = _tmp113_;
			_tmp115_ = x;
			_tmp116_ = y;
			_tmp117_ = minefield_get_n_adjacent_mines (_tmp114_, _tmp115_, _tmp116_);
			n = _tmp117_;
			_tmp118_ = n;
			if (_tmp118_ != ((guint) 0)) {
				cairo_pattern_t** _tmp119_ = NULL;
				gint _tmp119__length1 = 0;
				guint _tmp120_ = 0U;
				cairo_pattern_t* _tmp121_ = NULL;
				cairo_t* _tmp127_ = NULL;
				cairo_pattern_t** _tmp128_ = NULL;
				gint _tmp128__length1 = 0;
				guint _tmp129_ = 0U;
				cairo_pattern_t* _tmp130_ = NULL;
				cairo_t* _tmp131_ = NULL;
				guint _tmp132_ = 0U;
				guint _tmp133_ = 0U;
				guint _tmp134_ = 0U;
				guint _tmp135_ = 0U;
				cairo_t* _tmp136_ = NULL;
				_tmp119_ = self->priv->number_patterns;
				_tmp119__length1 = self->priv->number_patterns_length1;
				_tmp120_ = n;
				_tmp121_ = _tmp119_[_tmp120_ - 1];
				if (_tmp121_ == NULL) {
					cairo_pattern_t** _tmp122_ = NULL;
					gint _tmp122__length1 = 0;
					guint _tmp123_ = 0U;
					guint _tmp124_ = 0U;
					cairo_pattern_t* _tmp125_ = NULL;
					cairo_pattern_t* _tmp126_ = NULL;
					_tmp122_ = self->priv->number_patterns;
					_tmp122__length1 = self->priv->number_patterns_length1;
					_tmp123_ = n;
					_tmp124_ = n;
					_tmp125_ = minefield_view_render_number_pattern (self, _tmp124_);
					_cairo_pattern_destroy0 (_tmp122_[_tmp123_ - 1]);
					_tmp122_[_tmp123_ - 1] = _tmp125_;
					_tmp126_ = _tmp122_[_tmp123_ - 1];
				}
				_tmp127_ = cr;
				_tmp128_ = self->priv->number_patterns;
				_tmp128__length1 = self->priv->number_patterns_length1;
				_tmp129_ = n;
				_tmp130_ = _tmp128_[_tmp129_ - 1];
				cairo_set_source (_tmp127_, _tmp130_);
				_tmp131_ = cr;
				_tmp132_ = minefield_view_get_mine_size (self);
				_tmp133_ = _tmp132_;
				_tmp134_ = minefield_view_get_mine_size (self);
				_tmp135_ = _tmp134_;
				cairo_rectangle (_tmp131_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp133_, (gdouble) _tmp135_);
				_tmp136_ = cr;
				cairo_fill (_tmp136_);
			}
		}
	} else {
		GtkStyleContext* style_context = NULL;
		GtkStyleContext* _tmp137_ = NULL;
		GtkStyleContext* _tmp138_ = NULL;
		GtkStyleContext* _tmp139_ = NULL;
		GtkStyleContext* _tmp140_ = NULL;
		GtkStateFlags _tmp141_ = 0;
		gboolean _tmp142_ = FALSE;
		GtkStyleContext* _tmp143_ = NULL;
		GtkStateFlags _tmp144_ = 0;
		GtkStyleContext* _tmp145_ = NULL;
		cairo_t* _tmp146_ = NULL;
		guint _tmp147_ = 0U;
		guint _tmp148_ = 0U;
		guint _tmp149_ = 0U;
		guint _tmp150_ = 0U;
		GtkStyleContext* _tmp151_ = NULL;
		cairo_t* _tmp152_ = NULL;
		guint _tmp153_ = 0U;
		guint _tmp154_ = 0U;
		guint _tmp155_ = 0U;
		guint _tmp156_ = 0U;
		GtkStyleContext* _tmp157_ = NULL;
		Minefield* _tmp158_ = NULL;
		Minefield* _tmp159_ = NULL;
		gboolean _tmp160_ = FALSE;
		gboolean _tmp161_ = FALSE;
		Minefield* _tmp162_ = NULL;
		Minefield* _tmp163_ = NULL;
		guint _tmp164_ = 0U;
		guint _tmp165_ = 0U;
		FlagType _tmp166_ = 0;
		_tmp137_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp138_ = _g_object_ref0 (_tmp137_);
		style_context = _tmp138_;
		_tmp139_ = style_context;
		gtk_style_context_save (_tmp139_);
		_tmp140_ = style_context;
		gtk_style_context_add_class (_tmp140_, GTK_STYLE_CLASS_BUTTON);
		_tmp142_ = is_down;
		if (_tmp142_) {
			_tmp141_ = GTK_STATE_FLAG_ACTIVE;
		} else {
			_tmp141_ = GTK_STATE_FLAG_NORMAL;
		}
		_tmp143_ = style_context;
		_tmp144_ = _tmp141_;
		gtk_style_context_set_state (_tmp143_, _tmp144_);
		_tmp145_ = style_context;
		_tmp146_ = cr;
		_tmp147_ = minefield_view_get_mine_size (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = minefield_view_get_mine_size (self);
		_tmp150_ = _tmp149_;
		gtk_render_frame (_tmp145_, _tmp146_, (gdouble) 0, (gdouble) 0, (gdouble) ((gint) _tmp148_), (gdouble) ((gint) _tmp150_));
		_tmp151_ = style_context;
		_tmp152_ = cr;
		_tmp153_ = minefield_view_get_mine_size (self);
		_tmp154_ = _tmp153_;
		_tmp155_ = minefield_view_get_mine_size (self);
		_tmp156_ = _tmp155_;
		gtk_render_background (_tmp151_, _tmp152_, (gdouble) 0, (gdouble) 0, (gdouble) ((gint) _tmp154_), (gdouble) ((gint) _tmp156_));
		_tmp157_ = style_context;
		gtk_style_context_restore (_tmp157_);
		_tmp158_ = minefield_view_get_minefield (self);
		_tmp159_ = _tmp158_;
		_tmp160_ = minefield_get_paused (_tmp159_);
		_tmp161_ = _tmp160_;
		if (_tmp161_) {
			_g_object_unref0 (style_context);
			return;
		}
		_tmp162_ = minefield_view_get_minefield (self);
		_tmp163_ = _tmp162_;
		_tmp164_ = x;
		_tmp165_ = y;
		_tmp166_ = minefield_get_flag (_tmp163_, _tmp164_, _tmp165_);
		if (_tmp166_ == FLAG_TYPE_FLAG) {
			cairo_pattern_t* _tmp167_ = NULL;
			cairo_t* _tmp172_ = NULL;
			cairo_pattern_t* _tmp173_ = NULL;
			cairo_t* _tmp174_ = NULL;
			guint _tmp175_ = 0U;
			guint _tmp176_ = 0U;
			guint _tmp177_ = 0U;
			guint _tmp178_ = 0U;
			cairo_t* _tmp179_ = NULL;
			gboolean _tmp180_ = FALSE;
			Minefield* _tmp181_ = NULL;
			Minefield* _tmp182_ = NULL;
			gboolean _tmp183_ = FALSE;
			gboolean _tmp189_ = FALSE;
			_tmp167_ = self->priv->flag_pattern;
			if (_tmp167_ == NULL) {
				cairo_t* _tmp168_ = NULL;
				gchar* _tmp169_ = NULL;
				gchar* _tmp170_ = NULL;
				cairo_pattern_t* _tmp171_ = NULL;
				_tmp168_ = cr;
				_tmp169_ = g_build_filename (DATA_DIRECTORY, "flag.svg", NULL);
				_tmp170_ = _tmp169_;
				_tmp171_ = minefield_view_render_svg_pattern (self, _tmp168_, _tmp170_);
				_cairo_pattern_destroy0 (self->priv->flag_pattern);
				self->priv->flag_pattern = _tmp171_;
				_g_free0 (_tmp170_);
			}
			_tmp172_ = cr;
			_tmp173_ = self->priv->flag_pattern;
			cairo_set_source (_tmp172_, _tmp173_);
			_tmp174_ = cr;
			_tmp175_ = minefield_view_get_mine_size (self);
			_tmp176_ = _tmp175_;
			_tmp177_ = minefield_view_get_mine_size (self);
			_tmp178_ = _tmp177_;
			cairo_rectangle (_tmp174_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp176_, (gdouble) _tmp178_);
			_tmp179_ = cr;
			cairo_fill (_tmp179_);
			_tmp181_ = minefield_view_get_minefield (self);
			_tmp182_ = _tmp181_;
			_tmp183_ = _tmp182_->exploded;
			if (_tmp183_) {
				Minefield* _tmp184_ = NULL;
				Minefield* _tmp185_ = NULL;
				guint _tmp186_ = 0U;
				guint _tmp187_ = 0U;
				gboolean _tmp188_ = FALSE;
				_tmp184_ = minefield_view_get_minefield (self);
				_tmp185_ = _tmp184_;
				_tmp186_ = x;
				_tmp187_ = y;
				_tmp188_ = minefield_has_mine (_tmp185_, _tmp186_, _tmp187_);
				_tmp180_ = !_tmp188_;
			} else {
				_tmp180_ = FALSE;
			}
			_tmp189_ = _tmp180_;
			if (_tmp189_) {
				gdouble x1 = 0.0;
				guint _tmp190_ = 0U;
				guint _tmp191_ = 0U;
				gdouble y1 = 0.0;
				guint _tmp192_ = 0U;
				guint _tmp193_ = 0U;
				gdouble x2 = 0.0;
				guint _tmp194_ = 0U;
				guint _tmp195_ = 0U;
				gdouble y2 = 0.0;
				guint _tmp196_ = 0U;
				guint _tmp197_ = 0U;
				cairo_t* _tmp198_ = NULL;
				gdouble _tmp199_ = 0.0;
				gdouble _tmp200_ = 0.0;
				cairo_t* _tmp201_ = NULL;
				gdouble _tmp202_ = 0.0;
				gdouble _tmp203_ = 0.0;
				cairo_t* _tmp204_ = NULL;
				gdouble _tmp205_ = 0.0;
				gdouble _tmp206_ = 0.0;
				cairo_t* _tmp207_ = NULL;
				gdouble _tmp208_ = 0.0;
				gdouble _tmp209_ = 0.0;
				cairo_t* _tmp210_ = NULL;
				cairo_t* _tmp211_ = NULL;
				cairo_t* _tmp212_ = NULL;
				guint _tmp213_ = 0U;
				guint _tmp214_ = 0U;
				gdouble _tmp215_ = 0.0;
				cairo_t* _tmp216_ = NULL;
				cairo_t* _tmp217_ = NULL;
				cairo_t* _tmp218_ = NULL;
				cairo_t* _tmp219_ = NULL;
				_tmp190_ = minefield_view_get_mine_size (self);
				_tmp191_ = _tmp190_;
				x1 = 0.1 * _tmp191_;
				_tmp192_ = minefield_view_get_mine_size (self);
				_tmp193_ = _tmp192_;
				y1 = 0.1 * _tmp193_;
				_tmp194_ = minefield_view_get_mine_size (self);
				_tmp195_ = _tmp194_;
				x2 = 0.9 * _tmp195_;
				_tmp196_ = minefield_view_get_mine_size (self);
				_tmp197_ = _tmp196_;
				y2 = 0.9 * _tmp197_;
				_tmp198_ = cr;
				_tmp199_ = x1;
				_tmp200_ = y1;
				cairo_move_to (_tmp198_, _tmp199_, _tmp200_);
				_tmp201_ = cr;
				_tmp202_ = x2;
				_tmp203_ = y2;
				cairo_line_to (_tmp201_, _tmp202_, _tmp203_);
				_tmp204_ = cr;
				_tmp205_ = x1;
				_tmp206_ = y2;
				cairo_move_to (_tmp204_, _tmp205_, _tmp206_);
				_tmp207_ = cr;
				_tmp208_ = x2;
				_tmp209_ = y1;
				cairo_line_to (_tmp207_, _tmp208_, _tmp209_);
				_tmp210_ = cr;
				cairo_save (_tmp210_);
				_tmp211_ = cr;
				cairo_set_source_rgba (_tmp211_, 0.0, 0.0, 0.0, 1.0);
				_tmp212_ = cr;
				_tmp213_ = minefield_view_get_mine_size (self);
				_tmp214_ = _tmp213_;
				_tmp215_ = MAX ((gdouble) 1, 0.1 * _tmp214_);
				cairo_set_line_width (_tmp212_, _tmp215_);
				_tmp216_ = cr;
				cairo_set_line_join (_tmp216_, CAIRO_LINE_JOIN_ROUND);
				_tmp217_ = cr;
				cairo_set_line_cap (_tmp217_, CAIRO_LINE_CAP_ROUND);
				_tmp218_ = cr;
				cairo_stroke (_tmp218_);
				_tmp219_ = cr;
				cairo_restore (_tmp219_);
			}
		} else {
			gboolean _tmp220_ = FALSE;
			Minefield* _tmp221_ = NULL;
			Minefield* _tmp222_ = NULL;
			gboolean _tmp223_ = FALSE;
			gboolean _tmp229_ = FALSE;
			_tmp221_ = minefield_view_get_minefield (self);
			_tmp222_ = _tmp221_;
			_tmp223_ = _tmp222_->exploded;
			if (_tmp223_) {
				Minefield* _tmp224_ = NULL;
				Minefield* _tmp225_ = NULL;
				guint _tmp226_ = 0U;
				guint _tmp227_ = 0U;
				gboolean _tmp228_ = FALSE;
				_tmp224_ = minefield_view_get_minefield (self);
				_tmp225_ = _tmp224_;
				_tmp226_ = x;
				_tmp227_ = y;
				_tmp228_ = minefield_has_mine (_tmp225_, _tmp226_, _tmp227_);
				_tmp220_ = _tmp228_;
			} else {
				_tmp220_ = FALSE;
			}
			_tmp229_ = _tmp220_;
			if (_tmp229_) {
				cairo_pattern_t* _tmp230_ = NULL;
				cairo_t* _tmp235_ = NULL;
				cairo_pattern_t* _tmp236_ = NULL;
				cairo_t* _tmp237_ = NULL;
				guint _tmp238_ = 0U;
				guint _tmp239_ = 0U;
				guint _tmp240_ = 0U;
				guint _tmp241_ = 0U;
				cairo_t* _tmp242_ = NULL;
				_tmp230_ = self->priv->mine_pattern;
				if (_tmp230_ == NULL) {
					cairo_t* _tmp231_ = NULL;
					gchar* _tmp232_ = NULL;
					gchar* _tmp233_ = NULL;
					cairo_pattern_t* _tmp234_ = NULL;
					_tmp231_ = cr;
					_tmp232_ = g_build_filename (DATA_DIRECTORY, "mine.svg", NULL);
					_tmp233_ = _tmp232_;
					_tmp234_ = minefield_view_render_svg_pattern (self, _tmp231_, _tmp233_);
					_cairo_pattern_destroy0 (self->priv->mine_pattern);
					self->priv->mine_pattern = _tmp234_;
					_g_free0 (_tmp233_);
				}
				_tmp235_ = cr;
				_tmp236_ = self->priv->mine_pattern;
				cairo_set_source (_tmp235_, _tmp236_);
				_tmp237_ = cr;
				_tmp238_ = minefield_view_get_mine_size (self);
				_tmp239_ = _tmp238_;
				_tmp240_ = minefield_view_get_mine_size (self);
				_tmp241_ = _tmp240_;
				cairo_rectangle (_tmp237_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp239_, (gdouble) _tmp241_);
				_tmp242_ = cr;
				cairo_fill (_tmp242_);
			} else {
				Minefield* _tmp243_ = NULL;
				Minefield* _tmp244_ = NULL;
				guint _tmp245_ = 0U;
				guint _tmp246_ = 0U;
				FlagType _tmp247_ = 0;
				_tmp243_ = minefield_view_get_minefield (self);
				_tmp244_ = _tmp243_;
				_tmp245_ = x;
				_tmp246_ = y;
				_tmp247_ = minefield_get_flag (_tmp244_, _tmp245_, _tmp246_);
				if (_tmp247_ == FLAG_TYPE_MAYBE) {
					cairo_pattern_t* _tmp248_ = NULL;
					cairo_t* _tmp253_ = NULL;
					cairo_pattern_t* _tmp254_ = NULL;
					cairo_t* _tmp255_ = NULL;
					guint _tmp256_ = 0U;
					guint _tmp257_ = 0U;
					guint _tmp258_ = 0U;
					guint _tmp259_ = 0U;
					cairo_t* _tmp260_ = NULL;
					_tmp248_ = self->priv->question_pattern;
					if (_tmp248_ == NULL) {
						cairo_t* _tmp249_ = NULL;
						gchar* _tmp250_ = NULL;
						gchar* _tmp251_ = NULL;
						cairo_pattern_t* _tmp252_ = NULL;
						_tmp249_ = cr;
						_tmp250_ = g_build_filename (DATA_DIRECTORY, "flag-question.svg", NULL);
						_tmp251_ = _tmp250_;
						_tmp252_ = minefield_view_render_svg_pattern (self, _tmp249_, _tmp251_);
						_cairo_pattern_destroy0 (self->priv->question_pattern);
						self->priv->question_pattern = _tmp252_;
						_g_free0 (_tmp251_);
					}
					_tmp253_ = cr;
					_tmp254_ = self->priv->question_pattern;
					cairo_set_source (_tmp253_, _tmp254_);
					_tmp255_ = cr;
					_tmp256_ = minefield_view_get_mine_size (self);
					_tmp257_ = _tmp256_;
					_tmp258_ = minefield_view_get_mine_size (self);
					_tmp259_ = _tmp258_;
					cairo_rectangle (_tmp255_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp257_, (gdouble) _tmp259_);
					_tmp260_ = cr;
					cairo_fill (_tmp260_);
				}
			}
		}
		_g_object_unref0 (style_context);
	}
}


static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr) {
	MinefieldView * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gdouble dimensions[2] = {0};
	Minefield* _tmp13_ = NULL;
	Minefield* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	Minefield* _tmp18_ = NULL;
	Minefield* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	guint _tmp22_ = 0U;
	gdouble _tmp23_[2] = {0};
	gdouble centre[2] = {0};
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
	gdouble _tmp26_ = 0.0;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_[2] = {0};
	gdouble radius = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	cairo_pattern_t* pattern = NULL;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	cairo_pattern_t* _tmp39_ = NULL;
	cairo_pattern_t* _tmp40_ = NULL;
	cairo_pattern_t* _tmp41_ = NULL;
	cairo_t* _tmp42_ = NULL;
	guint _tmp43_ = 0U;
	guint _tmp44_ = 0U;
	guint _tmp45_ = 0U;
	guint _tmp46_ = 0U;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp50_ = NULL;
	cairo_pattern_t* _tmp51_ = NULL;
	cairo_t* _tmp52_ = NULL;
	cairo_t* _tmp53_ = NULL;
	cairo_t* _tmp54_ = NULL;
	cairo_t* _tmp55_ = NULL;
	cairo_t* _tmp56_ = NULL;
	cairo_t* _tmp57_ = NULL;
	cairo_t* _tmp58_ = NULL;
	cairo_t* _tmp59_ = NULL;
	gdouble* dots = NULL;
	gdouble* _tmp60_ = NULL;
	gint dots_length1 = 0;
	gint _dots_size_ = 0;
	cairo_t* _tmp61_ = NULL;
	gdouble* _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	cairo_t* _tmp113_ = NULL;
	Position* _tmp144_ = NULL;
	gboolean _tmp145_ = FALSE;
	gboolean _tmp146_ = FALSE;
	Minefield* _tmp190_ = NULL;
	Minefield* _tmp191_ = NULL;
	gboolean _tmp192_ = FALSE;
	gboolean _tmp193_ = FALSE;
	self = (MinefieldView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->render_size;
	_tmp1_ = minefield_view_get_mine_size (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		_tmp3_ = minefield_view_get_mine_size (self);
		_tmp4_ = _tmp3_;
		self->priv->render_size = _tmp4_;
		_cairo_pattern_destroy0 (self->priv->flag_pattern);
		self->priv->flag_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->mine_pattern);
		self->priv->mine_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->question_pattern);
		self->priv->question_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->bang_pattern);
		self->priv->bang_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->warning_pattern);
		self->priv->warning_pattern = NULL;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_ = FALSE;
					gint _tmp8_ = 0;
					cairo_pattern_t** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					cairo_pattern_t** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp11_ = 0;
					cairo_pattern_t* _tmp12_ = NULL;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = self->priv->number_patterns;
					_tmp9__length1 = self->priv->number_patterns_length1;
					if (!(_tmp8_ < _tmp9__length1)) {
						break;
					}
					_tmp10_ = self->priv->number_patterns;
					_tmp10__length1 = self->priv->number_patterns_length1;
					_tmp11_ = i;
					_cairo_pattern_destroy0 (_tmp10_[_tmp11_]);
					_tmp10_[_tmp11_] = NULL;
					_tmp12_ = _tmp10_[_tmp11_];
				}
			}
		}
	}
	_tmp13_ = minefield_view_get_minefield (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->width;
	_tmp16_ = minefield_view_get_mine_size (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = minefield_view_get_minefield (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->height;
	_tmp21_ = minefield_view_get_mine_size (self);
	_tmp22_ = _tmp21_;
	_tmp23_[0] = (gdouble) (_tmp15_ * _tmp17_);
	_tmp23_[1] = (gdouble) (_tmp20_ * _tmp22_);
	memcpy (dimensions, _tmp23_, 2 * sizeof (gdouble));
	_tmp24_ = minefield_view_get_x_offset (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = dimensions[0];
	_tmp27_ = minefield_view_get_y_offset (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = dimensions[1];
	_tmp30_[0] = _tmp25_ + (0.5 * _tmp26_);
	_tmp30_[1] = _tmp28_ + (0.5 * _tmp29_);
	memcpy (centre, _tmp30_, 2 * sizeof (gdouble));
	_tmp31_ = dimensions[0];
	_tmp32_ = dimensions[1];
	_tmp33_ = fmax (_tmp31_, _tmp32_);
	radius = _tmp33_;
	_tmp34_ = centre[0];
	_tmp35_ = centre[1];
	_tmp36_ = centre[0];
	_tmp37_ = centre[1];
	_tmp38_ = radius;
	_tmp39_ = cairo_pattern_create_radial (_tmp34_, _tmp35_, 0.0, _tmp36_, _tmp37_, _tmp38_);
	pattern = _tmp39_;
	_tmp40_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp40_, 0.0, 0.0, 0.0, 0.0, 0.1);
	_tmp41_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp41_, 1.0, 0.0, 0.0, 0.0, 0.4);
	_tmp42_ = cr;
	_tmp43_ = minefield_view_get_x_offset (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = minefield_view_get_y_offset (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = dimensions[0];
	_tmp48_ = dimensions[1];
	cairo_rectangle (_tmp42_, _tmp44_ - 0.5, _tmp46_ - 0.5, _tmp47_ + 0.5, _tmp48_ + 0.5);
	_tmp49_ = cr;
	cairo_save (_tmp49_);
	_tmp50_ = cr;
	_tmp51_ = pattern;
	cairo_set_source (_tmp50_, _tmp51_);
	_tmp52_ = cr;
	cairo_fill_preserve (_tmp52_);
	_tmp53_ = cr;
	cairo_set_line_width (_tmp53_, 0.5);
	_tmp54_ = cr;
	cairo_set_source_rgba (_tmp54_, 0.0, 0.0, 0.0, 1.0);
	_tmp55_ = cr;
	cairo_stroke (_tmp55_);
	_tmp56_ = cr;
	cairo_restore (_tmp56_);
	_tmp57_ = cr;
	cairo_save (_tmp57_);
	_tmp58_ = cr;
	cairo_set_line_width (_tmp58_, 0.5);
	_tmp59_ = cr;
	cairo_set_source_rgba (_tmp59_, 0.0, 0.0, 0.0, 1.0);
	_tmp60_ = g_new0 (gdouble, 2);
	_tmp60_[0] = (gdouble) 2;
	_tmp60_[1] = (gdouble) 2;
	dots = _tmp60_;
	dots_length1 = 2;
	_dots_size_ = dots_length1;
	_tmp61_ = cr;
	_tmp62_ = dots;
	_tmp62__length1 = dots_length1;
	cairo_set_dash (_tmp61_, _tmp62_, _tmp62__length1, (gdouble) 0);
	{
		gint x = 0;
		x = 1;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				gboolean _tmp64_ = FALSE;
				gint _tmp66_ = 0;
				Minefield* _tmp67_ = NULL;
				Minefield* _tmp68_ = NULL;
				guint _tmp69_ = 0U;
				cairo_t* _tmp70_ = NULL;
				guint _tmp71_ = 0U;
				guint _tmp72_ = 0U;
				gint _tmp73_ = 0;
				guint _tmp74_ = 0U;
				guint _tmp75_ = 0U;
				guint _tmp76_ = 0U;
				guint _tmp77_ = 0U;
				cairo_t* _tmp78_ = NULL;
				guint _tmp79_ = 0U;
				guint _tmp80_ = 0U;
				gint _tmp81_ = 0;
				guint _tmp82_ = 0U;
				guint _tmp83_ = 0U;
				guint _tmp84_ = 0U;
				guint _tmp85_ = 0U;
				gdouble _tmp86_ = 0.0;
				cairo_t* _tmp87_ = NULL;
				_tmp64_ = _tmp63_;
				if (!_tmp64_) {
					gint _tmp65_ = 0;
					_tmp65_ = x;
					x = _tmp65_ + 1;
				}
				_tmp63_ = FALSE;
				_tmp66_ = x;
				_tmp67_ = minefield_view_get_minefield (self);
				_tmp68_ = _tmp67_;
				_tmp69_ = _tmp68_->width;
				if (!(((guint) _tmp66_) < _tmp69_)) {
					break;
				}
				_tmp70_ = cr;
				_tmp71_ = minefield_view_get_x_offset (self);
				_tmp72_ = _tmp71_;
				_tmp73_ = x;
				_tmp74_ = minefield_view_get_mine_size (self);
				_tmp75_ = _tmp74_;
				_tmp76_ = minefield_view_get_y_offset (self);
				_tmp77_ = _tmp76_;
				cairo_move_to (_tmp70_, (gdouble) (_tmp72_ + (_tmp73_ * _tmp75_)), (gdouble) _tmp77_);
				_tmp78_ = cr;
				_tmp79_ = minefield_view_get_x_offset (self);
				_tmp80_ = _tmp79_;
				_tmp81_ = x;
				_tmp82_ = minefield_view_get_mine_size (self);
				_tmp83_ = _tmp82_;
				_tmp84_ = minefield_view_get_y_offset (self);
				_tmp85_ = _tmp84_;
				_tmp86_ = dimensions[1];
				cairo_line_to (_tmp78_, (gdouble) (_tmp80_ + (_tmp81_ * _tmp83_)), _tmp85_ + _tmp86_);
				_tmp87_ = cr;
				cairo_stroke (_tmp87_);
			}
		}
	}
	{
		gint y = 0;
		y = 1;
		{
			gboolean _tmp88_ = FALSE;
			_tmp88_ = TRUE;
			while (TRUE) {
				gboolean _tmp89_ = FALSE;
				gint _tmp91_ = 0;
				Minefield* _tmp92_ = NULL;
				Minefield* _tmp93_ = NULL;
				guint _tmp94_ = 0U;
				cairo_t* _tmp95_ = NULL;
				guint _tmp96_ = 0U;
				guint _tmp97_ = 0U;
				guint _tmp98_ = 0U;
				guint _tmp99_ = 0U;
				gint _tmp100_ = 0;
				guint _tmp101_ = 0U;
				guint _tmp102_ = 0U;
				cairo_t* _tmp103_ = NULL;
				guint _tmp104_ = 0U;
				guint _tmp105_ = 0U;
				gdouble _tmp106_ = 0.0;
				guint _tmp107_ = 0U;
				guint _tmp108_ = 0U;
				gint _tmp109_ = 0;
				guint _tmp110_ = 0U;
				guint _tmp111_ = 0U;
				cairo_t* _tmp112_ = NULL;
				_tmp89_ = _tmp88_;
				if (!_tmp89_) {
					gint _tmp90_ = 0;
					_tmp90_ = y;
					y = _tmp90_ + 1;
				}
				_tmp88_ = FALSE;
				_tmp91_ = y;
				_tmp92_ = minefield_view_get_minefield (self);
				_tmp93_ = _tmp92_;
				_tmp94_ = _tmp93_->height;
				if (!(((guint) _tmp91_) < _tmp94_)) {
					break;
				}
				_tmp95_ = cr;
				_tmp96_ = minefield_view_get_x_offset (self);
				_tmp97_ = _tmp96_;
				_tmp98_ = minefield_view_get_y_offset (self);
				_tmp99_ = _tmp98_;
				_tmp100_ = y;
				_tmp101_ = minefield_view_get_mine_size (self);
				_tmp102_ = _tmp101_;
				cairo_move_to (_tmp95_, (gdouble) _tmp97_, (gdouble) (_tmp99_ + (_tmp100_ * _tmp102_)));
				_tmp103_ = cr;
				_tmp104_ = minefield_view_get_x_offset (self);
				_tmp105_ = _tmp104_;
				_tmp106_ = dimensions[0];
				_tmp107_ = minefield_view_get_y_offset (self);
				_tmp108_ = _tmp107_;
				_tmp109_ = y;
				_tmp110_ = minefield_view_get_mine_size (self);
				_tmp111_ = _tmp110_;
				cairo_line_to (_tmp103_, _tmp105_ + _tmp106_, (gdouble) (_tmp108_ + (_tmp109_ * _tmp111_)));
				_tmp112_ = cr;
				cairo_stroke (_tmp112_);
			}
		}
	}
	_tmp113_ = cr;
	cairo_restore (_tmp113_);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp114_ = FALSE;
			_tmp114_ = TRUE;
			while (TRUE) {
				gboolean _tmp115_ = FALSE;
				gint _tmp117_ = 0;
				Minefield* _tmp118_ = NULL;
				Minefield* _tmp119_ = NULL;
				guint _tmp120_ = 0U;
				_tmp115_ = _tmp114_;
				if (!_tmp115_) {
					gint _tmp116_ = 0;
					_tmp116_ = x;
					x = _tmp116_ + 1;
				}
				_tmp114_ = FALSE;
				_tmp117_ = x;
				_tmp118_ = minefield_view_get_minefield (self);
				_tmp119_ = _tmp118_;
				_tmp120_ = _tmp119_->width;
				if (!(((guint) _tmp117_) < _tmp120_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp121_ = FALSE;
						_tmp121_ = TRUE;
						while (TRUE) {
							gboolean _tmp122_ = FALSE;
							gint _tmp124_ = 0;
							Minefield* _tmp125_ = NULL;
							Minefield* _tmp126_ = NULL;
							guint _tmp127_ = 0U;
							cairo_t* _tmp128_ = NULL;
							cairo_t* _tmp129_ = NULL;
							guint _tmp130_ = 0U;
							guint _tmp131_ = 0U;
							gint _tmp132_ = 0;
							guint _tmp133_ = 0U;
							guint _tmp134_ = 0U;
							guint _tmp135_ = 0U;
							guint _tmp136_ = 0U;
							gint _tmp137_ = 0;
							guint _tmp138_ = 0U;
							guint _tmp139_ = 0U;
							cairo_t* _tmp140_ = NULL;
							gint _tmp141_ = 0;
							gint _tmp142_ = 0;
							cairo_t* _tmp143_ = NULL;
							_tmp122_ = _tmp121_;
							if (!_tmp122_) {
								gint _tmp123_ = 0;
								_tmp123_ = y;
								y = _tmp123_ + 1;
							}
							_tmp121_ = FALSE;
							_tmp124_ = y;
							_tmp125_ = minefield_view_get_minefield (self);
							_tmp126_ = _tmp125_;
							_tmp127_ = _tmp126_->height;
							if (!(((guint) _tmp124_) < _tmp127_)) {
								break;
							}
							_tmp128_ = cr;
							cairo_save (_tmp128_);
							_tmp129_ = cr;
							_tmp130_ = minefield_view_get_x_offset (self);
							_tmp131_ = _tmp130_;
							_tmp132_ = x;
							_tmp133_ = minefield_view_get_mine_size (self);
							_tmp134_ = _tmp133_;
							_tmp135_ = minefield_view_get_y_offset (self);
							_tmp136_ = _tmp135_;
							_tmp137_ = y;
							_tmp138_ = minefield_view_get_mine_size (self);
							_tmp139_ = _tmp138_;
							cairo_translate (_tmp129_, (gdouble) (_tmp131_ + (_tmp132_ * _tmp134_)), (gdouble) (_tmp136_ + (_tmp137_ * _tmp139_)));
							_tmp140_ = cr;
							_tmp141_ = x;
							_tmp142_ = y;
							minefield_view_draw_square (self, _tmp140_, (guint) _tmp141_, (guint) _tmp142_);
							_tmp143_ = cr;
							cairo_restore (_tmp143_);
						}
					}
				}
			}
		}
	}
	_tmp144_ = self->priv->keyboard_cursor;
	_tmp145_ = position_get_is_set (_tmp144_);
	_tmp146_ = _tmp145_;
	if (_tmp146_) {
		gdouble key_centre[2] = {0};
		guint _tmp147_ = 0U;
		guint _tmp148_ = 0U;
		Position* _tmp149_ = NULL;
		gint _tmp150_ = 0;
		gint _tmp151_ = 0;
		guint _tmp152_ = 0U;
		guint _tmp153_ = 0U;
		guint _tmp154_ = 0U;
		guint _tmp155_ = 0U;
		Position* _tmp156_ = NULL;
		gint _tmp157_ = 0;
		gint _tmp158_ = 0;
		guint _tmp159_ = 0U;
		guint _tmp160_ = 0U;
		gdouble _tmp161_[2] = {0};
		cairo_pattern_t* key_cursor = NULL;
		gdouble _tmp162_ = 0.0;
		gdouble _tmp163_ = 0.0;
		gdouble _tmp164_ = 0.0;
		gdouble _tmp165_ = 0.0;
		guint _tmp166_ = 0U;
		guint _tmp167_ = 0U;
		cairo_pattern_t* _tmp168_ = NULL;
		cairo_pattern_t* _tmp169_ = NULL;
		cairo_pattern_t* _tmp170_ = NULL;
		cairo_pattern_t* _tmp171_ = NULL;
		cairo_pattern_t* _tmp172_ = NULL;
		cairo_pattern_t* _tmp173_ = NULL;
		cairo_t* _tmp174_ = NULL;
		cairo_t* _tmp175_ = NULL;
		gdouble _tmp176_ = 0.0;
		guint _tmp177_ = 0U;
		guint _tmp178_ = 0U;
		gdouble _tmp179_ = 0.0;
		guint _tmp180_ = 0U;
		guint _tmp181_ = 0U;
		guint _tmp182_ = 0U;
		guint _tmp183_ = 0U;
		guint _tmp184_ = 0U;
		guint _tmp185_ = 0U;
		cairo_t* _tmp186_ = NULL;
		cairo_pattern_t* _tmp187_ = NULL;
		cairo_t* _tmp188_ = NULL;
		cairo_t* _tmp189_ = NULL;
		_tmp147_ = minefield_view_get_x_offset (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = self->priv->keyboard_cursor;
		_tmp150_ = position_get_x (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = minefield_view_get_mine_size (self);
		_tmp153_ = _tmp152_;
		_tmp154_ = minefield_view_get_y_offset (self);
		_tmp155_ = _tmp154_;
		_tmp156_ = self->priv->keyboard_cursor;
		_tmp157_ = position_get_y (_tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = minefield_view_get_mine_size (self);
		_tmp160_ = _tmp159_;
		_tmp161_[0] = _tmp148_ + ((_tmp151_ + 0.5) * _tmp153_);
		_tmp161_[1] = _tmp155_ + ((_tmp158_ + 0.5) * _tmp160_);
		memcpy (key_centre, _tmp161_, 2 * sizeof (gdouble));
		_tmp162_ = key_centre[0];
		_tmp163_ = key_centre[1];
		_tmp164_ = key_centre[0];
		_tmp165_ = key_centre[1];
		_tmp166_ = minefield_view_get_mine_size (self);
		_tmp167_ = _tmp166_;
		_tmp168_ = cairo_pattern_create_radial (_tmp162_, _tmp163_, 0.0, _tmp164_, _tmp165_, 0.25 * _tmp167_);
		key_cursor = _tmp168_;
		_tmp169_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp169_, 0.0, 1.0, 1.0, 1.0, 1.0);
		_tmp170_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp170_, 0.8, 1.0, 1.0, 1.0, 0.1);
		_tmp171_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp171_, 0.9, 0.0, 0.0, 0.0, 0.5);
		_tmp172_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp172_, 1.0, 0.0, 0.0, 0.0, 0.2);
		_tmp173_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp173_, 1.0, 0.0, 0.0, 0.0, 0.0);
		_tmp174_ = cr;
		cairo_save (_tmp174_);
		_tmp175_ = cr;
		_tmp176_ = key_centre[0];
		_tmp177_ = minefield_view_get_mine_size (self);
		_tmp178_ = _tmp177_;
		_tmp179_ = key_centre[1];
		_tmp180_ = minefield_view_get_mine_size (self);
		_tmp181_ = _tmp180_;
		_tmp182_ = minefield_view_get_mine_size (self);
		_tmp183_ = _tmp182_;
		_tmp184_ = minefield_view_get_mine_size (self);
		_tmp185_ = _tmp184_;
		cairo_rectangle (_tmp175_, _tmp176_ - (0.45 * _tmp178_), _tmp179_ - (0.45 * _tmp181_), 0.9 * _tmp183_, 0.9 * _tmp185_);
		_tmp186_ = cr;
		_tmp187_ = key_cursor;
		cairo_set_source (_tmp186_, _tmp187_);
		_tmp188_ = cr;
		cairo_fill (_tmp188_);
		_tmp189_ = cr;
		cairo_restore (_tmp189_);
		_cairo_pattern_destroy0 (key_cursor);
	}
	_tmp190_ = minefield_view_get_minefield (self);
	_tmp191_ = _tmp190_;
	_tmp192_ = minefield_get_paused (_tmp191_);
	_tmp193_ = _tmp192_;
	if (_tmp193_) {
		cairo_t* _tmp194_ = NULL;
		cairo_t* _tmp195_ = NULL;
		cairo_t* _tmp196_ = NULL;
		cairo_t* _tmp197_ = NULL;
		gint _tmp198_ = 0;
		gchar* text = NULL;
		const gchar* _tmp199_ = NULL;
		gchar* _tmp200_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp201_ = NULL;
		const gchar* _tmp202_ = NULL;
		cairo_text_extents_t _tmp203_ = {0};
		cairo_t* _tmp204_ = NULL;
		gint _tmp205_ = 0;
		cairo_text_extents_t _tmp206_ = {0};
		gdouble _tmp207_ = 0.0;
		gint _tmp208_ = 0;
		cairo_text_extents_t _tmp209_ = {0};
		gdouble _tmp210_ = 0.0;
		cairo_t* _tmp211_ = NULL;
		cairo_t* _tmp212_ = NULL;
		const gchar* _tmp213_ = NULL;
		_tmp194_ = cr;
		cairo_set_source_rgba (_tmp194_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp195_ = cr;
		cairo_paint (_tmp195_);
		_tmp196_ = cr;
		cairo_select_font_face (_tmp196_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp197_ = cr;
		_tmp198_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp197_, _tmp198_ * 0.125);
		_tmp199_ = _ ("Paused");
		_tmp200_ = g_strdup (_tmp199_);
		text = _tmp200_;
		_tmp201_ = cr;
		_tmp202_ = text;
		cairo_text_extents (_tmp201_, _tmp202_, &_tmp203_);
		extents = _tmp203_;
		_tmp204_ = cr;
		_tmp205_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp206_ = extents;
		_tmp207_ = _tmp206_.width;
		_tmp208_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp209_ = extents;
		_tmp210_ = _tmp209_.height;
		cairo_move_to (_tmp204_, (_tmp205_ - _tmp207_) / 2.0, (_tmp208_ + _tmp210_) / 2.0);
		_tmp211_ = cr;
		cairo_set_source_rgb (_tmp211_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp212_ = cr;
		_tmp213_ = text;
		cairo_show_text (_tmp212_, _tmp213_);
		_g_free0 (text);
	}
	result = FALSE;
	dots = (g_free (dots), NULL);
	_cairo_pattern_destroy0 (pattern);
	return result;
}


static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	Minefield* _tmp5_ = NULL;
	Minefield* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	FlagType _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = minefield_is_cleared (_tmp1_, _tmp2_, _tmp3_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = x;
	_tmp8_ = y;
	_tmp9_ = minefield_get_flag (_tmp6_, _tmp7_, _tmp8_);
	switch (_tmp9_) {
		case FLAG_TYPE_NONE:
		{
			gboolean _tmp10_ = FALSE;
			Minefield* _tmp11_ = NULL;
			Minefield* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			guint _tmp14_ = 0U;
			Minefield* _tmp15_ = NULL;
			Minefield* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			gboolean _tmp19_ = FALSE;
			_tmp11_ = minefield_view_get_minefield (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = minefield_get_n_flags (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = minefield_view_get_minefield (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->n_mines;
			if (_tmp14_ >= _tmp17_) {
				gboolean _tmp18_ = FALSE;
				_tmp18_ = self->priv->use_question_marks;
				_tmp10_ = _tmp18_;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp19_ = _tmp10_;
			if (_tmp19_) {
				Minefield* _tmp20_ = NULL;
				Minefield* _tmp21_ = NULL;
				guint _tmp22_ = 0U;
				guint _tmp23_ = 0U;
				_tmp20_ = minefield_view_get_minefield (self);
				_tmp21_ = _tmp20_;
				_tmp22_ = x;
				_tmp23_ = y;
				minefield_set_flag (_tmp21_, _tmp22_, _tmp23_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp24_ = NULL;
				Minefield* _tmp25_ = NULL;
				guint _tmp26_ = 0U;
				guint _tmp27_ = 0U;
				_tmp24_ = minefield_view_get_minefield (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = x;
				_tmp27_ = y;
				minefield_set_flag (_tmp25_, _tmp26_, _tmp27_, FLAG_TYPE_FLAG);
			}
			break;
		}
		case FLAG_TYPE_MAYBE:
		{
			Minefield* _tmp28_ = NULL;
			Minefield* _tmp29_ = NULL;
			guint _tmp30_ = 0U;
			guint _tmp31_ = 0U;
			_tmp28_ = minefield_view_get_minefield (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = x;
			_tmp31_ = y;
			minefield_set_flag (_tmp29_, _tmp30_, _tmp31_, FLAG_TYPE_NONE);
			break;
		}
		case FLAG_TYPE_FLAG:
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = self->priv->use_question_marks;
			if (_tmp32_) {
				Minefield* _tmp33_ = NULL;
				Minefield* _tmp34_ = NULL;
				guint _tmp35_ = 0U;
				guint _tmp36_ = 0U;
				_tmp33_ = minefield_view_get_minefield (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = x;
				_tmp36_ = y;
				minefield_set_flag (_tmp34_, _tmp35_, _tmp36_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp37_ = NULL;
				Minefield* _tmp38_ = NULL;
				guint _tmp39_ = 0U;
				guint _tmp40_ = 0U;
				_tmp37_ = minefield_view_get_minefield (self);
				_tmp38_ = _tmp37_;
				_tmp39_ = x;
				_tmp40_ = y;
				minefield_set_flag (_tmp38_, _tmp39_, _tmp40_, FLAG_TYPE_NONE);
			}
			break;
		}
		default:
		break;
	}
}


static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp0_ = 0U;
				Neighbour _tmp1_ = {0};
				gint _tmp2_ = 0;
				gint ny = 0;
				guint _tmp3_ = 0U;
				Neighbour _tmp4_ = {0};
				gint _tmp5_ = 0;
				Minefield* _tmp6_ = NULL;
				Minefield* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = ((gint) _tmp0_) + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = ((gint) _tmp3_) + _tmp5_;
				_tmp6_ = minefield_view_get_minefield (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = nx;
				_tmp9_ = ny;
				_tmp10_ = minefield_is_location (_tmp7_, _tmp8_, _tmp9_);
				if (_tmp10_) {
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp11_ = nx;
					_tmp12_ = ny;
					minefield_view_redraw_sector_cb (self, (guint) _tmp11_, (guint) _tmp12_);
				}
			}
		}
	}
}


static gpointer _minefield_ref0 (gpointer self) {
	return self ? minefield_ref (self) : NULL;
}


static void minefield_view_multi_release (MinefieldView* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_ = FALSE;
	guint n_mines = 0U;
	Minefield* _tmp12_ = NULL;
	Minefield* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	guint n_flags = 0U;
	guint n_unknown = 0U;
	gboolean do_clear = FALSE;
	guint _tmp40_ = 0U;
	guint _tmp41_ = 0U;
	Minefield* m = NULL;
	Minefield* _tmp47_ = NULL;
	Minefield* _tmp48_ = NULL;
	Minefield* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = y;
	_tmp5_ = minefield_is_cleared (_tmp2_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp6_ = NULL;
		Minefield* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		FlagType _tmp10_ = 0;
		_tmp6_ = minefield_view_get_minefield (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = minefield_get_flag (_tmp7_, _tmp8_, _tmp9_);
		_tmp0_ = _tmp10_ == FLAG_TYPE_FLAG;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = minefield_view_get_minefield (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = x;
	_tmp15_ = y;
	_tmp16_ = minefield_get_n_adjacent_mines (_tmp13_, _tmp14_, _tmp15_);
	n_mines = _tmp16_;
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp17_ = 0U;
				Neighbour _tmp18_ = {0};
				gint _tmp19_ = 0;
				gint ny = 0;
				guint _tmp20_ = 0U;
				Neighbour _tmp21_ = {0};
				gint _tmp22_ = 0;
				Minefield* _tmp23_ = NULL;
				Minefield* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gboolean _tmp27_ = FALSE;
				Minefield* _tmp28_ = NULL;
				Minefield* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				FlagType _tmp32_ = 0;
				Minefield* _tmp34_ = NULL;
				Minefield* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gboolean _tmp38_ = FALSE;
				_tmp17_ = x;
				_tmp18_ = neighbour;
				_tmp19_ = _tmp18_.x;
				nx = ((gint) _tmp17_) + _tmp19_;
				_tmp20_ = y;
				_tmp21_ = neighbour;
				_tmp22_ = _tmp21_.y;
				ny = ((gint) _tmp20_) + _tmp22_;
				_tmp23_ = minefield_view_get_minefield (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = nx;
				_tmp26_ = ny;
				_tmp27_ = minefield_is_location (_tmp24_, _tmp25_, _tmp26_);
				if (!_tmp27_) {
					continue;
				}
				_tmp28_ = minefield_view_get_minefield (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = nx;
				_tmp31_ = ny;
				_tmp32_ = minefield_get_flag (_tmp29_, (guint) _tmp30_, (guint) _tmp31_);
				if (_tmp32_ == FLAG_TYPE_FLAG) {
					guint _tmp33_ = 0U;
					_tmp33_ = n_flags;
					n_flags = _tmp33_ + 1;
				}
				_tmp34_ = minefield_view_get_minefield (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = nx;
				_tmp37_ = ny;
				_tmp38_ = minefield_is_cleared (_tmp35_, (guint) _tmp36_, (guint) _tmp37_);
				if (!_tmp38_) {
					guint _tmp39_ = 0U;
					_tmp39_ = n_unknown;
					n_unknown = _tmp39_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	_tmp40_ = n_mines;
	_tmp41_ = n_flags;
	if (_tmp40_ == _tmp41_) {
		do_clear = TRUE;
	} else {
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp46_ = FALSE;
		_tmp43_ = self->priv->use_autoflag;
		if (_tmp43_) {
			guint _tmp44_ = 0U;
			guint _tmp45_ = 0U;
			_tmp44_ = n_unknown;
			_tmp45_ = n_mines;
			_tmp42_ = _tmp44_ == _tmp45_;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp46_ = _tmp42_;
		if (_tmp46_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	_tmp47_ = minefield_view_get_minefield (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = _minefield_ref0 (_tmp48_);
	m = _tmp49_;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp50_ = 0U;
				Neighbour _tmp51_ = {0};
				gint _tmp52_ = 0;
				gint ny = 0;
				guint _tmp53_ = 0U;
				Neighbour _tmp54_ = {0};
				gint _tmp55_ = 0;
				Minefield* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				gboolean _tmp61_ = FALSE;
				gboolean _tmp66_ = FALSE;
				_tmp50_ = x;
				_tmp51_ = neighbour;
				_tmp52_ = _tmp51_.x;
				nx = ((gint) _tmp50_) + _tmp52_;
				_tmp53_ = y;
				_tmp54_ = neighbour;
				_tmp55_ = _tmp54_.y;
				ny = ((gint) _tmp53_) + _tmp55_;
				_tmp56_ = m;
				_tmp57_ = nx;
				_tmp58_ = ny;
				_tmp59_ = minefield_is_location (_tmp56_, _tmp57_, _tmp58_);
				if (!_tmp59_) {
					continue;
				}
				_tmp61_ = do_clear;
				if (_tmp61_) {
					Minefield* _tmp62_ = NULL;
					gint _tmp63_ = 0;
					gint _tmp64_ = 0;
					FlagType _tmp65_ = 0;
					_tmp62_ = m;
					_tmp63_ = nx;
					_tmp64_ = ny;
					_tmp65_ = minefield_get_flag (_tmp62_, (guint) _tmp63_, (guint) _tmp64_);
					_tmp60_ = _tmp65_ != FLAG_TYPE_FLAG;
				} else {
					_tmp60_ = FALSE;
				}
				_tmp66_ = _tmp60_;
				if (_tmp66_) {
					Minefield* _tmp67_ = NULL;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					_tmp67_ = m;
					_tmp68_ = nx;
					_tmp69_ = ny;
					minefield_clear_mine (_tmp67_, (guint) _tmp68_, (guint) _tmp69_);
				} else {
					Minefield* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					_tmp70_ = m;
					_tmp71_ = nx;
					_tmp72_ = ny;
					minefield_set_flag (_tmp70_, (guint) _tmp71_, (guint) _tmp72_, FLAG_TYPE_FLAG);
				}
			}
		}
	}
	_minefield_unref0 (m);
}


static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	GdkEventType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Position* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp24_ = FALSE;
	Position* _tmp25_ = NULL;
	Position* _tmp26_ = NULL;
	GdkEventButton _tmp27_ = {0};
	gdouble _tmp28_ = 0.0;
	guint _tmp29_ = 0U;
	guint _tmp30_ = 0U;
	guint _tmp31_ = 0U;
	guint _tmp32_ = 0U;
	gdouble _tmp33_ = 0.0;
	Position* _tmp34_ = NULL;
	GdkEventButton _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	guint _tmp37_ = 0U;
	guint _tmp38_ = 0U;
	guint _tmp39_ = 0U;
	guint _tmp40_ = 0U;
	gdouble _tmp41_ = 0.0;
	Position* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	GdkEventButton _tmp46_ = {0};
	guint _tmp47_ = 0U;
	gboolean _tmp54_ = FALSE;
	Position* _tmp64_ = NULL;
	Position* _tmp65_ = NULL;
	Position* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	Position* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	gint _tmp71_ = 0;
	gint* _tmp72_ = NULL;
	gint* _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp12_ = NULL;
		Minefield* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = minefield_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = _tmp15_;
	}
	_tmp16_ = _tmp2_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->selected;
	_tmp19_ = position_get_is_set (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		Position* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = self->priv->keyboard_cursor;
		_tmp22_ = position_get_is_set (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp24_ = _tmp17_;
	if (_tmp24_) {
		result = FALSE;
		return result;
	}
	_tmp25_ = self->priv->selected;
	position_set_is_set (_tmp25_, FALSE);
	_tmp26_ = self->priv->selected;
	_tmp27_ = *event;
	_tmp28_ = _tmp27_.x;
	_tmp29_ = minefield_view_get_x_offset (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = minefield_view_get_mine_size (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = floor ((_tmp28_ - _tmp30_) / _tmp32_);
	position_set_x (_tmp26_, (gint) _tmp33_);
	_tmp34_ = self->priv->selected;
	_tmp35_ = *event;
	_tmp36_ = _tmp35_.y;
	_tmp37_ = minefield_view_get_y_offset (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = minefield_view_get_mine_size (self);
	_tmp40_ = _tmp39_;
	_tmp41_ = floor ((_tmp36_ - _tmp38_) / _tmp40_);
	position_set_y (_tmp34_, (gint) _tmp41_);
	_tmp42_ = self->priv->selected;
	_tmp43_ = position_get_is_valid (_tmp42_);
	_tmp44_ = _tmp43_;
	if (!_tmp44_) {
		result = FALSE;
		return result;
	}
	_tmp46_ = *event;
	_tmp47_ = _tmp46_.button;
	if (_tmp47_ == ((guint) 3)) {
		_tmp45_ = TRUE;
	} else {
		gboolean _tmp48_ = FALSE;
		GdkEventButton _tmp49_ = {0};
		guint _tmp50_ = 0U;
		gboolean _tmp53_ = FALSE;
		_tmp49_ = *event;
		_tmp50_ = _tmp49_.button;
		if (_tmp50_ == ((guint) 1)) {
			GdkEventButton _tmp51_ = {0};
			GdkModifierType _tmp52_ = 0;
			_tmp51_ = *event;
			_tmp52_ = _tmp51_.state;
			_tmp48_ = (_tmp52_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp48_ = FALSE;
		}
		_tmp53_ = _tmp48_;
		_tmp45_ = _tmp53_;
	}
	_tmp54_ = _tmp45_;
	if (_tmp54_) {
		Position* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		Position* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		_tmp55_ = self->priv->selected;
		_tmp56_ = position_get_x (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = self->priv->selected;
		_tmp59_ = position_get_y (_tmp58_);
		_tmp60_ = _tmp59_;
		minefield_view_toggle_mark (self, (guint) _tmp57_, (guint) _tmp60_);
		g_signal_emit_by_name (self, "unlook");
	} else {
		GdkEventButton _tmp61_ = {0};
		guint _tmp62_ = 0U;
		_tmp61_ = *event;
		_tmp62_ = _tmp61_.button;
		if (_tmp62_ == ((guint) 1)) {
			Position* _tmp63_ = NULL;
			_tmp63_ = self->priv->selected;
			position_set_is_set (_tmp63_, TRUE);
			g_signal_emit_by_name (self, "look");
		}
	}
	_tmp64_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp64_, FALSE);
	_tmp65_ = self->priv->keyboard_cursor;
	_tmp66_ = self->priv->selected;
	_tmp67_ = position_get_x (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = self->priv->selected;
	_tmp70_ = position_get_y (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_new0 (gint, 2);
	_tmp72_[0] = _tmp68_;
	_tmp72_[1] = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp73__length1 = 2;
	position_set_position (_tmp65_, _tmp73_, 2);
	_tmp73_ = (g_free (_tmp73_), NULL);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gint x = 0;
	GdkEventMotion _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	gdouble _tmp29_ = 0.0;
	gint y = 0;
	GdkEventMotion _tmp30_ = {0};
	gdouble _tmp31_ = 0.0;
	guint _tmp32_ = 0U;
	guint _tmp33_ = 0U;
	guint _tmp34_ = 0U;
	guint _tmp35_ = 0U;
	gdouble _tmp36_ = 0.0;
	Position* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint* _tmp40_ = NULL;
	gint* _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp10_ = NULL;
		Minefield* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = minefield_view_get_minefield (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = minefield_get_paused (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp0_ = _tmp13_;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (!_tmp18_) {
		_tmp15_ = TRUE;
	} else {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_;
	}
	_tmp22_ = _tmp15_;
	if (_tmp22_) {
		result = FALSE;
		return result;
	}
	_tmp23_ = *event;
	_tmp24_ = _tmp23_.x;
	_tmp25_ = minefield_view_get_x_offset (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = minefield_view_get_mine_size (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = floor ((_tmp24_ - _tmp26_) / _tmp28_);
	x = (gint) _tmp29_;
	_tmp30_ = *event;
	_tmp31_ = _tmp30_.y;
	_tmp32_ = minefield_view_get_y_offset (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = minefield_view_get_mine_size (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = floor ((_tmp31_ - _tmp33_) / _tmp35_);
	y = (gint) _tmp36_;
	_tmp37_ = self->priv->selected;
	_tmp38_ = x;
	_tmp39_ = y;
	_tmp40_ = g_new0 (gint, 2);
	_tmp40_[0] = _tmp38_;
	_tmp40_[1] = _tmp39_;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 2;
	position_set_position (_tmp37_, _tmp41_, 2);
	_tmp41_ = (g_free (_tmp41_), NULL);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Position* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp24_ = FALSE;
	Minefield* _tmp25_ = NULL;
	Minefield* _tmp26_ = NULL;
	Position* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Position* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gboolean _tmp33_ = FALSE;
	Minefield* _tmp34_ = NULL;
	Minefield* _tmp35_ = NULL;
	Position* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	Position* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gboolean _tmp42_ = FALSE;
	Position* _tmp72_ = NULL;
	Position* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	Position* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	gint* _tmp79_ = NULL;
	gint* _tmp80_ = NULL;
	gint _tmp80__length1 = 0;
	Position* _tmp81_ = NULL;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp12_ = NULL;
		Minefield* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = minefield_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = _tmp15_;
	}
	_tmp16_ = _tmp2_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->selected;
	_tmp19_ = position_get_is_set (_tmp18_);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		_tmp17_ = TRUE;
	} else {
		Position* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = self->priv->keyboard_cursor;
		_tmp22_ = position_get_is_set (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_;
	}
	_tmp24_ = _tmp17_;
	if (_tmp24_) {
		result = FALSE;
		return result;
	}
	_tmp25_ = minefield_view_get_minefield (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_x (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->selected;
	_tmp31_ = position_get_y (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = minefield_is_location (_tmp26_, _tmp29_, _tmp32_);
	if (!_tmp33_) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp34_ = minefield_view_get_minefield (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = self->priv->selected;
	_tmp37_ = position_get_x (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->selected;
	_tmp40_ = position_get_y (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = minefield_is_cleared (_tmp35_, (guint) _tmp38_, (guint) _tmp41_);
	if (_tmp42_) {
		Position* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		Position* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		Position* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		Position* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		_tmp43_ = self->priv->selected;
		_tmp44_ = position_get_x (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = self->priv->selected;
		_tmp47_ = position_get_y (_tmp46_);
		_tmp48_ = _tmp47_;
		minefield_view_multi_release (self, (guint) _tmp45_, (guint) _tmp48_);
		_tmp49_ = self->priv->selected;
		_tmp50_ = position_get_x (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = self->priv->selected;
		_tmp53_ = position_get_y (_tmp52_);
		_tmp54_ = _tmp53_;
		minefield_view_redraw_adjacent (self, (guint) _tmp51_, (guint) _tmp54_);
	} else {
		Minefield* _tmp55_ = NULL;
		Minefield* _tmp56_ = NULL;
		Position* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		Position* _tmp60_ = NULL;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		FlagType _tmp63_ = 0;
		_tmp55_ = minefield_view_get_minefield (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = self->priv->selected;
		_tmp58_ = position_get_x (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = self->priv->selected;
		_tmp61_ = position_get_y (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = minefield_get_flag (_tmp56_, (guint) _tmp59_, (guint) _tmp62_);
		if (_tmp63_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp64_ = NULL;
			Minefield* _tmp65_ = NULL;
			Position* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			Position* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			_tmp64_ = minefield_view_get_minefield (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = self->priv->selected;
			_tmp67_ = position_get_x (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = self->priv->selected;
			_tmp70_ = position_get_y (_tmp69_);
			_tmp71_ = _tmp70_;
			minefield_clear_mine (_tmp65_, (guint) _tmp68_, (guint) _tmp71_);
		}
	}
	_tmp72_ = self->priv->keyboard_cursor;
	_tmp73_ = self->priv->selected;
	_tmp74_ = position_get_x (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = self->priv->selected;
	_tmp77_ = position_get_y (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = g_new0 (gint, 2);
	_tmp79_[0] = _tmp75_;
	_tmp79_[1] = _tmp78_;
	_tmp80_ = _tmp79_;
	_tmp80__length1 = 2;
	position_set_position (_tmp72_, _tmp80_, 2);
	_tmp80_ = (g_free (_tmp80_), NULL);
	_tmp81_ = self->priv->selected;
	position_set_is_set (_tmp81_, FALSE);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gint x = 0;
	Position* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint y = 0;
	Position* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkEventKey _tmp29_ = {0};
	guint _tmp30_ = 0U;
	gboolean _tmp53_ = FALSE;
	gint _tmp54_ = 0;
	Position* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gboolean _tmp62_ = FALSE;
	Position* _tmp63_ = NULL;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	Position* _tmp67_ = NULL;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint* _tmp70_ = NULL;
	gint* _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	Position* _tmp72_ = NULL;
	gboolean _tmp73_ = FALSE;
	gboolean _tmp74_ = FALSE;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp10_ = NULL;
		Minefield* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = minefield_view_get_minefield (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = minefield_get_paused (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp0_ = _tmp13_;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = !_tmp21_;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp22_ = _tmp15_;
	if (_tmp22_) {
		result = FALSE;
		return result;
	}
	_tmp23_ = self->priv->keyboard_cursor;
	_tmp24_ = position_get_x (_tmp23_);
	_tmp25_ = _tmp24_;
	x = _tmp25_;
	_tmp26_ = self->priv->keyboard_cursor;
	_tmp27_ = position_get_y (_tmp26_);
	_tmp28_ = _tmp27_;
	y = _tmp28_;
	_tmp29_ = *event;
	_tmp30_ = _tmp29_.keyval;
	switch (_tmp30_) {
		case GDK_KEY_Left:
		case GDK_KEY_h:
		{
			gint _tmp31_ = 0;
			_tmp31_ = x;
			x = _tmp31_ - 1;
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_l:
		{
			gint _tmp32_ = 0;
			_tmp32_ = x;
			x = _tmp32_ + 1;
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_k:
		{
			gint _tmp33_ = 0;
			_tmp33_ = y;
			y = _tmp33_ - 1;
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_j:
		{
			gint _tmp34_ = 0;
			_tmp34_ = y;
			y = _tmp34_ + 1;
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_Return:
		{
			Position* _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
			gboolean _tmp37_ = FALSE;
			_tmp35_ = self->priv->keyboard_cursor;
			_tmp36_ = position_get_is_set (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_) {
				Position* _tmp38_ = NULL;
				GdkEventKey _tmp39_ = {0};
				GdkModifierType _tmp40_ = 0;
				_tmp38_ = self->priv->selected;
				position_set_is_set (_tmp38_, FALSE);
				_tmp39_ = *event;
				_tmp40_ = _tmp39_.state;
				if ((_tmp40_ & GDK_CONTROL_MASK) != 0) {
					Position* _tmp41_ = NULL;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					Position* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					_tmp41_ = self->priv->keyboard_cursor;
					_tmp42_ = position_get_x (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = self->priv->keyboard_cursor;
					_tmp45_ = position_get_y (_tmp44_);
					_tmp46_ = _tmp45_;
					minefield_view_toggle_mark (self, (guint) _tmp43_, (guint) _tmp46_);
				} else {
					Position* _tmp47_ = NULL;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint* _tmp50_ = NULL;
					gint* _tmp51_ = NULL;
					gint _tmp51__length1 = 0;
					Position* _tmp52_ = NULL;
					_tmp47_ = self->priv->selected;
					_tmp48_ = x;
					_tmp49_ = y;
					_tmp50_ = g_new0 (gint, 2);
					_tmp50_[0] = _tmp48_;
					_tmp50_[1] = _tmp49_;
					_tmp51_ = _tmp50_;
					_tmp51__length1 = 2;
					position_set_position (_tmp47_, _tmp51_, 2);
					_tmp51_ = (g_free (_tmp51_), NULL);
					_tmp52_ = self->priv->selected;
					position_set_is_set (_tmp52_, TRUE);
					g_signal_emit_by_name (self, "look");
				}
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	_tmp54_ = x;
	_tmp55_ = self->priv->keyboard_cursor;
	_tmp56_ = position_get_x (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp54_ == _tmp57_) {
		gint _tmp58_ = 0;
		Position* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		_tmp58_ = y;
		_tmp59_ = self->priv->keyboard_cursor;
		_tmp60_ = position_get_y (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp53_ = _tmp58_ == _tmp61_;
	} else {
		_tmp53_ = FALSE;
	}
	_tmp62_ = _tmp53_;
	if (_tmp62_) {
		result = TRUE;
		return result;
	}
	_tmp63_ = self->priv->keyboard_cursor;
	_tmp64_ = position_get_is_set (_tmp63_);
	_tmp65_ = _tmp64_;
	if (!_tmp65_) {
		Position* _tmp66_ = NULL;
		_tmp66_ = self->priv->keyboard_cursor;
		position_set_is_set (_tmp66_, TRUE);
		result = TRUE;
		return result;
	}
	_tmp67_ = self->priv->keyboard_cursor;
	_tmp68_ = x;
	_tmp69_ = y;
	_tmp70_ = g_new0 (gint, 2);
	_tmp70_[0] = _tmp68_;
	_tmp70_[1] = _tmp69_;
	_tmp71_ = _tmp70_;
	_tmp71__length1 = 2;
	position_set_position (_tmp67_, _tmp71_, 2);
	_tmp71_ = (g_free (_tmp71_), NULL);
	_tmp72_ = self->priv->selected;
	_tmp73_ = position_get_is_set (_tmp72_);
	_tmp74_ = _tmp73_;
	if (_tmp74_) {
		Position* _tmp75_ = NULL;
		Position* _tmp76_ = NULL;
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
		Position* _tmp79_ = NULL;
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint* _tmp82_ = NULL;
		gint* _tmp83_ = NULL;
		gint _tmp83__length1 = 0;
		_tmp75_ = self->priv->selected;
		_tmp76_ = self->priv->keyboard_cursor;
		_tmp77_ = position_get_x (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = self->priv->keyboard_cursor;
		_tmp80_ = position_get_y (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_new0 (gint, 2);
		_tmp82_[0] = _tmp78_;
		_tmp82_[1] = _tmp81_;
		_tmp83_ = _tmp82_;
		_tmp83__length1 = 2;
		position_set_position (_tmp75_, _tmp83_, 2);
		_tmp83_ = (g_free (_tmp83_), NULL);
	}
	result = TRUE;
	return result;
}


static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Position* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp24_ = FALSE;
	Minefield* _tmp25_ = NULL;
	Minefield* _tmp26_ = NULL;
	Position* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Position* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gboolean _tmp33_ = FALSE;
	Position* _tmp63_ = NULL;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	if (_tmp1_ != ((guint) GDK_KEY_space)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp12_ = NULL;
		Minefield* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = minefield_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = _tmp15_;
	}
	_tmp16_ = _tmp2_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->selected;
	_tmp19_ = position_get_is_set (_tmp18_);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		_tmp17_ = TRUE;
	} else {
		Position* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = self->priv->keyboard_cursor;
		_tmp22_ = position_get_is_set (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = !_tmp23_;
	}
	_tmp24_ = _tmp17_;
	if (_tmp24_) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp25_ = minefield_view_get_minefield (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_x (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->selected;
	_tmp31_ = position_get_y (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = minefield_is_cleared (_tmp26_, (guint) _tmp29_, (guint) _tmp32_);
	if (_tmp33_) {
		Position* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Position* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		Position* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		Position* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		_tmp34_ = self->priv->selected;
		_tmp35_ = position_get_x (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->selected;
		_tmp38_ = position_get_y (_tmp37_);
		_tmp39_ = _tmp38_;
		minefield_view_multi_release (self, (guint) _tmp36_, (guint) _tmp39_);
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_x (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->selected;
		_tmp44_ = position_get_y (_tmp43_);
		_tmp45_ = _tmp44_;
		minefield_view_redraw_adjacent (self, (guint) _tmp42_, (guint) _tmp45_);
	} else {
		Minefield* _tmp46_ = NULL;
		Minefield* _tmp47_ = NULL;
		Position* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		Position* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		FlagType _tmp54_ = 0;
		_tmp46_ = minefield_view_get_minefield (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->selected;
		_tmp49_ = position_get_x (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = self->priv->selected;
		_tmp52_ = position_get_y (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = minefield_get_flag (_tmp47_, (guint) _tmp50_, (guint) _tmp53_);
		if (_tmp54_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp55_ = NULL;
			Minefield* _tmp56_ = NULL;
			Position* _tmp57_ = NULL;
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			Position* _tmp60_ = NULL;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			_tmp55_ = minefield_view_get_minefield (self);
			_tmp56_ = _tmp55_;
			_tmp57_ = self->priv->selected;
			_tmp58_ = position_get_x (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = self->priv->selected;
			_tmp61_ = position_get_y (_tmp60_);
			_tmp62_ = _tmp61_;
			minefield_clear_mine (_tmp56_, (guint) _tmp59_, (guint) _tmp62_);
		}
	}
	_tmp63_ = self->priv->selected;
	position_set_is_set (_tmp63_, FALSE);
	result = FALSE;
	return result;
}


static guint minefield_view_get_mine_size (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	Minefield* _tmp5_ = NULL;
	Minefield* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN (_tmp0_ / ((gint) _tmp3_), _tmp4_ / ((gint) _tmp7_));
	result = (guint) _tmp8_;
	return result;
}


static guint minefield_view_get_x_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_y_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->height;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_minimum_size (MinefieldView* self) {
	guint result;
	guint w = 0U;
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint h = 0U;
	Minefield* _tmp3_ = NULL;
	Minefield* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint s = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	w = 320 / _tmp2_;
	_tmp3_ = minefield_view_get_minefield (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->height;
	h = 200 / _tmp5_;
	_tmp6_ = w;
	_tmp7_ = h;
	_tmp8_ = MIN (_tmp6_, _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if (_tmp9_ < ((guint) 30)) {
		s = (guint) 30;
	}
	_tmp10_ = s;
	result = _tmp10_;
	return result;
}


Minefield* minefield_view_get_minefield (MinefieldView* self) {
	Minefield* result;
	Minefield* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_minefield;
	result = _tmp0_;
	return result;
}


static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb (self, x, y);
}


static void _minefield_view_minefield___lambda2_ (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->_minefield;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = minefield_is_cleared (_tmp0_, _tmp1_, _tmp2_);
	if (_tmp3_) {
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp4_ = x;
		_tmp5_ = y;
		minefield_view_redraw_adjacent (self, _tmp4_, _tmp5_);
	}
}


static void __minefield_view_minefield___lambda2__position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	_minefield_view_minefield___lambda2_ (self, x, y);
}


static gint _minefield_view_minefield___lambda3_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = x;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda3__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda3_ (self, x);
	return result;
}


static gint _minefield_view_minefield___lambda4_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = y;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda4__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda4_ (self, y);
	return result;
}


static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = minefield_is_location (self, x, y);
	return result;
}


static gint _minefield_view_minefield___lambda5_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	_tmp0_ = x;
	_tmp1_ = self->priv->_minefield;
	_tmp2_ = _tmp1_->width;
	result = (gint) (_tmp0_ % _tmp2_);
	return result;
}


static gint __minefield_view_minefield___lambda5__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda5_ (self, x);
	return result;
}


static gint _minefield_view_minefield___lambda6_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	_tmp0_ = y;
	_tmp1_ = self->priv->_minefield;
	_tmp2_ = _tmp1_->height;
	result = (gint) (_tmp0_ % _tmp2_);
	return result;
}


static gint __minefield_view_minefield___lambda6__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda6_ (self, y);
	return result;
}


static gboolean _minefield_view_minefield___lambda7_ (MinefieldView* self, gint x, gint y) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


static gboolean __minefield_view_minefield___lambda7__position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = _minefield_view_minefield___lambda7_ (self, x, y);
	return result;
}


static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb (self, x, y);
}


static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	minefield_view_explode_cb (self, _sender);
}


static void _minefield_view_minefield___lambda8_ (MinefieldView* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __minefield_view_minefield___lambda8__minefield_paused_changed (Minefield* _sender, gpointer self) {
	_minefield_view_minefield___lambda8_ (self);
}


void minefield_view_set_minefield (MinefieldView* self, Minefield* value) {
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	Position* _tmp4_ = NULL;
	Position* _tmp5_ = NULL;
	Position* _tmp6_ = NULL;
	Position* _tmp7_ = NULL;
	Position* _tmp8_ = NULL;
	Position* _tmp9_ = NULL;
	Minefield* _tmp10_ = NULL;
	Position* _tmp11_ = NULL;
	Position* _tmp12_ = NULL;
	gint* _tmp13_ = NULL;
	gint* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	Position* _tmp15_ = NULL;
	Position* _tmp16_ = NULL;
	Position* _tmp17_ = NULL;
	Position* _tmp18_ = NULL;
	Minefield* _tmp19_ = NULL;
	Minefield* _tmp20_ = NULL;
	Minefield* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		_tmp1_ = self->priv->_minefield;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _minefield_ref0 (_tmp2_);
	_minefield_unref0 (self->priv->_minefield);
	self->priv->_minefield = _tmp3_;
	_tmp4_ = self->priv->selected;
	position_set_is_set (_tmp4_, FALSE);
	_tmp5_ = self->priv->selected;
	g_signal_connect_object (_tmp5_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp6_ = self->priv->selected;
	g_signal_connect_object (_tmp6_, "redraw", (GCallback) __minefield_view_minefield___lambda2__position_redraw, self, 0);
	_tmp7_ = self->priv->selected;
	g_signal_connect_object (_tmp7_, "set-x", (GCallback) __minefield_view_minefield___lambda3__position_set_x, self, 0);
	_tmp8_ = self->priv->selected;
	g_signal_connect_object (_tmp8_, "set-y", (GCallback) __minefield_view_minefield___lambda4__position_set_y, self, 0);
	_tmp9_ = self->priv->selected;
	_tmp10_ = self->priv->_minefield;
	g_signal_connect (_tmp9_, "validate", (GCallback) _minefield_is_location_position_validate, _tmp10_);
	_tmp11_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp11_, FALSE);
	_tmp12_ = self->priv->keyboard_cursor;
	_tmp13_ = g_new0 (gint, 2);
	_tmp13_[0] = 0;
	_tmp13_[1] = 0;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	position_set_position (_tmp12_, _tmp14_, 2);
	_tmp14_ = (g_free (_tmp14_), NULL);
	_tmp15_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp15_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp16_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp16_, "set-x", (GCallback) __minefield_view_minefield___lambda5__position_set_x, self, 0);
	_tmp17_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp17_, "set-y", (GCallback) __minefield_view_minefield___lambda6__position_set_y, self, 0);
	_tmp18_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp18_, "validate", (GCallback) __minefield_view_minefield___lambda7__position_validate, self, 0);
	_tmp19_ = self->priv->_minefield;
	g_signal_connect_object (_tmp19_, "redraw-sector", (GCallback) _minefield_view_redraw_sector_cb_minefield_redraw_sector, self, 0);
	_tmp20_ = self->priv->_minefield;
	g_signal_connect_object (_tmp20_, "explode", (GCallback) _minefield_view_explode_cb_minefield_explode, self, 0);
	_tmp21_ = self->priv->_minefield;
	g_signal_connect_object (_tmp21_, "paused-changed", (GCallback) __minefield_view_minefield___lambda8__minefield_paused_changed, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "minefield");
}


static void minefield_view_class_init (MinefieldViewClass * klass) {
	minefield_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinefieldViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = minefield_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = minefield_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = minefield_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = minefield_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = minefield_view_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = minefield_view_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->key_press_event = minefield_view_real_key_press_event;
	GTK_WIDGET_CLASS (klass)->key_release_event = minefield_view_real_key_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINEFIELD, param_spec_minefield ("minefield", "minefield", "minefield", TYPE_MINEFIELD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("look", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unlook", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_view_instance_init (MinefieldView * self) {
	self->priv = MINEFIELD_VIEW_GET_PRIVATE (self);
	self->priv->render_size = (guint) 0;
}


static void minefield_view_finalize (GObject* obj) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD_VIEW, MinefieldView);
	_g_object_unref0 (self->priv->keyboard_cursor);
	_g_object_unref0 (self->priv->selected);
	_cairo_pattern_destroy0 (self->priv->flag_pattern);
	_cairo_pattern_destroy0 (self->priv->mine_pattern);
	_cairo_pattern_destroy0 (self->priv->question_pattern);
	_cairo_pattern_destroy0 (self->priv->bang_pattern);
	_cairo_pattern_destroy0 (self->priv->warning_pattern);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	_minefield_unref0 (self->priv->_minefield);
	G_OBJECT_CLASS (minefield_view_parent_class)->finalize (obj);
}


GType minefield_view_get_type (void) {
	static volatile gsize minefield_view_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinefieldView), 0, (GInstanceInitFunc) minefield_view_instance_init, NULL };
		GType minefield_view_type_id;
		minefield_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "MinefieldView", &g_define_type_info, 0);
		g_once_init_leave (&minefield_view_type_id__volatile, minefield_view_type_id);
	}
	return minefield_view_type_id__volatile;
}


static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		value_set_minefield (value, minefield_view_get_minefield (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		minefield_view_set_minefield (self, value_get_minefield (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



